/*
 * (c) Copyright Trilog Group 2004-2012. All Rights Reserved.
 */

/********************************Class TypeAhead*****************************************/
	function typeAhead(contextPath, dataUrl,localizationLanguage,textBoxId,dbName,viewId,subQuery,columnsName,rowCount,transactionType)
	{
		this.contextPath = contextPath;
		this.minInputLength = 0;
		this.listIndex = 0;
		this.dbName = dbName;
		this.viewId = viewId;
		this.columnsName = columnsName;   
		this.subQuery = subQuery;
		this.textBoxPosition = false;
		this.textBoxId = textBoxId;
		this.maximumDisplayedItems = 50;
		this.minimumDisplayedItems = 10;
		this.setTimeOut			   = '';       //global timer for setTimeout
		this.setTimeOut2		   = '';	   //second global timer for setTimeout
		this.listId = "typeAheadList";
		this.divId = "typeAheadDiv";
		this.footerDivId = "typeAheadFooterDiv";
		this.footerPagingId = "typeAheadFooterPaging";
		this.footerBrowserId = "typeAheadFooterBrowser";
		this.displayBrowser = "true";
		this.linkIdNext = "tg_tgweb20_typeahead_lowerNext";
		this.linkIdPrevious = "tg_tgweb20_typeahead_lowerPrevious";
		this.linkId10 = "tg_tgweb20_typeahead_firstPage";
		this.linkId20 = "tg_tgweb20_typeahead_secondPage";
		this.linkIdAll = "tg_tgweb20_typeahead_AllPage";
		this.parentId = "";
		this.filteredArray = Array[0];
		this.displayFooter = "false"; 
		this.dataUrl = dataUrl;
		this.transactionType = transactionType;
		(rowCount != '')?this.rowCount = rowCount:this.rowCount = 10;
		this.indexArray = Array[0];
		this.initRowCount = this.rowCount;
		this.handleOnAfterClickFunction = null;
		this.firstEntryTodisplay = 0;
		this.indexArray = "10,20";
		this.totalEntries = 0;
		this.ajaxResponseArray = Array[0];
		this.valueSelected="";
		this.allowOnlyValuesFromList = false;

		
		function typeAheadList(dataURL)
		{
			this.dataURL = dataURL;
		}
		
		//Gets the data Url
		this.getDataUrl = function()
		{
			return this.dataUrl;
		}

		//Gets transaction type
		this.getTransactionType = function()
		{
			return this.transactionType;
		}
		
		
		//Gets the ID of the first paging link(10 items to be displayed)
		//in the typeAhead Footer
		this.getLinkId10 = function()
		{
			return this.linkId10;
		}


		//Gets the ID of the second paging link(20 items to be displayed)
		//in the typeAhead Footer
		this.getLinkId20 = function()
		{
			return this.linkId20;
		}

		
		//Gets the ID of the last paging link(all items to be displayed)
		//in the typeAhead Footer
		this.getLinkIdAll = function()
		{
			return this.linkIdAll;
		}
		

		//Gets the "Previous" Link ID
		this.getLinkIdPrevious = function()
		{
			return this.linkIdPrevious;
		}

		
		//Gets the "Next" Link ID
		this.getLinkIdNext = function()
		{
			return this.linkIdNext;
		}
		
		//Gets the db Name
		this.getDbName = function()
		{
			return this.dbName;
		}
		
		
		//Gets the view Id
		this.getViewId = function()
		{
			return this.viewId;
		}
		
		//Gets the columns Name
		this.getColumnsName = function()
		{
			return this.columnsName;
		}

			
		//Gets the browser Id
		this.getFooterBrowserId = function()
		{
			return this.footerBrowserId;
		}

		//Gets the footer List Id
		this.getFooterPagingId = function()
		{
			return this.footerPagingId;
		}		
		
		
		//Gets the footer List Id
		this.getFooterDivId = function()
		{
			return this.footerDivId;
		}	
		
		
		//Gets the subQuery
		this.getSubQuery = function()
		{
			return this.subQuery;
		}
		
		//Sets the filtered array 
		//displaying the items at the time 
		//of typing
		this.setFilteredArray = function(filterArray)
		{
			this.filteredArray = filterArray;
		}
					
		//Sets the variable indicating 
		//whether to show the index letting the user 
		//chose the number of result items to display
		this.setDisplayFooter = function(displayFooter,indexArray)
		{
			this.displayFooter = displayFooter;
			//this.indexArray = indexArray;
		}


		//Sets the variable indicating 
		//whether to show the "Previous|Next" footer
		//at the bottom of the list
		this.setDisplayBrowser = function(displayBrowser)
		{
			this.displayBrowser = displayBrowser;
		}
		
		
		//Sets the minimum number of displayed items
		//in the typeahead list
		this.setRowCount = function(rowCount)
		{
			this.rowCount = rowCount;
		}
		

		
		//Sets the minimum number of displayed items
		//in the typeahead list
		this.setMinimumDisplayed = function(minimumDisplayed)
		{
			this.minimumDisplayedItems = minimumDisplayed;
		}
		
		//Sets Type Ahead Parent Id
		this.setParentId = function(_parentId){
			this.parentId = _parentId;
		}
		

		//Gets the textBoxId
		this.getTextBoxId = function()
		{
			return this.textBoxId;
		}

		//Gets the minimumDisplayed value
		this.getMinimumDisplayed = function()
		{
			return this.minimumDisplayedItems;
		}
		
		//Gets Type Ahead Parent Id
		this.getParentId = function()
		{
			return this.parentId;
		}			
		
		//Gets the textBoxId
		this.getDivId = function()
		{
			return this.divId;
		}
		
		
		//sets the minimum length of input characters
		//required to start a type ahead search
		this.setMinInputLength = function(numCharacters)
		{
			this.minInputLength = numCharacters;
		}
		
		//Gets the minInputLength
		this.getMinInputLength = function()
		{
			return this.minInputLength;
		}
		
		
		//Gets the listId
		this.getListId = function()
		{
			return this.listId;
		}


		this.setTypeAheadObject = function(_typeAheadObject){
			// ignore, always this
			//this.typeAheadObject = _typeAheadObject;
		}

						
		//Sets the given onAfterClick function
		this.setOnAfterClickEvent = function(func)
		{
			this.handleOnAfterClickFunction = func;
		}

		
		//Returns typeAheadWidget
		this.getTypeAheadWidget = function()
		{
			return this.typeAheadWidget;
		}
		
		this.setTypeAheadWidget = function(typeAheadWidget)
		{
			this.typeAheadWidget = typeAheadWidget;
		}
		
		//Returns typeAheadWidget
		this.getTypeAheadListWidget = function()
		{
			return this.typeAheadListWidget;
		}
		
		this.setTypeAheadListWidget = function(typeAheadListWidget)
		{
			this.typeAheadListWidget = typeAheadListWidget;
		}
		
		this.setAllowOnlyValuesFromList = function(allowOnlyValuesFromList) {
			this.allowOnlyValuesFromList = allowOnlyValuesFromList;
		}	
		
		        	   
		/*Method that adds a typeAheadList*/
		function addTypeAheadList(list, dataURL){
			var newTypeAheadList = new typeAheadList(dataURL);		
			list.typeAheadList = newTypeAheadList;
		}        	   
			
		this.onLoadEvent = function(){
			dojo.require("dojo.i18n");
			var contextPath =  this.contextPath;
			if (contextPath.lastIndexOf("/") != contextPath.length-1) {
				contextPath = contextPath+"/";
			}	
			
			dojo.registerModulePath("projexec.typeahead", contextPath+"tgweb20");
			dojo.requireLocalization("projexec.typeahead", "tgweb20");
			this.typeAheadNls = dojo.i18n.getLocalization("projexec.typeahead", "tgweb20");
				
				/*Ici, il faut charger la liste de 
				  l'appel AJAX, d'apres la fonction fournie "listFunction", et mettre le resultat dans 
				  listArray
				*/			
				//typeAheadWidget = dojo.byId(this.getTextBoxId());
				addTypeAheadList(this,this.dataUrl);
				typeAheadWidget = dojo.query(this.getTextBoxId())[0]; // TODO Laurent: don't think it will work. What is the goal?
				drawTypeAhead(this);
				this.setMinInputLength(1);
				this.setTypeAheadWidget(typeAheadWidget);
				onKeyUpEvent(this);
				onKeyPressEvent(this);
				onKeyEnterEvent(this);
				onClickBodyEvent(this);
				onMouseOverListEvent(this);
		}	
		
		function onClickBodyEvent(list)
		{	
			
			dojo.connect(document.body,"onclick",function(evt){
						if (dojo.byId(list.getDivId()) != null){
							initListParam(list);	
							if (list.allowOnlyValuesFromList && list.valueSelected=="false") {
								// value not selected and writting in the input -> clear input
								var inputElement = dojo.byId(list.getTextBoxId());
								if (inputElement && inputElement.value) {
									inputElement.value = '';
									list.valueSelected = "";
								}	
							}		
							dojo.attr(dojo.byId(list.getDivId()), "style", {
												display: "none"
											});
							//dojo.destroy(dojo.byId(list.getDivId()));
							
							// TODO if selection in progress, what to do? accept or cancel?
							// at least do something
						}
					});
		}
		

		
		function onKeyUpEvent(list)
		{	
	
	
			//dojo.addOnLoad(function(){				
			var result;
			dojo.connect(this.typeAheadWidget, "onkeypress", function(evt) {	
				list.valueSelected="false";
				//alert("typeahead widget.........." + list.typeAheadWidget.value);
				try { 					
				if (result) clearTimeout(result); 
				var result = setTimeout(function(){
				var displayDiv = dojo.style(dojo.byId(list.getDivId()), "display");
				if (list.displayFooter == "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
					dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "block"
											});
											
				//dojo.query("#"+ list.getListId() + "")[0].removeClass('tgTypeAheadListBorder');								
				//dojo.query("#"+ list.getListId() + "")[0].addClass('tgMenuTypeAhead');							
											
				}else if (list.displayFooter != "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
							dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "none"
							});
							
				//dojo.query("#"+ list.getListId() + "")[0].addClass('tgTypeAheadListBorder');			
				}

				if(window.evt){ 
					key = evt.keyCode; 
				}else if(evt && evt.which){ 
					key = evt.which; 
				}
				switch(key){ 
	 	                                case dojo.keys.DOWN_ARROW:
												if (displayDiv != "none"){
	 	                                        	handleDownArrow(list,evt.target);
												}
	 	                                        break; 
	 	                                case dojo.keys.UP_ARROW:
												if (displayDiv != "none"){
														handleUpArrow(list);
												}
	 	                                        break;
	 	                                case dojo.keys.RIGHT_ARROW:
	 	                                        return;
	 	                                        break;
	 	                                case dojo.keys.LEFT_ARROW:
	 	                                        return;
	 	                                        break;
										case dojo.keys.ENTER:
												if (displayDiv != "none"){
													handleEnterEvent(list);
												}
												break;
										case dojo.keys.NUMPAD_ENTER:
												if (displayDiv != "none"){
													handleEnterEvent(list);
												}
												break; 
										case dojo.keys.ESCAPE:
												if (displayDiv != "none"){
													handleEscapeEvent(list);
												}
												break; 
										case dojo.keys.BACKSPACE:
													initListParam(list);
													onTimeOutHandle(list);
												break; 														
	 	                                default:
												var inputValueCurrent = list.typeAheadWidget.value;
												var inputValueLength = inputValueCurrent.length;
													if (inputValueLength >= list.getMinInputLength()){
														initListParam(list);															
														onTimeOutHandle(list);
													}
	 	                                        break;   
	 	                } 	  	    
					},300);
					}catch(e){} finally{return true;} 
  			     	}
					);
			
	}
	
	
	function onTimeOutHandle(thisList){
						var inputValueCurrent = thisList.getTypeAheadWidget().value;
						thisList.setMinInputLength(1);
						//if (inputValueCurrent.length >= thisList.getMinInputLength()){
							dojo.empty(dojo.byId(thisList.getListId()));
							var typeAheadObject = thisList;
							//if(thisList.typeAheadList.onKeyUpFunction){
									showLoadingDiv(thisList);
									if(thisList.setTimeOut == '' && thisList.setTimeOut2 == ''){
										//thisList.setTimeOut = setTimeout(function(){thisList.typeAheadList.onKeyUpFunction(typeAheadObject)},1000);
										thisList.setTimeOut = setTimeout(function(){dealKeyUp(typeAheadObject)},500);
									}else{
										if(thisList.setTimeOut != ''){
											killFirstActivateSecondThread(typeAheadObject); 	//reset timeout and its var
										}else{
											killSecondActivateFirstThread(typeAheadObject); 	//reset timeout and its var
										}
									}
							//}
						//}
	}
	
	function onMouseOverListEvent(list){			
		dojo.connect(list.typeAheadListWidget, "onmouseover", function(evt) {													  											   																		
					var target;
					if (!evt){ 
						var evt = window.event;
					}
					if (evt.target){
						target = evt.target;
					}else if (evt.srcElement){
						target = evt.srcElement;
					}												
					handleMouseOver(list,target);
				});
	}
	
	//function onMouseEnterEvent(list){
		//dojo.connect(this.typeAheadWidget, "onmouseenter", function(evt) {													  											   
			//		if (list.typeAheadWidget.value != " " && list.typeAheadWidget.value.length != 0){
				//		dealKeyUp(list);
					//}
				//});
	//}
	
	function showLoadingDiv(list){
		var option = dojo.doc.createElement("span");
		option.innerHTML = list.typeAheadNls.loading+"...";
		dojo.attr(option, "style", {
						padding: "5px",
						backgroundColor : "#FEFEBB",
						color : "#000000"
					});
		dojo.attr(option, "id", "idLoading");
		/*var option = document.createElement("option");
		option.innerHTML = "Loading";
		option.style.border = "1px solid #ccc";*/
		dojo.query("#"+ list.getListId() + "")[0].appendChild(option);
		//document.getElementById(list.getListId()).appendChild(option);
	}	

	
	function killFirstActivateSecondThread(thisList){
		clearTimeout(thisList.setTimeOut); 	//reset timeout and its var
		thisList.setTimeOut = '';
		thisList.setTimeOut2 = setTimeout(function(){dealKeyUp(thisList)},500);
	}
	
	function killSecondActivateFirstThread(thisList){
		clearTimeout(thisList.setTimeOut2); 	//reset timeout and its var
		thisList.setTimeOut2 = '';
		thisList.setTimeOut = setTimeout(function(){dealKeyUp(thisList)},500);
	}
	
		/*onKeyUp detailed handling of the event*/
	function dealKeyUp(thisList){
			var inputValue = dojo.byId(thisList.getTextBoxId()).value;
      inputValueInit = inputValue;
			thisList.setRowCount(thisList.initRowCount);
      dojo.empty(dojo.byId(thisList.getListId()));
			handleAjaxCallKeyUp(thisList,inputValue);							
	}
	
	//function arrangeNavigator(list,linkId10,linkId20,linkIdAll,linkIdPrevious,linkIdNext,total,first,count){
		function arrangeNavigator(list,total,first,count,inputValue){
		//10linkId
		//20linkId
		//alllinkId
		//linkIdPrevious
		//linkIdNext
		//displayed
		var linkIdNext = "tg_tgweb20_typeahead_lowerNext";
		var linkIdPrevious = "tg_tgweb20_typeahead_lowerPrevious";
		var linkId10 = "tg_tgweb20_typeahead_firstPage";
		var linkId20 = "tg_tgweb20_typeahead_secondPage";
		var linkIdAll = "tg_tgweb20_typeahead_AllPage";

		var linkObj10 = document.getElementById(linkId10);
		var linkObj20 = document.getElementById(linkId20);
		var linkObjAll = document.getElementById(linkIdAll);
		var linkObjPrevious = document.getElementById(linkIdPrevious);
		var linkObjNext = document.getElementById(linkIdNext);
		
		/*
		linkObj10.setAttribute("disable","false");
		linkObj20.setAttribute("disable","false");			
		linkObjAll.setAttribute("disable","false");
		linkObjPrevious.setAttribute("disable","false");
		linkObjNext.setAttribute("disable","false");*/
		
		var total = parseInt(total);
		list.totalEntries = total;
		
		var first = parseInt(first);
		var count = parseInt(count);
		
		
		var diff1 = total - first;
		var diff2 = count - first;
		
		
		//alert("count  avan " + count);
		if (diff1 < count){
			count = diff1;
		}	
		
		var sum1 = first + count;
		
		//alert("count apre " + count);
		//alert("total   " + total);
		 
		var footerVisible = true; 
		
		if (total == count){
			//alert("dans condsitirytron");
			//alert("list.rowCount " + list.rowCount);
			//alert("list.totalEntries >= 20s " + list.totalEntries >= 20);
			if((list.rowCount==10) && (list.totalEntries < 10)){
				footerVisible = false;
				disableLiLink(linkObj10);
  			}else{
				enableLiLink(list,linkObj10,inputValue);
			}	
  		//for 20
 				 if (list.rowCount==20){
				disableLiLink(linkObj20);
			}else{
				enableLiLink(list,linkObj20,inputValue);
			}
			
			if (footerVisible == false){
				//alert("footer visible false   ");
				dojo.attr(dojo.query("#"+ list.getFooterDivId() + "")[0], "style", {
												display: "none"
											});								
				dojo.removeClass(dojo.query("#"+ list.getListId() + "")[0], "tgMenuTypeAhead");
				dojo.query("#"+ list.getListId() + "")[0].className += " ";
				dojo.query("#"+ list.getListId() + "")[0].className += "tgMenuTypeAhead_bottomBorder";	
			}else{	
  				disableLiLink(linkObjAll);
  				disableLiLink(linkObjPrevious);
  				disableLiLink(linkObjNext);
			}
			
		}else if((total < count) && (list.rowCount==10)){
			//alert("total   " + total);
			//alert("count   " + count);
			//alert(list.rowCount);
			dojo.attr(dojo.query("#"+ list.getFooterDivId() + "")[0], "style", {
												display: "none"
											});								
			dojo.removeClass(dojo.query("#"+ list.getListId() + "")[0], "tgMenuTypeAhead");
			dojo.query("#"+ list.getListId() + "")[0].className += " ";
			dojo.query("#"+ list.getListId() + "")[0].className += "tgMenuTypeAhead_bottomBorder";				
		}else if(total > count){
  			//for 10
			if(dojo.hasClass(dojo.query("#"+ list.getListId() + "")[0], "tgMenuTypeAhead_bottomBorder")){
				dojo.removeClass(dojo.query("#"+ list.getListId() + "")[0], "tgMenuTypeAhead_bottomBorder");
				dojo.query("#"+ list.getListId() + "")[0].className += " ";
				dojo.query("#"+ list.getListId() + "")[0].className += "tgMenuTypeAhead";
				dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "block"
											});
			}
  			if((list.rowCount==10) || (list.totalEntries < 10)){
  				//enableLiLink(list,linkObj10,inputValue);
				disableLiLink(linkObj10);
  			}else{
  				//disableLiLink(linkObj10);
				enableLiLink(list,linkObj10,inputValue);
			}	
  		//for 20
 				 if(list.rowCount==20){
				disableLiLink(linkObj20);
			}else{
				enableLiLink(list,linkObj20,inputValue);
			}	

  		//for All
  			enableLiLink(list,linkObjAll,inputValue);
  		//for Previous
  			if(first==0){
      			disableLiLink(linkObjPrevious);
  			}else{
      			enableLiLink(list,linkObjPrevious,inputValue);
  			}
  		//for Next
  			//if(count-first < total){
			if (sum1 < total){ 
				//alert("count  " + count);
				//alert("first    " + first);
				//alert("total   " + total);
				//alert("enable next");
      			enableLiLink(list,linkObjNext,inputValue);
  			}else if (sum1 == total ){
				//alert("disable next");
				//alert("count  " + count);
				//alert("first    " + first);
				//alert("total   " + total);
      			disableLiLink(linkObjNext);
  			}
	 	}
	}
	
	
	
	function enableLiLink(list,obj,inputValue){
		var disabled = obj.getAttribute("disable");
		//alert("enable.......... " + obj.innerHTML);
		if(disabled=="true"){
  		var backuponclick = obj.getAttribute("backup-onclick");
  		var innerValue = obj.innerHTML;
		obj.innerHTML = "";
  		var newALink = document.createElement("a");
		newALink.setAttribute("href","javascript:;");			
		newALink.innerHTML = innerValue;
		newALink.onclick = function(){
			if (newALink.innerHTML == "Previous"){
				list.firstEntryTodisplay = list.firstEntryTodisplay - list.rowCount;
			}else if (newALink.innerHTML == "Next"){
				list.firstEntryTodisplay = list.firstEntryTodisplay + list.rowCount;
			}else if (newALink.innerHTML == "All"){
				list.firstEntryTodisplay = 0;
				list.rowCount = list.totalEntries;
			}else if (newALink.innerHTML == "10"){
				list.firstEntryTodisplay = 0;
				list.rowCount = "10";
			}else if (newALink.innerHTML == "20"){
				list.firstEntryTodisplay = 0;
				list.rowCount = "20";
			}	
			return new Function(handleLinkOnClick(list,obj,inputValue));
		};			
  		newALink.innerHTML = innerValue;
  		obj.appendChild(newALink);
		}
		obj.setAttribute("disable","false");
	}
	
	
	
	function disableLiLink(obj){
		var disabled = obj.getAttribute("disable");
		if(disabled!="true"){
  		var aLink = obj.firstChild;
  		if(aLink!=null){
      		var aLinkValue = aLink.innerHTML;
      		obj.setAttribute("backup-onclick",aLink.onclick);
			//obj.setAttribute("backup-onclick",aLink.getAttribute("onclick"));
			obj.removeChild(aLink);
      		obj.innerHTML = aLinkValue;
 				}
		}
		obj.setAttribute("disable","true");
	}
	
	
			  
	function drawList (thisList,inputValue, arr,total,first,count){
		//alert("dans draw list..........");
		var inputLength = inputValue.length;
		dojo.empty(dojo.byId(thisList.getListId()));
		
		thisList.ajaxResponseArray = arr;

		var linkId10 = thisList.getLinkId10();
		var linkId20 = thisList.getLinkId20();
		var linkIdAll = thisList.getLinkIdAll();
		var linkIdPrevious = thisList.getLinkIdPrevious();
		var linkIdNext = thisList.getLinkIdNext();
		
		
		//arrangeNavigator(linkId10,linkId20,linkIdAll,linkIdPrevious,linkIdNext,total,first,count)
		//arrangeNavigator(thisList,linkId10,linkId20,linkIdAll,linkIdPrevious,linkIdNext,total,first,count);
		//arrangeNavigator(thisList,total,first,count,inputValue);
			
		// Why do we filter the list of result returned by the server ?
		// by doing this if all search attributes on server are not displayed here we may restrict displayed list.
		// for example if do typeahead for user and display CN but search on CN and email, user found by email but not by CN will not be displayed
			  var filteredArr = dojo.filter(arr, function(item) {
								thisList.setMinInputLength(1);
								if (inputLength >= thisList.getMinInputLength()){
										//return item.country.substr(0,inputLength).toLowerCase() == inputValue.toLowerCase();
										var inputVal = inputValue.toLowerCase();
										inputVal = inputVal.replace('<','&lt;');
										inputVal = inputVal.replace('>','&gt;');
										var x = item.label.toLowerCase().indexOf(inputVal);
										return item.label.toLowerCase().indexOf(inputVal) != -1;
								}else{
									dojo.empty(dojo.query("#" + thisList.getListId() + ""));
									dojo.attr(dojo.query("#" + thisList.getListId() + ""), "style", {
												display: "none"
											});
								}
							});
							
							thisList.setFilteredArray(filteredArr);
							
							dojo.attr(dojo.byId(thisList.getDivId()), "style", {
									display: "block"
							});
											
							
							var filteredArrLength = filteredArr.length;
							if (filteredArrLength == 0 && inputLength != 0){
								var span = document.createElement("span");
								//alert("yih");
								//alert(thisList.viewId);
								span.innerHTML = thisList.typeAheadNls.noresults;
								dojo.byId(thisList.getListId()).appendChild(span);
								if(dojo.isIE < 8){
									span.className = "tgSpanTypeAhead";
								} else {
									span.setAttribute("class", "tgSpanTypeAhead");
								}
							}
							
							if (inputLength == 0){
								//dojo.destroy(dojo.byId(typeAheadObject.getDivId()));
								dojo.attr(dojo.byId(thisList.getDivId()), "style", {
										//visibility: "hidden"
										display: "none"
								});
								dojo.empty(dojo.byId(thisList.getListId()));		
							}
		            
							dojo.forEach(filteredArr, function(item, i) {
									var option = dojo.doc.createElement("li");
									var optionValue = item.label;
									optionValue = optionValue.replace('&lt;','<');
									optionValue = optionValue.replace('&gt;','>');
									var mailStartIndex = optionValue.indexOf('<');
									var typedValueStartIndex = optionValue.toLowerCase().indexOf(inputValue.toLowerCase());
									var typedValueEndIndex = typedValueStartIndex + inputLength;
									var typedValue = "";
									/*if (typedValueStartIndex == 0){
										typedValue = item.label.substr(typedValueStartIndex,inputLength);
									}else{
										typedValue = item.label.substr(typedValueStartIndex,inputLength);
									}*/
									
									typedValue = optionValue.substr(typedValueStartIndex,inputLength);

									var firstPartValue = optionValue.substr(0,typedValueStartIndex);
									var secondPartValue = optionValue.substr(typedValueEndIndex);
									
									//if (firstPartValue.length != 0){
									 if (typedValueStartIndex > mailStartIndex){
										option.innerHTML = firstPartValue + "<b>" + typedValue + "</b>" + secondPartValue;	
									}else{
										secondPartValue = secondPartValue.replace('<','&lt;');
										secondPartValue = secondPartValue.replace('>','&gt;');
										option.innerHTML = firstPartValue + "<b>" + typedValue + "</b>" + secondPartValue;
									}

									dojo.attr(option, "id", "item" + i.toString());
									dojo.attr(option,"style",{
													noWrap : "true"
											  });	
									dojo.byId(thisList.getListId()).appendChild(option);  
							 });
							
							var ulObject = dojo.query("#"+thisList.getListId()+" > *");
							
							if(ulObject.length > 0) {
								var textBoxWidth = dojo.style(dojo.query(thisList.getTextBoxId())[0],"width");
								var node1 = ulObject[0];
								var coords1 = dojo.coords(node1);

								if(thisList.getMinimumDisplayed() != "" && thisList.getMinimumDisplayed() != 0 && filteredArrLength < thisList.getMinimumDisplayed() && filteredArrLength!=0){
									//alert("condition1.........");
									dojo.byId(thisList.getListId()).style.height = (filteredArrLength*coords1.h)+"px"  ;
									dojo.byId(thisList.getDivId()).style.height = (filteredArrLength*coords1.h)+"px"  ;
									dojo.byId(thisList.getListId()).style.minWidth = textBoxWidth + "px"  ;
									dojo.byId(thisList.getDivId()).style.minWidth = textBoxWidth + "px" ;
									if(dojo.isIE<8){										
										dojo.byId(thisList.getDivId()).style['overflowY'] = 'hidden' ;
										dojo.byId(thisList.getDivId()).style['overflowX'] = 'hidden' ;
									}
								}else if (thisList.getMinimumDisplayed() != "" && thisList.getMinimumDisplayed() != 0 && filteredArrLength >= thisList.getMinimumDisplayed()){ 
									//alert("condition2.........");
									dojo.byId(thisList.getListId()).style.height = (thisList.getMinimumDisplayed()*coords1.h)+"px"  ;
									dojo.byId(thisList.getDivId()).style.height = (thisList.getMinimumDisplayed()*coords1.h)+"px"  ;
									dojo.byId(thisList.getListId()).style.minWidth = textBoxWidth + "px"  ;
									dojo.byId(thisList.getDivId()).style.minWidth = textBoxWidth + "px" ;
									if(dojo.isIE<8){
										dojo.byId(thisList.getDivId()).style['overflowY'] = 'auto' ;
										dojo.byId(thisList.getDivId()).style['overflowX'] = 'auto' ;
									}
								}else{
									//alert("condition3.........");
									dojo.byId(thisList.getListId()).style.height = "auto"  ;
									dojo.byId(thisList.getDivId()).style.width = "auto"  ;
								}
							}
						 	
							
							//var divFooterWidth = dojo.style(dojo.query(thisList.getTextBoxId())[0],"width");
							//alert("node");
							var node = thisList.getListId();
							//alert("node ap");
							var coords = dojo.coords(thisList.getListId());
								
							
							/*dojo.attr(dojo.query("#" + thisList.getFooterListId() + ""), "style", {
											top: getYFromBody(node)+"px"
										});	
							dojo.attr(dojo.query("#" + thisList.getFooterListId() + ""), "style", {
											minWidth: divFooterWidth +"px"
										});*/
										
							/*dojo.attr(dojo.byId(thisList.getFooterDivId()), "style", {
												top: getYFromBody(node)+"px"
											});	
							dojo.attr(dojo.byId(thisList.getFooterDivId()), "style", {
												minWidth: divFooterWidth +"px"
											});*/				

							
							//dojo.byId(thisList.getFooterId()).style.top = coords.h + getYFromBody(node) +"px";
							//dojo.byId(thisList.getFooterId()).style.minWidth = divFooterWidth + "px" ;
							
							//dojo.query("#" + typeAheadObject.getListId() + " >li").onclick(function(evt){onClickFunction(evt,typeAheadObject,this)});
							
							
							dojo.query("#" + thisList.getListId() + " > li").connect("onclick",function(evt){								
							//var targetString = evt.target.innerHTML; 	
							var targetString = "";
							var htmlContent = evt.target.innerHTML;								
							if(htmlContent.indexOf("<b class=\"tgMenuItemSelected\">") != -1 || htmlContent.indexOf("<B class=\"tgMenuItemSelected\">") != -1 || htmlContent.indexOf("<b class=tgMenuItemSelected>") != -1 || htmlContent.indexOf("<B class=tgMenuItemSelected>") != -1){																	
								targetString = htmlContent;
								//if(dojo.isIE)
									targetString = targetString.replace(' class=tgMenuItemSelected','');									
								//else
									targetString = targetString.replace(' class=\"tgMenuItemSelected\"','');									
							}
							else{									
								targetString = evt.target.parentNode.innerHTML;	
								//if(dojo.isIE)
									targetString = targetString.replace(' class=tgMenuItemSelected','');									
								//else
									targetString = targetString.replace(' class=\"tgMenuItemSelected\"','');									
							}
							
							handleOnClickFunction(evt,thisList,evt.target);								
							if (thisList.handleOnAfterClickFunction != null){thisList.handleOnAfterClickFunction(targetString,thisList.textBoxId,arr[thisList.listIndex - 1])}});
							var textBoxNode = dojo.query(thisList.getTextBoxId())[0];
							var node = dojo.byId(textBoxNode.id);
							var coords = dojo.coords(node);
							dojo.byId(thisList.getDivId()).style.top = coords.h+getYFromBody(node)+"px";
							dojo.byId(thisList.getDivId()).style.left = getXFromBody(node) +"px";
							//alert("dojo.byId(thisList.getDivId()).style.left........." + dojo.byId(thisList.getDivId()).style.left);
							
							var scrollTop = 0;
							var scrollLeft = 0;								
							if(thisList.getParentId() != ""){
								if(document.getElementById(thisList.getParentId())){
									scrollTop = document.getElementById(thisList.getParentId()).scrollTop;
									scrollLeft = document.getElementById(thisList.getParentId()).scrollLeft;
								}
							}
							dojo.byId(thisList.getDivId()).style.top = (coords.h+getYFromBody(node) - scrollTop)+"px" ;								
							dojo.byId(thisList.getDivId()).style.left = (getXFromBody(node) - scrollLeft)+"px";
							if(dojo.isIE < 8 ) dojo.byId(thisList.getDivId()).style.borderBottom = "#aaaaaa 1px solid ";
							
							//if(dojo.isIE < 8 && thisList.getMinimumDisplayed() != "" && thisList.getMinimumDisplayed() != 0 && filteredArrLength >= thisList.getMinimumDisplayed()){
							/*if(dojo.isIE < 8 ){	
								dojo.byId(thisList.getDivId()).style.top = (coords.h+getYFromBody(node) - scrollTop) + 1+"px";
								dojo.byId(thisList.getDivId()).style['overflowY'] = 'auto' ;
								dojo.byId(thisList.getDivId()).style['overflowX'] = 'auto' ;
								dojo.byId(thisList.getDivId()).style.border = "#aaaaaa 1px solid ";
								dojo.byId(thisList.getDivId()).style.position = "absolute";
								dojo.byId(thisList.getDivId()).style.backgroundColor = "white";
							}*/
							
							
		  }
		
	function handleAjaxCallKeyUp(list,inputValue){
		//alert("handleeeeeeeee " + list.viewId);
		var variable = 1;
		var dataUrl = list.getDataUrl();
		var transactionType = list.getTransactionType();
		var dbName = list.getDbName();
		var viewId = list.getViewId();
		var subQuery = list.getSubQuery();
		var typeAheadValue = dojo.byId(list.getTextBoxId()).value;
		var typeAheadValueLower = typeAheadValue.toLowerCase();
		subQuery += "'*" + typeAheadValueLower.replace("'", "\\'") + "*'";
		var firstEntry = list.firstEntryTodisplay;
		var itemCountServerSide = list.rowCount;
		//alert("itemCountServerSide  uffff " + itemCountServerSide);
		var remainingEntries = list.totalEntries - firstEntry;
		var urlPath = "";
		if ((remainingEntries < list.rowCount) && (list.totalEntries!=0)){
			itemCountServerSide = remainingEntries;
		}
		var columnsName = list.getColumnsName();
		var jsonObj = new Array();
		var typeAheadValue = dojo.byId(list.getTextBoxId()).value;
					
		if(transactionType==null || transactionType== "" || transactionType=="view"){
			urlPath = dataUrl + "?dbName=" + dbName + "&viewId=" + viewId + "&subQuery=" + encodeURIComponent(subQuery) + "&columnsName=" + columnsName + "&minimumDisplayed=" + itemCountServerSide + "&firstEntry=" + firstEntry+ "&transactionType=view";
		} else if(transactionType=="function") {
			if(dataUrl.indexOf("?") > 0){
				urlPath = dataUrl + "&";
			} else {
				urlPath = dataUrl + "?";
			}
			urlPath+="transactionType=function&filter=" + encodeURIComponent(typeAheadValueLower)+"&columnName=" + columnsName;
		} 
		var xhrArgs = {
				//url: dataUrl + "?dbName=" + dbName + "&viewId=" + viewId + "&subQuery=" + encodeURIComponent(subQuery) + "&columnsName=" + columnsName + "&minimumDisplayed=" + itemCountServerSide + "&firstEntry=" + firstEntry,
				url: urlPath,
				handleAs: "xml",
				load: function(data) {
					var doc = data.documentElement;
					var status = doc.getElementsByTagName("status");
					var total = status[0].getElementsByTagName("Total")[0].firstChild.nodeValue;
					var first = status[0].getElementsByTagName("First")[0].firstChild.nodeValue;
					var count = status[0].getElementsByTagName("Count")[0].firstChild.nodeValue;
						

						
					var allEntry = doc.getElementsByTagName("entry");
					for (i=0;i<allEntry.length;i++){
							var entryy = allEntry[i].childNodes[0].nodeValue;
							jsonObj[i] =  eval("(" + entryy + ")");
					}
						
						 drawList(list,inputValue,jsonObj,total,first,count);
					},
					error: function(response, ioArgs) {
						tg_manageAjaxCallError(ioArgs.xhr, true, true);
					}
				}
				dojo.xhrGet(xhrArgs); 
		  }
		  
		  
		  
			  /*onClick detailed handling of the event*/
		  function handleOnClickFunction(evt,typeObject,clickedOption){
				if(clickedOption == evt.target) {
							//this.getSelected = function() {
									//var size = (this.choices.childNodes == null) ? 0 : this.choices.childNodes.length;
									//for (var i=0; i<size; i++) {
										//if (this.choices.childNodes[i].className == this.SELECTED_CLASS) return i;
									//}
									//return -1;
								//}
								
							  var listwidget = typeObject.getTypeAheadListWidget();
							  var size = (listwidget.childNodes == null) ? 0 : listwidget.childNodes.length;
							  var clickedOption = "";
							  var clickedIndex = 0;
							  for (var i=0; i<size; i++) {	
								 	if (listwidget.childNodes[i].className == "tgMenuItemSelected" || dojo.query(".tgMenuItemSelected", listwidget.childNodes[i]).length > 0){											
										clickedIndex = i;
										//clickedOption = listwidget.childNodes[i].innerHTML;
										var labelValue = typeObject.filteredArray[typeObject.listIndex-1].label;											
										labelValue = labelValue.replace('&lt;','<');
										labelValue = labelValue.replace('&gt;','>');
										clickedOption = labelValue;
									}
								}								  
							  dojo.byId(typeObject.getTextBoxId()).value = clickedOption;
							  typeObject.valueSelected="true";
							  dojo.empty(dojo.byId(typeObject.getListId()));
							  dojo.attr(dojo.byId(typeObject.getDivId()), "style", {
										display: "none"
								});
				} 
			}
		  

	
		/*onKeyUp detailed handling of the "Down Arrow" event*/
	function handleDownArrow(thisList,targetItem){
						var inputValue = thisList.getTypeAheadWidget().value;
			        	var inputLength = inputValue.length;
						var listLength = dojo.query("#" + thisList.getListId() + " li").length;
						for (var i=0; i<listLength; i++) {
							if (thisList.getTypeAheadListWidget().childNodes[i].className == "tgMenuItemSelected" || dojo.query(".tgMenuItemSelected", thisList.getTypeAheadListWidget().childNodes[i]).length > 0){
								var boldObj = dojo.query('b',thisList.getTypeAheadListWidget().childNodes[i]);
								if(boldObj.length > 0){
									boldObj[0].className = "";
								}								
								thisList.getTypeAheadListWidget().childNodes[i].className = "";
							}
						}
			        	if (inputLength != 0 && listLength != 0){
							if (thisList.textBoxPosition == true && thisList.listIndex == 0){
								thisList.textBoxPosition = false;
							}
							if (thisList.listIndex == listLength && thisList.textBoxPosition == false  && dojo.query("#" + thisList.getListId() + "").length != 0 ){
								thisList.getTypeAheadWidget().value = inputValueInit;
								thisList.textBoxPosition = true;
								dojo.byId(thisList.getListId()).selectedIndex = -1;
								document.getElementById(thisList.getListId()).scrollTop = 0;
								
								//for (var i = 0;i < listLength;i++){
									//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(n)")[i],"backgroundColor","#ffffff");							  
								//}
								
								var prevItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0];
								if(dojo.isIE < 8){
									prevItem.className = "";
								} else {
									prevItem.setAttribute("class", "");
								}
								//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0],"backgroundColor","#ffffff");	
								thisList.listIndex = 0;
							}else if (thisList.listIndex != listLength && thisList.textBoxPosition == false && dojo.query("#" + thisList.getListId() + " li").length != 0){ 
								var minDisplayItemFirst = thisList.minimumDisplayedItems-1;
								var minDisplayItemNext = thisList.minimumDisplayedItems-2;
								  //if (thisList.listIndex == thisList.minDisplayItemFirst && thisList.listIndex != 0){
								if (thisList.listIndex == (thisList.minimumDisplayedItems -1) && thisList.listIndex != 0){
									var nodeIndex = thisList.minimumDisplayedItems-1;
									var node = dojo.byId("item"+nodeIndex);
									var coords = dojo.coords(node);
									var scrollNum = thisList.minimumDisplayedItems - 2;
									//document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop+(coords.h * scrollNum);
									document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop+(coords.h * minDisplayItemFirst);
								//}else if (thisList.listIndex > minDisplayItemFirst && thisList.listIndex % minDisplayItemNext == 1 && thisList.listIndex != 0){
								  }else if (thisList.listIndex > minDisplayItemFirst && thisList.listIndex % minDisplayItemFirst == 1 && thisList.listIndex != 0){	
									var node = dojo.byId("item"+thisList.minimumDisplayedItems);
									var coords = dojo.coords(node);
									var scrollNum = thisList.minimumDisplayedItems - 2;
									//document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop+(coords.h * nodeIndex);
									document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop+(coords.h * minDisplayItemFirst);
								}
								thisList.listIndex++;
									//dojo.query("#" + thisList.getListId() + "option:nth-child(" + thisList.listIndex + ")").attr("style", {
				                						//background: "#fefebb"     
				            		//});
									
								//for (var i = 0;i < listLength;i++){
									//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(n)")[i],"backgroundColor","#ffffff");							  
								//}
								
								var prevIndex =  thisList.listIndex - 1;
								//(prevIndex) >= 1 ? dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + prevIndex + ")")[0],"backgroundColor","#ffffff") : "";
								if (prevIndex >= 1){
									var prevItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + prevIndex + ")")[0];
									if(dojo.isIE < 8){
										prevItem.className = ""; 	
									} else {
										prevItem.setAttribute("class", ""); 	
									}
								}
								
								
								var currItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0];
								if(dojo.isIE < 8){
									var boldObj = dojo.query('b',currItem);
									if(boldObj.length > 0){
										boldObj[0].className = "tgMenuItemSelected";
									}									
									currItem.className = "tgMenuItemSelected"; 
								} else {
									var boldObj = dojo.query('b',currItem);
									if(boldObj.length > 0){
										boldObj[0].setAttribute("class", "tgMenuItemSelected");
									}										
									currItem.setAttribute("class", "tgMenuItemSelected"); 
								}
								
								//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0],"backgroundColor","#fefebb");
								//dojo.byId(thisList.getListId()).selectedIndex = prevIndex;
								
									/* HTMLSpanElement, innerHTML for value(IE and FireFox) */
								//typeAheadWidget.attr("value", dojo.query("#typeAheadList dt:nth-child(" + list.listIndex + ")").attr("innerHTML"));
								//thisList.getTypeAheadWidget().value = dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0].innerHTML;
								var labelValue = thisList.filteredArray[thisList.listIndex-1].label;
								labelValue = labelValue.replace('&lt;','<');
								labelValue = labelValue.replace('&gt;','>');
								thisList.getTypeAheadWidget().value = labelValue;									
							}
						}
	}
	
	function html2entity(str){
		return str.replace(/[<>]/g,
			function(s){return (s == "<")? "&lt;" :"&gt;"});
	}

	
		/*onKeyUp detailed handling of the "Down Arrow" event*/
	function handleMouseOver(thisList,targetElement){			
		var listWidget = thisList.getTypeAheadListWidget();
		var size = (listWidget.childNodes == null) ? 0 : listWidget.childNodes.length;
		for (var i=0; i<size; i++) {								
			if (listWidget.childNodes[i].className == "tgMenuItemSelected" || dojo.query(".tgMenuItemSelected", listWidget.childNodes[i]).length > 0){
				var boldObj = dojo.query('b',listWidget.childNodes[i]);
				if(boldObj.length > 0){
					boldObj[0].className = "";
				}
				listWidget.childNodes[i].className = "";
			}
		}		
	
		if (targetElement.tagName=="LI"){				
			if(dojo.isIE < 8){
				var boldObj = dojo.query('b',targetElement);
				if(boldObj.length > 0){
					boldObj[0].className = "tgMenuItemSelected";
				}
				targetElement.className = "tgMenuItemSelected";
			} else{					
				var boldObj = dojo.query('b',targetElement);
				if(boldObj.length > 0){
					boldObj[0].setAttribute("class", "tgMenuItemSelected");
				}				
				targetElement.setAttribute("class", "tgMenuItemSelected");
			}
			
		}
		if (targetElement.tagName=="B"){				
			if(dojo.isIE < 8){
				targetElement.className = "tgMenuItemSelected";
				targetElement.parentNode.className = "tgMenuItemSelected";
			} else{	
				targetElement.setAttribute("class", "tgMenuItemSelected");
				targetElement.parentNode.setAttribute("class", "tgMenuItemSelected");
			}
			
		}
	
		for (var i=0; i<size; i++) {			
			if (listWidget.childNodes[i].className == "tgMenuItemSelected" || dojo.query(".tgMenuItemSelected",listWidget.childNodes[i]).length >0){
				thisList.listIndex = i+1;
			}
		}
	}
	
		/*onKeyUp detailed handling of the "Up Arrow" event*/
	function handleUpArrow(thisList) {
						var listLength = dojo.query("#" + thisList.getListId() + " li").length;
						var nodeIndex = listLength-1;
						var node = dojo.byId("item"+nodeIndex);
						var coords = dojo.coords(node);
						for (var i=0; i<listLength; i++) {
							if (thisList.getTypeAheadListWidget().childNodes[i].className == "tgMenuItemSelected" || dojo.query(".tgMenuItemSelected", thisList.getTypeAheadListWidget().childNodes[i]).length > 0){
								var boldObj = dojo.query('b',thisList.getTypeAheadListWidget().childNodes[i]);
								if(boldObj.length > 0){
									boldObj[0].className = "";
								}								
								thisList.getTypeAheadListWidget().childNodes[i].className = "";
							}
						}
				        if (thisList.listIndex != 0){
				        	thisList.listIndex--;
				        }
				        
				        if (thisList.textBoxPosition == true){
			        		thisList.textBoxPosition = false;
							var scrollTopEnd = (coords.h * listLength);
							var scrollTopInit = document.getElementById(thisList.getListId()).scrollTop + scrollTopEnd;
							document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop + scrollTopInit; 
			        		thisList.listIndex = dojo.query("#" + thisList.getListId() + " li").length;
			        	}else if (thisList.listIndex == 0 && thisList.textBoxPosition == false && dojo.query("#" + thisList.getListId() + "").length != 0){
			        		thisList.textBoxPosition = true;
							dojo.byId(thisList.getListId()).selectedIndex = -1;
							thisList.getTypeAheadWidget().value = inputValueInit;
							var prevIndex =  thisList.listIndex + 1;
								
							var prevItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + prevIndex + ")")[0];
							if(dojo.isIE < 8){
								prevItem.className = "";
							} else {
								prevItem.setAttribute("class", "");
							}
							//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + nextIndex + ")")[0],"backgroundColor","#ffffff");	
							
			        	}
			        		 
			        	if (thisList.listIndex != 0 && thisList.textBoxPosition == false && dojo.query("#" + thisList.getListId() + " li").length != 0){
								var minDisplayItemFirst = thisList.minimumDisplayedItems-1;
								var minDisplayItemNext = thisList.minimumDisplayedItems-2;
								
								if (thisList.listIndex == 1){
									document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop-(coords.h);
								  }else if (thisList.listIndex == thisList.minimumDisplayedItems && thisList.listIndex != 0){
									var scrollNum = thisList.minimumDisplayedItems - 2;
									//document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop-(coords.h * scrollNum);
									document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop-(coords.h * minDisplayItemFirst);
								  }else if (thisList.listIndex > minDisplayItemFirst && thisList.listIndex % minDisplayItemFirst == 1 && thisList.listIndex != 0 && thisList.listIndex != listLength-1){
									var scrollNum = thisList.minimumDisplayedItems - 2;
									//document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop-(coords.h * scrollNum);
									document.getElementById(thisList.getListId()).scrollTop = document.getElementById(thisList.getListId()).scrollTop-(coords.h * minDisplayItemFirst);
								}	
				            	
				            	//dojo.query("#" + thisList.getListId() + "option:nth-child(" + thisList.listIndex + ")").attr("style", {
				                						//background: "#fefebb"     
				            	//});
								//dojo.byId(thisList.getListId()).selectedIndex = thisList.listIndex-1;
								
								var prevIndex =  thisList.listIndex + 1;
								if (prevIndex < listLength+1){
									var prevItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + prevIndex + ")")[0];
									if(dojo.isIE < 8){
										prevItem.className = "";
									} else {
										prevItem.setAttribute("class", "");
									}
								}
								//(nextIndex) < listLength+1 ? dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + nextIndex+ ")")[0],"backgroundColor","#ffffff") : "";
								
								var currItem = dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0];
								if(dojo.isIE < 8){
									var boldObj = dojo.query('b',currItem);
									if(boldObj.length > 0){
										boldObj[0].className = "tgMenuItemSelected";
									}									
									currItem.className = "tgMenuItemSelected"; 
								} else {
									var boldObj = dojo.query('b',currItem);
									if(boldObj.length > 0){
										boldObj[0].setAttribute("class", "tgMenuItemSelected");
									}										
									currItem.setAttribute("class", "tgMenuItemSelected"); 
								}
				            	//dojo.style(dojo.query("#" + thisList.getListId() + " li:nth-child(" + thisList.listIndex + ")")[0],"backgroundColor","#fefebb");
								
				            	//typeAheadWidget.attr("value", dojo.query("#" + list.getListId() + " dt:nth-child(" + list.listIndex + ")").attr("innerHTML"));
								//thisList.getTypeAheadWidget().value = dojo.query("#" + thisList.getListId() + " li:nth-child(" +  thisList.listIndex + ")")[0].innerHTML;
								var labelValue = thisList.filteredArray[thisList.listIndex-1].label;
								labelValue = labelValue.replace('&lt;','<');
								labelValue = labelValue.replace('&gt;','>');
								thisList.getTypeAheadWidget().value = labelValue;
			            }
			            	
	}
	
		  /*onKeyUp detailed handling of the "Enter",the "Numpad Enter" and the "TAB" click events*/
	   /* Used to handle the"Enter",the "Numpad Enter" and the "TAB" events
	   related to the typeAhead components (textBox and List)	
	  */
	  function handleEnterEvent(thisList) {
				//typeAheadWidget.attr("value", dojo.query("#" + list.getListId() + " dt:nth-child(" + list.listIndex + ")").innerHTML);
				if (thisList.listIndex != 0){
					var labelValue = thisList.filteredArray[thisList.listIndex-1].label;
					labelValue = labelValue.replace('&lt;','<');
					labelValue = labelValue.replace('&gt;','>');
					//thisList.getTypeAheadWidget().value = dojo.query("#" + thisList.getListId() + " li:nth-child(" +  thisList.listIndex + ")")[0].innerHTML;
					thisList.getTypeAheadWidget().value = labelValue;
					if (thisList.handleOnAfterClickFunction != null){
						thisList.handleOnAfterClickFunction(thisList.filteredArray[thisList.listIndex-1].label,thisList.textBoxId,thisList.ajaxResponseArray[thisList.listIndex - 1]);
					}
					dojo.empty(dojo.byId(thisList.getListId()));
					thisList.listIndex = 0;
					thisList.textBoxPosition = false;
					//dojo.destroy(dojo.byId(thisList.getDivId()));
					dojo.attr(dojo.byId(thisList.getDivId()), "style", {
												display: "none"
											});
				}
				/*else{
					dojo.empty(dojo.byId(thisList.getListId()));
					thisList.listIndex = 0;
					thisList.textBoxPosition = false;
					dojo.destroy(dojo.byId(thisList.getDivId()));
				}*/
	  } 
	  
		  /*onKeyUp detailed handling of the "Enter",the "Numpad Enter" and the "TAB" click events*/
	   /* Used to handle the "TAB" event
	   related to the typeAhead components (textBox and List)	
	  */
	  function handleTABEvent(thisList) {
				//typeAheadWidget.attr("value", dojo.query("#" + list.getListId() + " dt:nth-child(" + list.listIndex + ")").innerHTML);
					dojo.empty(dojo.byId(thisList.getListId()));
					thisList.listIndex = 0;
					thisList.textBoxPosition = false;
					//dojo.destroy(dojo.byId(thisList.getDivId()));
					dojo.attr(dojo.byId(thisList.getDivId()), "style", {
												display: "none"
											});
	  } 
	  
		  /*onKeyUp detailed handling of the "Escape" event*/
	  /* Used to handle the ESCAPE event
	   related to the typeAhead components (textBox and List)	
	  */
	  function handleEscapeEvent(thisList) {
				//typeAheadWidget.attr("value", dojo.query("#" + list.getListId() + " dt:nth-child(" + list.listIndex + ")").innerHTML);
				if (thisList.listIndex != 0){ 
					var labelValue = thisList.filteredArray[thisList.listIndex-1].label;
					labelValue = labelValue.replace('&lt;','<');
					labelValue = labelValue.replace('&gt;','>');
					thisList.getTypeAheadWidget().value = labelValue;
					//thisList.getTypeAheadWidget().value = dojo.query("#" + thisList.getListId() + " li:nth-child(" +  thisList.listIndex + ")")[0].innerHTML;
					thisList.listIndex = 0;
				}
				dojo.empty(dojo.byId(thisList.getListId()));
				thisList.textBoxPosition = false;
				//dojo.destroy(dojo.byId(thisList.getDivId()));
				dojo.attr(dojo.byId(thisList.getDivId()), "style", {
						display: "none"
				});
						// TODO what to do with field content? reset?
	  } 
	  
		   /*onKeyPress detailed handling of the "BackSpace" and the "Space Bar" click events*/
	   /* Used to re-initialize variables
	      when a BackSpace event occurs	
	   */
	  function initListParam(thisList){
				thisList.listIndex = 0;
				thisList.textBoxPosition = false;
	  }

	
		/*onKeyPress detailed handling of the event*/
	/* Used to handle backSpace, Space Bar, and TAB events
	   related to the typeAhead components (textBox and List)	
	*/
	function onKeyPressEvent(list)
	{	
  			     dojo.connect(this.typeAheadWidget, "onkeypress", function  (evt) {
			        key = evt.keyCode;
			                
				        /*onKeyPress handling of the "Back Space" and the "Space Bar" events*/
			        if (evt.charOrCode == " "){
						initListParam(list);
						onTimeOutHandle(list);
			        } 
					
						/*onKeyPress handling of the "TAB" event*/
					if (key == dojo.keys.TAB){
						handleTABEvent(list);
					}
		     	 });
	}
	
	function onKeyEnterEvent(list)
	{	
  			     dojo.connect(this.typeAheadWidget, "onblur", function  (evt) {
					//this.listIndex = 0;
					//this.textBoxPosition = false;
					//dojo.destroy(dojo.byId(list.getDivId()));
					});
	}
	
	
		/* This function is used to add the "select" HTML element to a pre-defined DIV, which ID is passed by 
		   parameter.
		   Some attributes are defined to this list, including 			
		   its size, width, and ID.
		*/
		//this.drawTypeAhead = function()
		function drawTypeAhead(list)
		{					
				//Drawing of the HTML "select" element containing the elements of the type ahead list
				if (dojo.query("#"+ list.getListId() + "")[0] != null && dojo.query("#"+ list.getDivId() + "")[0] != null) {
					var textBoxNode = dojo.query(list.getTextBoxId())[0];	
					
					if (list.displayFooter == "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] == null){
						//alert("display footer true1");
							var indexDiv= dojo.doc.createElement("div");								
							indexDiv.setAttribute("id", list.getFooterDivId());
							if(dojo.isIE < 8){
								indexDiv.className = "lotusPaging tgFooterTypeAhead tgRemoveMargin";
							} else {
								indexDiv.setAttribute("class", "lotusPaging tgFooterTypeAhead tgRemoveMargin");
							}
							dojo.query("#"+ list.getDivId() + "")[0].appendChild(indexDiv);
							var indexPagingList= dojo.doc.createElement("ul");
							indexPagingList.setAttribute("id", list.getFooterPagingId());
							if(dojo.isIE < 8){
								indexPagingList.className = "lotusLeft lotusInlinelist";
							} else {
								indexPagingList.setAttribute("class", "lotusLeft lotusInlinelist");
							}
							indexDiv.appendChild(indexPagingList);
							dojo.attr(dojo.byId(list.getDivId()), "style", {
										float: "left"
									});	
									
							var HLinks = new Array();
							var indexArrayTokens = list.indexArray.split(",");
							var HLinkList = dojo.doc.createElement("li");
							if(dojo.isIE < 8){
								HLinkList.className = "lotusFirst";
							} else {
								HLinkList.setAttribute("class","lotusFirst");
							}
							HLinkList.innerHTML = "Show: ";
							indexPagingList.appendChild(HLinkList);
							
							
							var HLinkList10 = dojo.doc.createElement("li");
								var HLink = document.createElement("a");
								indexPagingList.appendChild(HLinkList10);
								HLinkList10.appendChild(HLink);
								HLinkList10.setAttribute("id", list.getLinkId10());
								HLinks[0]= HLink;
								//tg_lwp_ajaxNavigator_lowerPrevious_alltasksbywbs_
								HLink.setAttribute("title", "page 0");
								HLink.setAttribute("href","javascript:;");
								HLink.innerHTML = indexArrayTokens[0];
								
								
								HLink.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//list.setRowCount(this.innerHTML.substring(0,this.innerHTML.length - 2));
									list.setRowCount(this.innerHTML);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};
								
								
								var HLinkList20 = dojo.doc.createElement("li");
								//HLinkList20.setAttribute("class","lotusLast");
								var HLink = document.createElement("a");
								indexPagingList.appendChild(HLinkList20);
								HLinkList20.appendChild(HLink);
								HLinkList20.setAttribute("id", list.getLinkId20());
								HLinks[1]= HLink;
								HLink.setAttribute("title", "page 1");
								HLink.setAttribute("href","javascript:;");
								//HLink.innerHTML = indexArrayTokens[j] + " | ";
								HLink.innerHTML = indexArrayTokens[1];
								
								
								HLink.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//list.setRowCount(this.innerHTML.substring(0,this.innerHTML.length - 2));
									list.setRowCount(this.innerHTML);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};
							
							
							var divFooterWidth = dojo.style(dojo.query(list.getTextBoxId())[0],"width");
							var node = list.getListId();
							var coords = dojo.coords(node);
								
							dojo.attr(dojo.query("#" + list.getFooterDivId() + ""), "style", {
											top: getYFromBody(node)+"px"
										});
							dojo.attr(dojo.query("#" + list.getFooterDivId() + ""), "style", {
											minWidth: divFooterWidth +"px"
										});

								
							var HLinkListAllItems = dojo.doc.createElement("li");
							var HLinkAllItems = document.createElement("a");
							HLinkListAllItems.setAttribute("id", list.getLinkIdAll());
							HLinkAllItems.setAttribute("id","link_All_Items");
							HLinkAllItems.innerHTML = "All";
							indexPagingList.appendChild(HLinkListAllItems);
							HLinkListAllItems.appendChild(HLinkAllItems);
							HLinkAllItems.setAttribute("href","javascript:;");
							HLinkAllItems.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									list.firstEntryTodisplay = 0;
									list.setRowCount(list.totalEntries);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};
							
							
							
							
							if (list.displayBrowser == "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] == null){ 
								var indexBrowserList= dojo.doc.createElement("ul");
								indexBrowserList.setAttribute("id", list.getFooterBrowserId());
								if(dojo.isIE < 8){
									indexBrowserList.className = "lotusRight lotusInlinelist";
								} else {
									indexBrowserList.setAttribute("class", "lotusRight lotusInlinelist");
								}
								indexDiv.appendChild(indexBrowserList);
								var HLinkListPrevious = dojo.doc.createElement("li");
								var HLinkPrevious = document.createElement("a");
								if(dojo.isIE < 8){
									HLinkListPrevious.className = "lotusFirst";
								} else {
									HLinkListPrevious.setAttribute("class","lotusFirst");
								}
								indexBrowserList.appendChild(HLinkListPrevious);
								HLinkListPrevious.appendChild(HLinkPrevious);
								HLinkListPrevious.setAttribute("id", list.getLinkIdPrevious());
								HLinkPrevious.setAttribute("title", "Previous page");
								HLinkPrevious.setAttribute("href","javascript:;");
								HLinkPrevious.innerHTML = "Previous";
									HLinkPrevious.onclick = function(){
										var inputValue = dojo.byId(list.getTextBoxId()).value;
										list.firstEntryTodisplay = list.firstEntryTodisplay - list.rowCount;
										return new Function(handleLinkOnClick(list,this,inputValue));
									};
									
							
								var HLinkListNext = dojo.doc.createElement("li");
								var HLinkNext = document.createElement("a");
								indexBrowserList.appendChild(HLinkListNext);
								HLinkListNext.appendChild(HLinkNext);
								HLinkListNext.setAttribute("id", list.getLinkIdNext());
								HLinkNext.setAttribute("title", "Next page");
								HLinkNext.setAttribute("href","javascript:;");
								HLinkNext.innerHTML = "Next";
								HLinkNext.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									list.firstEntryTodisplay += list.rowCount; 
									return new Function(handleLinkOnClick(list,this,inputValue));
								};

								
							}else if (list.displayBrowser == "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] != null){
								dojo.attr(dojo.byId(list.getFooterBrowserId()), "style", {
												display: "block"
											});	
							}else if (list.displayBrowser != "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] != null){
								dojo.attr(dojo.byId(list.getFooterBrowserId()), "style", {
												display: "none"
											});
							}

							
							//dojo.query("#link_All_Items").connect("onclick",function(evt){list.setRowCount(100);handleAjaxCallKeyUp(list,list.getInputValue(),list);dojo.byId(list.getTextBoxId()).focus();dojo.byId(list.getTextBoxId()).select()});	
								
							/*var href = dojo.doc.createAttribute("href"); 
							list.setRowCount(indexArrayTokens[indexArrayTokens.length-1]);
							HLink1.setAttribute("title", "page" + indexArrayTokens[indexArrayTokens.length-1]);
							//HLink1.setAttribute("cursor","hand",0);
							HLink1.innerHTML = indexArrayTokens[indexArrayTokens.length-1]; 
							HLinks[indexArrayTokens.length-1]= HLink1;*/
							//dojo.query("#typeAheadFooterList a").connect("onclick",function(evt){handleEnableLinks();list.setRowCount(evt.target.innerHTML.substring(0,evt.target.innerHTML.length - 2));handleAjaxCallKeyUp(list,list.getInputValue(),list);dojo.byId(list.getTextBoxId()).focus();dojo.byId(list.getTextBoxId()).select();disableAnchor(this,true)});
						}else if (list.displayFooter == "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
							dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "block"
											});
							
							var HLink10 = document.getElementById(list.linkId10);
							var HLink20 = document.getElementById(list.linkId20);
							var HLinkAllItems = document.getElementById(list.linkIdAll);
							var HLinkPrevious = document.getElementById(list.linkIdPrevious);
							var HLinkNext = document.getElementById(list.linkIdNext);
							
						
							HLink10.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//var inputValue = list.getTypeAheadWidget().value;
									list.setRowCount(10);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};
								
						
		
							HLink20.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//alert("view id222222............" + list.viewId);
									//var inputValue = list.getTypeAheadWidget().value;
									list.setRowCount(20);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};				
									
							
							
							HLinkAllItems.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//var inputValue = list.getTypeAheadWidget().value;
									list.firstEntryTodisplay = 0;
									list.setRowCount(list.totalEntries);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};				
							
						
							HLinkPrevious.onclick = function(){
										var inputValue = dojo.byId(list.getTextBoxId()).value;
										//var inputValue = list.getTypeAheadWidget().value;
										list.firstEntryTodisplay = list.firstEntryTodisplay - list.rowCount;
										return new Function(handleLinkOnClick(list,this,inputValue));
									};
									
						
							HLinkNext.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//var inputValue = list.getTypeAheadWidget().value;
									list.firstEntryTodisplay += list.rowCount; 
									return new Function(handleLinkOnClick(list,this,inputValue));
								};
							
							
							
							
							
						}else if (list.displayFooter != "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
							dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "none"
											});
						}
					
					
					dojo.place(dojo.byId(list.getDivId()),document.body,"last");
					dojo.attr(dojo.byId(list.getDivId()), "style", {
												display : "none"
											});
					/*dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display : "none",
											});						*/
					
					typeAheadListWidget = dojo.query("#"+ list.getListId() + "")[0];
					list.setTypeAheadListWidget(typeAheadListWidget);
				}
				
				//if (dojo.byId(this.getListId()) == null && dojo.byId(this.getDivId()) == null) {
				if (dojo.query("#"+ list.getListId() + "")[0] == null && dojo.query("#"+ list.getDivId() + "")[0] == null){
					//var listWidth = dojo.style(dojo.query(list.getTextBoxId())[0],"width");  		//Get the textBox width
					var listWidth = 0;
					var textBoxNode = dojo.query(list.getTextBoxId())[0];	
					
					var listDiv= dojo.doc.createElement("div");
					listDiv.setAttribute("id", list.getDivId());
					if(dojo.isIE < 8){
						listDiv.className = "dijitPopup";
					} else {
						listDiv.setAttribute("class", "dijitPopup");
					}
					var listSelect = dojo.doc.createElement("ul");
					listSelect.setAttribute("id", list.getListId());
					if(dojo.isIE < 8){
						listSelect.className = "dijitReset dijitMenu tgMenuTypeAhead";
					} else {
						listSelect.setAttribute("class", "dijitReset dijitMenu tgMenuTypeAhead");
					}
					
					
					//When the page loads, assign the html of the typeAhead to the divHolder
					var ID = list.getDivId();
					dojo.place(listDiv,document.body,"last");
					dojo.attr(dojo.byId(list.getDivId()), "style", {
												display: "none",
												height:"200px"													
											});
					dojo.byId(list.getDivId()).style.zIndex = 801;												
					dojo.query("#"+ list.getDivId() + "")[0].appendChild(listSelect);
					
					if (list.displayFooter == "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] == null){
						//alert("display footer true2");
							var indexDiv= dojo.doc.createElement("div");
							indexDiv.setAttribute("id", list.getFooterDivId());
							if(dojo.isIE < 8){
								indexDiv.className = "lotusPaging tgFooterTypeAhead tgRemoveMargin";
							} else {
								indexDiv.setAttribute("class", "lotusPaging tgFooterTypeAhead tgRemoveMargin");
							}
							dojo.query("#"+ list.getDivId() + "")[0].appendChild(indexDiv);
							var indexList= dojo.doc.createElement("ul");
							indexList.setAttribute("id", list.getFooterPagingId());
							if(dojo.isIE < 8){
								indexList.className = "lotusLeft lotusInlinelist";
							} else {
								indexList.setAttribute("class", "lotusLeft lotusInlinelist");
							}
							indexDiv.appendChild(indexList);
							dojo.attr(dojo.byId(list.getDivId()), "style", {
										float: "left"
									});	
									
							var HLinks = new Array();
							var indexArrayTokens = list.indexArray.split(",");
							
							var HLinkList = dojo.doc.createElement("li");
							if(dojo.isIE < 8){
								HLinkList.className = "lotusFirst";
							} else {
								HLinkList.setAttribute("class","lotusFirst");
							}
							HLinkList.innerHTML = "Show: ";
							indexList.appendChild(HLinkList);
							
							var HLinkList10 = dojo.doc.createElement("li");
								if(dojo.isIE < 8){
									HLinkList10.className = "lotusFirst";
								} else {
									HLinkList10.setAttribute("class","lotusFirst");
								}
								var HLink = document.createElement("a");
								indexList.appendChild(HLinkList10);
								HLinkList10.appendChild(HLink);
								HLinkList10.setAttribute("id", list.getLinkId10());
								HLinks[0]= HLink;
								HLink.setAttribute("title", "page 0");
								HLink.setAttribute("href","javascript:;");
								//HLink.innerHTML = indexArrayTokens[j] + " | ";
								HLink.innerHTML = indexArrayTokens[0];

								
								HLink.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//list.setRowCount(this.innerHTML.substring(0,this.innerHTML.length - 2));
									list.setRowCount(this.innerHTML);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};

								
								var HLinkList20 = dojo.doc.createElement("li");
								var HLink = document.createElement("a");
								indexList.appendChild(HLinkList20);
								HLinkList20.appendChild(HLink);
								HLinkList20.setAttribute("id", list.getLinkId20());
								HLinks[1]= HLink;
								HLink.setAttribute("title", "page 1");
								HLink.setAttribute("href","javascript:;");
								//HLink.innerHTML = indexArrayTokens[j] + " | ";
								HLink.innerHTML = indexArrayTokens[1];
								
								
								HLink.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									//list.setRowCount(this.innerHTML.substring(0,this.innerHTML.length - 2));
									list.setRowCount(this.innerHTML);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};

							
								var divFooterWidth = dojo.style(dojo.query(list.getTextBoxId())[0],"width");
								var node = list.getListId();
								var coords = dojo.coords(list.getListId());
								
								dojo.attr(dojo.query("#" + list.getFooterDivId() + ""), "style", {
												top: getYFromBody(node)+"px"
											});
								dojo.attr(dojo.query("#" + list.getFooterDivId() + ""), "style", {
												minWidth: divFooterWidth +"px"
											});

								
								var HLinkListAllItems = dojo.doc.createElement("li");
								var HLinkAllItems = document.createElement("a");
								HLinkListAllItems.setAttribute("id", list.getLinkIdAll());
								HLinkAllItems.setAttribute("id","link_All_Items");
								HLinkAllItems.innerHTML = "All";
								indexList.appendChild(HLinkListAllItems);
								HLinkListAllItems.appendChild(HLinkAllItems);
								HLink.setAttribute("title", "page 4");
								HLinkAllItems.setAttribute("href","javascript:;");
								
								HLinkAllItems.onclick = function(){
									var inputValue = dojo.byId(list.getTextBoxId()).value;
									list.firstEntryTodisplay = 0;
									list.setRowCount(list.totalEntries);
									return new Function(handleLinkOnClick(list,this,inputValue));
								};


									
								if (list.displayBrowser == "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] == null){ 
									var indexBrowserList= dojo.doc.createElement("ul");
									indexBrowserList.setAttribute("id", list.getFooterBrowserId());
									if(dojo.isIE < 8){
										indexBrowserList.className = "lotusRight lotusInlinelist";
									} else {
										indexBrowserList.setAttribute("class", "lotusRight lotusInlinelist");
									}
									indexDiv.appendChild(indexBrowserList);
									var HLinkListPrevious = dojo.doc.createElement("li");
									var HLinkPrevious = document.createElement("a");
									if(dojo.isIE < 8){
										HLinkListPrevious.className = "lotusFirst";
									} else {
										HLinkListPrevious.setAttribute("class","lotusFirst");
									}
									indexBrowserList.appendChild(HLinkListPrevious);
									HLinkListPrevious.appendChild(HLinkPrevious);
									HLinkListPrevious.setAttribute("id",list.getLinkIdPrevious());
									HLinkPrevious.setAttribute("title", "Previous page");
									HLinkPrevious.setAttribute("href","javascript:;");
									HLinkPrevious.innerHTML = "Previous";
									
									
										HLinkPrevious.onclick = function(){
											var inputValue = dojo.byId(list.getTextBoxId()).value;
											list.firstEntryTodisplay = list.firstEntryTodisplay - list.rowCount;
											return new Function(handleLinkOnClick(list,this,inputValue));
										};

									
									
							
									var HLinkListNext = dojo.doc.createElement("li");
									var HLinkNext = document.createElement("a");
									indexBrowserList.appendChild(HLinkListNext);
									HLinkListNext.appendChild(HLinkNext);
									HLinkListNext.setAttribute("id",list.getLinkIdNext());
									HLinkNext.setAttribute("title", "Next page");
									HLinkNext.setAttribute("href","javascript:;");
									HLinkNext.innerHTML = "Next";
									
									
									HLinkNext.onclick = function(){
										var inputValue = dojo.byId(list.getTextBoxId()).value;
										list.firstEntryTodisplay = list.firstEntryTodisplay + list.rowCount; 
										return new Function(handleLinkOnClick(list,this,inputValue));
									};
									


								}else if (list.displayBrowser == "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] != null){
									dojo.attr(dojo.byId(list.getFooterBrowserId()), "style", {
												display: "block"
											});	
								}else if (list.displayBrowser != "true" && dojo.query("#"+ list.getFooterBrowserId() + "")[0] != null){
									dojo.attr(dojo.byId(list.getFooterBrowserId()), "style", {
												display: "none"
											});
								}	
								

								//dojo.query("#link_All_Items").connect("onclick",function(evt){list.setRowCount(100);handleAjaxCallKeyUp(list,list.getInputValue(),list);dojo.byId(list.getTextBoxId()).focus();dojo.byId(list.getTextBoxId()).select()});
								
								//var href = dojo.doc.createAttribute("href"); 
								//list.setRowCount(indexArrayTokens[indexArrayTokens.length-1]);
								//dojo.query("#typeAheadFooterList a").connect("onclick",function(evt){handleEnableLinks();list.setRowCount(evt.target.innerHTML.substring(0,evt.target.innerHTML.length - 2));handleAjaxCallKeyUp(list,list.getInputValue(),list);dojo.byId(list.getTextBoxId()).focus();dojo.byId(list.getTextBoxId()).select();disableAnchor(this,true)});
								//dojo.query("#typeAheadFooterList a").connect("onmouseover","style.cursor='hand'"); 
						}else if (list.displayFooter == "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
							dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "block"
											});
						}else if (list.displayFooter != "true" && dojo.query("#"+ list.getFooterDivId() + "")[0] != null){
							dojo.attr(dojo.byId(list.getFooterDivId()), "style", {
												display: "none"
											});
						}
					
					typeAheadListWidget = dojo.query("#"+ list.getListId() + "")[0];
					list.setTypeAheadListWidget(typeAheadListWidget);
				}
				
	}	  

	
	function handleEnableLinks(listElement,inputValue){
		var footerLinkItems = dojo.query("#typeAheadFooterPaging a");
		for (var i=0;i<footerLinkItems.length;i++){
			disableAnchor(listElement,footerLinkItems[i],false,inputValue);
		}
	}

	
	function handleLinkOnClick(listElement,clickElement,inputValueElement){
		//handleEnableLinks(listElement,inputValueElement);
		//onKeyUpEvent(listElement);
		handleAjaxCallKeyUp(listElement,inputValueElement);
		dojo.byId(listElement.getTextBoxId()).focus();
		dojo.byId(listElement.getTextBoxId()).select();
		//disableAnchor(listElement,clickElement,true,inputValueElement);
	}

	
	
	function disableAnchor(list,obj, disable,inputValue){
		obj.setAttribute('href',"javascript:;");
		if(obj != null){
			if(disable){
				//var onclick = obj.getAttribute("onclick");
				var onclick = obj.onclick;
				if(obj.getAttribute('href') != "" && obj.getAttribute('href') != null){
					obj.setAttribute('href_bak', obj.getAttribute('href'));
				}
				if(onclick != null){
					obj.setAttribute('onclick_back', onclick);
					obj.onclick = function(){
						return false;
					}
				}
				obj.removeAttribute('href');
				dojo.attr(obj, "style", {
							color:"gray"
				});
				/*var linkInnerHTML = obj.innerHTML;
				var objParent = obj.parent;
				objParent.innerHTML = linkInnerHTML;
				objParent.removeChild(obj);*/
			}else{
					var hrefBack = obj.getAttribute("href_bak");
					var onclickBack = obj.getAttribute("onclick_back");
					if(onclickBack !=null ){
						//var onClickFunction = eval(onclickBack);
						obj.onclick = function(){
								return new Function(handleLinkOnClick(list,this,inputValue));
						};
						obj.removeAttribute('onclick_back');
					}
					if(hrefBack !=null ){
						obj.setAttribute('href', hrefBack);
						obj.removeAttribute('href_bak');
						dojo.attr(obj, "style", {
							color:"#05386B"
						});
					}
				}
		}
	} 
	
}
