/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.xsp;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.util.Date;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class XSPProjectModel
extends ProjectModel {
    public XSPProjectModel(GlobalContext globalContext, String string) {
        super(globalContext, string);
    }

    public ScheduleCalendar getProjectCalendar() {
        return this.prjContext.getProjectCalendar();
    }

    protected void initData(ProjectData projectData) {
        this.resetTaskSeriesForInit();
        long l = -1L;
        long l2 = -1L;
        Date date = new Date();
        if (projectData.nodes != null && projectData.nodes.size() > 0) {
            int n = 0;
            NodeData nodeData = projectData.nodes.get(0);
            Date date2 = nodeData.startDate;
            Date date3 = nodeData.endDate;
            if (date2 == null) {
                date2 = date;
            }
            if (date3 == null) {
                date3 = date2;
            }
            if (date2.getTime() > date3.getTime()) {
                date3 = date2;
            }
            if (!UString.equals((String)nodeData.hierarchicalId, (String)"1")) {
                this.rootNode = GanttWBS.createFakeRoot();
            } else {
                this.rootNode = (GanttWBS)this.createNode(nodeData);
                l = date2.getTime();
                l2 = date3.getTime();
                ++n;
                this.allNodes.put(((GanttWBS)this.rootNode).getUid(), this.rootNode);
            }
            this.rootNode.setNodeContext(this.prjContext);
            this.wbsNodes.put(this.rootNode.getHierarchicalId(), this.rootNode);
            while (n < projectData.nodes.size()) {
                GanttNode ganttNode;
                nodeData = projectData.nodes.get(n);
                GanttNode ganttNode2 = this.createNode(nodeData);
                TGNode tGNode = (TGNode)this.wbsNodes.get(ganttNode2.getParentHierarchicalId());
                if (tGNode == null && ganttNode2.getParentHierarchicalId().equals("1")) {
                    tGNode = this.rootNode;
                }
                if (tGNode != null) {
                    tGNode.addSubtask(ganttNode2);
                }
                if ((ganttNode = (GanttNode)this.allNodes.get(ganttNode2.getUid())) != null) {
                    System.out.println("WARNING: 2 nodes of the project (" + ganttNode.getHierarchicalId() + " and " + ganttNode2.getHierarchicalId() + ") have the same UID " + ganttNode2.getUid());
                }
                this.allNodes.put(ganttNode2.getUid(), ganttNode2);
                if (ganttNode2 instanceof GanttWBS) {
                    this.wbsNodes.put(ganttNode2.getHierarchicalId(), ganttNode2);
                }
                if (this.rootNode.isFakeRoot()) {
                    date2 = ganttNode2.getStartDate();
                    date3 = ganttNode2.getFinishDate();
                    l = l == -1L ? date2.getTime() : Math.min(l, date2.getTime());
                    l2 = l2 == -1L ? date3.getTime() : Math.max(l2, date3.getTime());
                }
                ++n;
            }
        } else {
            this.rootNode = GanttWBS.createFakeRoot();
            this.rootNode.setNodeContext(this.prjContext);
        }
        if (this.rootNode.isFakeRoot()) {
            this.rootNode.setDuration((TimePeriod)new SimpleTimePeriod(l, l2));
        }
        this.dataStartDate = new Date(l);
        this.dataEndDate = new Date(l2);
    }

    public GanttNode refreshNodeFromDatabase(NodeData nodeData, String string) throws Exception {
        GanttNode ganttNode = (GanttNode)this.getNodeByDocId(string);
        String string2 = ganttNode.getParentHierarchicalId();
        this.updateNode(ganttNode, nodeData);
        if (ganttNode != this.rootNode && !TString.equals((String)string2, (String)ganttNode.getParentHierarchicalId())) {
            throw new Exception("Refresh of node " + string + " not supported. Full resfresh is needed");
        }
        return ganttNode;
    }
}

