/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.xsp;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.docdb.TDBView;
import com.flowbuilder.docdb.TDBViewEntry;
import com.flowbuilder.docdb.TDBViewEntryCollection;
import com.flowbuilder.util.TString;
import com.triloggroup.gantt.ChartModelUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.pe.project.ProjectInfo;
import com.triloggroup.pe.schedule.GanttViewUtil;
import com.triloggroup.project.NameId;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.projexec.cache.CacheUtil;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.ArrayList;

public class XSPProjectDataLoader {
    protected static final int NB_LOOP_CHECK_MEMORY = 1000;
    private String siteId;
    private TDBSession dbSession;
    private boolean forAllocations;

    public XSPProjectDataLoader(TDBSession tDBSession, String string) {
        this.dbSession = tDBSession;
        this.siteId = string;
    }

    public boolean isForAllocations() {
        return this.forAllocations;
    }

    public void setForAllocations(boolean bl) {
        this.forAllocations = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectData loadAllNodes(String string, String string2, NLSBundle nLSBundle) throws TDBException, GanttChartException {
        ChartModelUtil.checkEnoughAvailableMemory(nLSBundle);
        TDBDatabase tDBDatabase = null;
        TDBView tDBView = null;
        TDBViewEntryCollection tDBViewEntryCollection = null;
        try {
            ProjectData projectData;
            tDBDatabase = this.dbSession.openDatabase("tg_pe_schedule");
            tDBView = TString.isEmpty((String)string2) ? tDBDatabase.openView("alltasksandwbsforgantt") : tDBDatabase.openView("alltasksandwbsforgantt", string2);
            ProjectData projectData2 = new ProjectData();
            projectData2.siteId = this.siteId;
            projectData2.projectId = string;
            projectData2.nodes = new ArrayList();
            GanttViewUtil.loadColumnIndexes((TDBView)tDBView);
            int n = 0;
            tDBViewEntryCollection = tDBView.getAllEntries();
            if (tDBViewEntryCollection != null) {
                projectData = tDBViewEntryCollection.getFirstEntry();
                while (projectData != null) {
                    NodeData nodeData = this.loadNodeData((TDBViewEntry)projectData);
                    projectData2.nodes.add(nodeData);
                    if (1000 < n) {
                        ChartModelUtil.checkEnoughAvailableMemory(nLSBundle);
                        n = 0;
                    }
                    projectData = tDBViewEntryCollection.getNextEntry();
                }
            }
            projectData = projectData2;
            return projectData;
        }
        finally {
            if (tDBViewEntryCollection != null) {
                tDBViewEntryCollection.close();
            }
            if (tDBView != null) {
                tDBView.close();
            }
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
        }
    }

    public NodeData loadNodeData(TDBViewEntry tDBViewEntry) throws TDBException {
        ProjectInfo projectInfo;
        Object object;
        NodeData nodeData = new NodeData();
        nodeData.docId = tDBViewEntry.getId();
        nodeData.hierarchicalId = tDBViewEntry.getString(GanttViewUtil.HIERARCHICAL_ID_COL_INDEX);
        nodeData.uid = tDBViewEntry.getString(GanttViewUtil.UID_COL_INDEX);
        nodeData.name = tDBViewEntry.getString(GanttViewUtil.NAME_COL_INDEX);
        nodeData.startDate = tDBViewEntry.getDate(GanttViewUtil.STARTDATE_COL_INDEX);
        nodeData.endDate = tDBViewEntry.getDate(GanttViewUtil.ENDDATE_COL_INDEX);
        nodeData.resourceDns = tDBViewEntry.getStrings(GanttViewUtil.RESOURCE_DN_COL_INDEX);
        nodeData.resourceUnits = tDBViewEntry.getIntegers(GanttViewUtil.RESOURCE_UNITS_COL_INDEX);
        if (!this.forAllocations && (object = tDBViewEntry.getStrings(GanttViewUtil.PREDECESSOR_ID_COL_INDEX)) != null && ((String[])object).length > 0) {
            projectInfo = tDBViewEntry.getStrings(GanttViewUtil.PREDECESSOR_TYPE_COL_INDEX);
            int[] nArray = tDBViewEntry.getIntegers(GanttViewUtil.PREDECESSOR_LAG_COL_INDEX);
            int[] nArray2 = tDBViewEntry.getIntegers(GanttViewUtil.PREDECESSOR_LAGFORMAT_COL_INDEX);
            ArrayList<Predecessor> arrayList = new ArrayList<Predecessor>();
            for (int i = 0; i < ((String[])object).length; ++i) {
                int n = Predecessor.predecessorTypeAsInt((String)projectInfo[i]);
                arrayList.add(new Predecessor(object[i], n, nArray[i], nArray2[i]));
            }
            nodeData.predecessors = arrayList;
        }
        nodeData.percentComplete = tDBViewEntry.getDouble(GanttViewUtil.PERCENT_COMPLETE_COL_INDEX);
        nodeData.status = tDBViewEntry.getString(GanttViewUtil.STATUS_COL_INDEX);
        object = tDBViewEntry.getString(GanttViewUtil.SUBPROJECT_ID_COL_INDEX);
        if (!UString.isEmpty((String)object)) {
            projectInfo = CacheUtil.getProjectInfo((TDBSession)this.dbSession, (String)this.siteId, (String)object);
            nodeData.subProject = new NameId(projectInfo == null ? null : projectInfo.getName(), (String)object);
            nodeData.subprojectOptions = tDBViewEntry.getString(GanttViewUtil.SUBPROJECT_OPTIONS_COL_INDEX);
        }
        return nodeData;
    }

    public static void dumpMemoryInfo(String string, boolean bl) {
        if (bl) {
            System.gc();
            try {
                Thread.sleep(20L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.gc();
        }
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        long l4 = l - l2 + l3;
        System.out.println(string + "xxxxxxx available Memory = " + l4);
    }
}

