/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.xsp;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBServer;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.docdb.TDBView;
import com.flowbuilder.docdb.TDBViewEntryCollection;
import com.flowbuilder.lib.Application;
import com.flowbuilder.server.directory.DirectoryUser;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttChartModel;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.gantt.xsp.XSPProjectDataLoader;
import com.triloggroup.gantt.xsp.XSPProjectModel;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.Date;
import java.util.HashMap;

public abstract class XSPGanttChartModel
extends GanttChartModel {
    protected HashMap<String, String> viewSubQueryByProjectId = new HashMap();

    public XSPGanttChartModel(String string, String string2) {
        super(string, string2);
    }

    protected XSPProjectModel createProjectModel(String string) {
        return new XSPProjectModel(this.globalContext, string);
    }

    public void init(Context context, TDBSession tDBSession, Date date, NLSBundle nLSBundle) throws TDBException, XSPException, GanttChartException {
        this.initNodeContext(tDBSession, date, nLSBundle);
        String string = this.getMainProjectModel().getProjectId();
        XSPProjectDataLoader xSPProjectDataLoader = new XSPProjectDataLoader(tDBSession, this.getSiteId());
        ProjectData projectData = xSPProjectDataLoader.loadAllNodes(string, this.getViewSubQuery(context, string), this.globalContext.getNLSBundle());
        this.initData(projectData);
        this.initShowPercentComplete(context);
    }

    protected void initData(ProjectData projectData) {
        this.resetTaskSeriesForInit();
        ((XSPProjectModel)this.nodeSetModel).initData(projectData);
    }

    public TGNode loadSubproject(Context context, GanttWBS ganttWBS) throws GanttChartException {
        try {
            String string = ganttWBS.getSubProject().getId();
            XSPProjectDataLoader xSPProjectDataLoader = new XSPProjectDataLoader(context.getDBSession(), this.getSiteId());
            ProjectData projectData = xSPProjectDataLoader.loadAllNodes(string, this.getViewSubQuery(context, string), this.globalContext.getNLSBundle());
            XSPProjectModel xSPProjectModel = this.createProjectModel(string);
            xSPProjectModel.initData(projectData);
            this.projectModels.put(string, xSPProjectModel);
            TGNode tGNode = xSPProjectModel.getRootNode();
            ganttWBS.addSubtask(tGNode);
            this.expandNode(ganttWBS);
            this.expandNode(tGNode);
            return tGNode;
        }
        catch (GanttChartException ganttChartException) {
            ganttChartException.printStackTrace();
            throw ganttChartException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GanttChartException("Error loading subproject", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAllFromDatabase(Context context, NLSBundle nLSBundle) throws TDBException, XSPException, GanttChartException {
        if (context != null) {
            this.init(context, context.getDBSession(), this.globalContext.getCurrentDate(), nLSBundle);
        } else {
            TDBServer tDBServer = null;
            TDBSession tDBSession = null;
            try {
                tDBServer = Application.getDBServer(null);
                DirectoryUser directoryUser = new DirectoryUser("pcollins", "floflo");
                tDBSession = tDBServer.createSession(directoryUser);
                this.init(context, tDBSession, this.globalContext.getCurrentDate(), nLSBundle);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)"Could not rebuild all the graph with data from database");
            }
            finally {
                if (tDBSession != null) {
                    tDBSession.close();
                }
                if (tDBServer != null) {
                    tDBServer.close();
                }
            }
        }
        this.fireStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GanttNode refreshNodeFromDatabase(Context context, String string) throws Exception {
        if (context == null) {
            throw new Exception("Cannot update Gantt node with null context");
        }
        String string2 = ((GanttNode)this.getNodeByDocId(string)).getProjectContext().getProjectId();
        if (UString.isEmpty((String)string2)) {
            throw new Exception("Cannot access project infor of the node");
        }
        ProjectModel projectModel = this.getProjectModel(string2);
        TDBSession tDBSession = context.getDBSession();
        TDBDatabase tDBDatabase = tDBSession.openDatabase("tg_pe_schedule");
        TDBView tDBView = null;
        TDBViewEntryCollection tDBViewEntryCollection = null;
        try {
            String string3 = this.getViewSubQuery(context, string2);
            string3 = UString.isEmpty((String)string3) ? "fbdocid = '" + string + "'" : string3 + " AND fbdocid = '" + string + "'";
            tDBView = tDBDatabase.openView("alltasksandwbsforgantt", string3);
            tDBViewEntryCollection = tDBView.getAllEntries();
            XSPProjectDataLoader xSPProjectDataLoader = new XSPProjectDataLoader(tDBSession, this.getSiteId());
            NodeData nodeData = xSPProjectDataLoader.loadNodeData(tDBViewEntryCollection.getFirstEntry());
            GanttNode ganttNode = ((XSPProjectModel)projectModel).refreshNodeFromDatabase(nodeData, string);
            return ganttNode;
        }
        finally {
            if (tDBViewEntryCollection != null) {
                tDBViewEntryCollection.close();
            }
            if (tDBView != null) {
                tDBView.close();
            }
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
        }
    }

    protected String getViewSubQuery(Context context, String string) throws XSPException {
        String string2 = this.viewSubQueryByProjectId.get(string);
        if (string2 == null) {
            string2 = "projectid = '" + string + "' AND siteid = '" + this.getSiteId() + "'";
            this.viewSubQueryByProjectId.put(string, string2);
        }
        return string2;
    }

    protected void initShowPercentComplete(Context context) {
        this.getMainProjectModel().getProjectContext().setShowPercentComplete(true);
    }

    protected abstract void initNodeContext(TDBSession var1, Date var2, NLSBundle var3) throws TDBException, GanttChartException;
}

