/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.xsp;

import com.flowbuilder.lib.Application;
import com.flowbuilder.server.preferences.PreferencesNode;
import com.flowbuilder.server.preferences.PreferencesServer;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.gantt.xsp.IXSPGanttChart;
import com.triloggroup.gantt.xsp.XSPGanttChartModel;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UXSPGanttChart {
    private static final String TILES_TO_UPDATE_PREFIX = "\ntiles:";

    protected UXSPGanttChart() {
    }

    public static String applyCommand(TGChart tGChart, Context context, String string, Map<String, String[]> map) throws Exception {
        if (TString.isEmpty((String)string)) {
            return "";
        }
        if (string.equalsIgnoreCase("tiles")) {
            return String.valueOf(tGChart.imgGetTilesCount());
        }
        if (string.equalsIgnoreCase("select")) {
            int n;
            int n2 = UXSPGanttChart.getIntParameter(map, "ganttY");
            TGNode tGNode = tGChart.getNodeFromY(n2, n = UXSPGanttChart.getIntParameter(map, "tile"));
            if (tGNode == null) {
                return "";
            }
            if (tGChart.isSelectedNode(tGNode)) {
                return tGNode.getDescription();
            }
            TGNode tGNode2 = UXSPGanttChart.getSelectedNode(tGChart);
            tGChart.setSelectedNode(tGNode);
            int n3 = tGChart.imgGetTileForNode(tGNode2);
            String string2 = TILES_TO_UPDATE_PREFIX;
            string2 = n3 >= 0 && n3 != n ? (n3 > n ? string2 + String.valueOf(n) + ',' + String.valueOf(n3) : string2 + String.valueOf(n3) + ',' + String.valueOf(n)) : string2 + String.valueOf(n);
            return "." + tGNode.getDescription() + string2;
        }
        if (string.equalsIgnoreCase("expand")) {
            Object object;
            int n;
            int n4 = UXSPGanttChart.getIntParameter(map, "ganttY");
            TGNode tGNode = tGChart.getNodeFromY(n4, n = UXSPGanttChart.getIntParameter(map, "tile"));
            if (tGNode == null) {
                return "";
            }
            int n5 = 46;
            int n6 = -1;
            if (!tGNode.isLeaf()) {
                int n7 = -1;
                try {
                    n7 = UXSPGanttChart.getIntParameter(map, "ganttX");
                    if (tGChart.getTreeTable().getTreeCellRenderer().isLocationInExpandControl(tGNode, n7, n4, null)) {
                        n6 = tGChart.getPeferredTreeTableWidth();
                        if (tGNode.isExpanded()) {
                            tGChart.collapseNode(tGNode);
                            n5 = 45;
                        } else {
                            TGChartModel tGChartModel;
                            if (!tGChart.expandNode(tGNode) && !tGNode.isExpanded() && tGNode instanceof GanttWBS && ((GanttWBS)(object = (GanttWBS)tGNode)).isSubProject() && !((TGNode)object).hasVisibleSubtask() && (tGChartModel = tGChart.getModel()) instanceof XSPGanttChartModel) {
                                TGNode tGNode3;
                                tGNode = tGNode3 = ((XSPGanttChartModel)tGChartModel).loadSubproject(context, (GanttWBS)object);
                            }
                            n5 = 43;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TGNode tGNode4 = UXSPGanttChart.getSelectedNode(tGChart);
            int n8 = tGChart.imgGetTileForNode(tGNode4);
            if (n5 == 46) {
                if (tGNode == tGNode4) {
                    return tGNode.getDescription();
                }
                object = TILES_TO_UPDATE_PREFIX;
                object = n8 >= 0 && n8 != n ? (n8 > n ? (String)object + String.valueOf(n) + ',' + String.valueOf(n8) : (String)object + String.valueOf(n8) + ',' + String.valueOf(n)) : (String)object + String.valueOf(n);
            } else {
                object = n6 == tGChart.getPeferredTreeTableWidth() ? (n8 < 0 || n8 >= n ? "\ntiles:+," + n : TILES_TO_UPDATE_PREFIX + n8 + ",+," + n) : "";
            }
            if (tGNode == tGNode4) {
                tGChart.setSelectedNode(null);
            }
            tGChart.setSelectedNode(tGNode);
            return (char)n5 + tGNode.getDescription() + (String)object;
        }
        if (string.equalsIgnoreCase("details")) {
            int n = UXSPGanttChart.getIntParameter(map, "ganttY");
            int n9 = UXSPGanttChart.getIntParameter(map, "tile");
            TGNode tGNode = tGChart.getNodeFromY(n, n9);
            tGChart.sendDetailsPage(tGNode);
            return "";
        }
        if (string.equalsIgnoreCase("options")) {
            String string3 = UXSPGanttChart.getParameter(map, "columns");
            if (!TString.isEmpty((String)string3)) {
                boolean bl = string3.indexOf(78) >= 0;
                boolean bl2 = string3.indexOf(73) >= 0;
                boolean bl3 = string3.indexOf(68) >= 0;
                boolean bl4 = string3.indexOf(82) >= 0;
                String[] stringArray = TGTreeTableModel.getColumnKeyNames(bl, bl2, bl3, bl4);
                tGChart.updateTableColumnOption(stringArray);
                UXSPGanttChart.setUserPreferenceTableColumns(context, ((IXSPGanttChart)((Object)tGChart)).getChartType(), string3);
                TGNode tGNode = UXSPGanttChart.getSelectedNode(tGChart);
                if (tGNode != null) {
                    tGChart.setSelectedNode(null);
                    tGChart.setSelectedNode(tGNode);
                }
                return "ok";
            }
            return "";
        }
        if (string.equalsIgnoreCase("refreshNode")) {
            String string4;
            String string5 = UXSPGanttChart.getParameter(map, "docId");
            TGNode tGNode = UXSPGanttChart.getSelectedNode(tGChart);
            String string6 = string4 = tGNode == null ? null : tGNode.getDocId();
            if (TString.isEmpty((String)string5)) {
                ((IXSPGanttChart)((Object)tGChart)).rebuildAllFromDatabase(context);
                String string7 = UXSPGanttChart.getUserPreferenceTableColumns(context, ((IXSPGanttChart)((Object)tGChart)).getChartType());
                UXSPGanttChart.setColumns(tGChart, string7);
            } else {
                ((IXSPGanttChart)((Object)tGChart)).refreshNodeFromDatabase(context, string5);
            }
            tGChart.getModel().reapplyCurrentFilter();
            if (string4 != null) {
                tGChart.updateSelectionWithDocId(string4);
            }
            return "ok";
        }
        if (string.equalsIgnoreCase("filter")) {
            String string8 = UXSPGanttChart.getParameter(map, "status");
            String string9 = UXSPGanttChart.getParameter(map, "nameOption");
            String string10 = UXSPGanttChart.getParameter(map, "nameText");
            String string11 = UXSPGanttChart.getParameter(map, "resource");
            tGChart.applyFilter(string8, string9, string10, string11);
            TGNode tGNode = UXSPGanttChart.getSelectedNode(tGChart);
            if (tGNode != null) {
                tGChart.setSelectedNode(null);
                if (!tGNode.isHiddenByFilter()) {
                    tGChart.setSelectedNode(tGNode);
                }
            }
            return "ok";
        }
        if (string.equalsIgnoreCase("dateRange")) {
            Date date = UXSPGanttChart.getDateParameter(map, "startDate");
            Date date2 = UXSPGanttChart.getDateParameter(map, "endDate");
            if (date != null && date2 != null) {
                tGChart.setGraphDates(date.getTime(), date2.getTime());
            }
            return "ok";
        }
        String string12 = UXSPGanttChart.getParameter(map, "ganttRate");
        double d = 0.0;
        if (!TString.isEmpty((String)string12)) {
            try {
                d = Double.parseDouble(string12);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tGChart.doDatesChangeCommand(string, d);
    }

    public static String getParameter(Map<String, String[]> map, String string) {
        String[] stringArray;
        if (map != null && (stringArray = map.get(string)) != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public static int getIntParameter(Map<String, String[]> map, String string) {
        String string2 = UXSPGanttChart.getParameter(map, string);
        if (TString.isEmpty((String)string2)) {
            throw new IllegalArgumentException(string + " param is undefined");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            try {
                double d = Double.parseDouble(string2);
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    return (int)Math.round(d);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalArgumentException("invalid " + string + " param " + string2);
        }
    }

    public static Date getDateParameter(Map<String, String[]> map, String string) {
        String string2 = UXSPGanttChart.getParameter(map, string);
        if (TString.isEmpty((String)string2)) {
            throw new IllegalArgumentException(string + " param is undefined");
        }
        Date date = null;
        try {
            date = JDOMUtil.parseDate((String)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            try {
                date = new Date(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid " + string + " param " + string2);
            }
        }
        return date;
    }

    public static String[] getUserPreferenceTableColumnKeyNames(Context context, String string) {
        String string2 = UXSPGanttChart.getUserPreferenceTableColumns(context, string);
        boolean bl = string2.indexOf(78) >= 0;
        boolean bl2 = string2.indexOf(73) >= 0;
        boolean bl3 = string2.indexOf(68) >= 0;
        boolean bl4 = string2.indexOf(82) >= 0;
        return TGTreeTableModel.getColumnKeyNames(bl, bl2, bl3, bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserPreferenceTableColumns(Context context, String string) {
        if (context != null) {
            PreferencesServer preferencesServer = null;
            try {
                PreferencesNode preferencesNode;
                PreferencesNode preferencesNode2;
                PreferencesNode preferencesNode3;
                preferencesServer = Application.getPreferencesServer(null);
                if (preferencesServer != null && (preferencesNode3 = preferencesServer.getRootNode(context.getUser())) != null && (preferencesNode2 = preferencesNode3.node("/ganttPrefs/lightGantt")) != null && (preferencesNode = preferencesNode2.node(string)) != null) {
                    String string2 = preferencesNode.get("columnsToDisplay", "NIDR");
                    return string2;
                }
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)("Could no get prefered TableColumns for chart " + string));
            }
            finally {
                if (preferencesServer != null) {
                    preferencesServer.close();
                }
            }
        }
        return "NIDR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserPreferenceTableColumns(Context context, String string, String string2) {
        if (context != null) {
            PreferencesServer preferencesServer = null;
            try {
                PreferencesNode preferencesNode;
                preferencesServer = Application.getPreferencesServer(null);
                if (preferencesServer != null && (preferencesNode = preferencesServer.getRootNode(context.getUser())) != null) {
                    PreferencesNode preferencesNode2 = preferencesNode.node("/ganttPrefs/lightGantt");
                    PreferencesNode preferencesNode3 = preferencesNode2.node(string);
                    if (TString.isEmpty((String)string2)) {
                        preferencesNode3.remove("columnsToDisplay");
                    } else {
                        preferencesNode3.put("columnsToDisplay", string2);
                    }
                    preferencesNode3.flush();
                }
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)("Could no store prefered TableColumns for chart " + string));
            }
            finally {
                if (preferencesServer != null) {
                    preferencesServer.close();
                }
            }
        }
    }

    public static void setColumns(TGChart tGChart, String string) {
        boolean bl = string.indexOf(78) >= 0;
        boolean bl2 = string.indexOf(73) >= 0;
        boolean bl3 = string.indexOf(68) >= 0;
        boolean bl4 = string.indexOf(82) >= 0;
        String[] stringArray = TGTreeTableModel.getColumnKeyNames(bl, bl2, bl3, bl4);
        tGChart.updateTableColumnOption(stringArray);
    }

    private static TGNode getSelectedNode(TGChart tGChart) {
        TGNode[] tGNodeArray = tGChart.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return null;
        }
        return tGNodeArray[0];
    }
}

