/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.util;

import com.triloggroup.gantt.util.AbstractIntervals;
import com.triloggroup.gantt.util.Interval;
import com.triloggroup.gantt.util.ValueInterval;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueIntervals
extends AbstractIntervals<ValueInterval> {
    private final int defaultValue = 0;

    public static boolean equals(ValueIntervals valueIntervals, ValueIntervals valueIntervals2) {
        if (valueIntervals == null) {
            return valueIntervals2 == null;
        }
        if (valueIntervals2 == null) {
            return false;
        }
        if (valueIntervals.defaultValue != valueIntervals2.defaultValue) {
            return false;
        }
        ArrayList arrayList = valueIntervals.list;
        ArrayList arrayList2 = valueIntervals2.list;
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ValueInterval valueInterval;
            ValueInterval valueInterval2 = (ValueInterval)arrayList.get(i);
            if (ValueInterval.equals(valueInterval2, valueInterval = (ValueInterval)arrayList2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ValueIntervals loadFromString(String string) {
        if (!string.startsWith("Intervals(") || !string.endsWith(")")) {
            throw new IllegalArgumentException("not a valid intervals: " + string);
        }
        ValueIntervals valueIntervals = new ValueIntervals();
        if (string.length() > "Intervals(".length() + 1) {
            int n = "Intervals(".length();
            while (n > 0) {
                char c = string.charAt(n);
                if (c != '[') {
                    throw new IllegalArgumentException("not a valid intervals: " + string);
                }
                int n2 = string.indexOf(44, n + 2);
                long l = Long.parseLong(string.substring(n + 1, n2));
                int n3 = string.indexOf(91, n2 + 2);
                long l2 = Long.parseLong(string.substring(n2 + 1, n3));
                c = string.charAt(n3 + 1);
                if (c != ':') {
                    throw new IllegalArgumentException("not a valid intervals: " + string);
                }
                int n4 = string.indexOf(44, n3 + 2);
                if (n4 < 0) {
                    n4 = string.length() - 1;
                    n = -1;
                } else {
                    n = n4 + 1;
                }
                int n5 = Integer.parseInt(string.substring(n3 + 2, n4));
                valueIntervals.addInterval(new ValueInterval(l, l2, n5));
            }
        }
        return valueIntervals;
    }

    public void addInterval(ValueInterval valueInterval) {
        if (valueInterval.value == 0) {
            return;
        }
        if (this.list.isEmpty()) {
            if (valueInterval.value != 0) {
                this.list.add(valueInterval);
            }
            return;
        }
        if (valueInterval.start > this.getLastIntervalEnd()) {
            if (valueInterval.value != 0) {
                this.list.add(valueInterval);
            }
            return;
        }
        if (valueInterval.end < this.getFirstIntervalStart()) {
            if (valueInterval.value != 0) {
                this.list.add(0, valueInterval);
            }
            return;
        }
        int n = Collections.binarySearch(this.list, valueInterval, intervalStartComparator);
        if (n >= 0) {
            ValueInterval valueInterval2 = (ValueInterval)this.list.get(n);
            if (valueInterval.end > valueInterval2.end) {
                boolean bl = this.replaceIntervalAt(n, new ValueInterval(valueInterval.start, valueInterval2.end, valueInterval.value + valueInterval2.value));
                if (bl) {
                    this.checkMergeWithPreviousInterval(n);
                }
                this.addInterval(new ValueInterval(valueInterval2.end, valueInterval.end, valueInterval.value));
            } else {
                boolean bl = this.replaceIntervalAt(n, new ValueInterval(valueInterval.start, valueInterval.end, valueInterval.value + valueInterval2.value));
                if (bl) {
                    if (this.checkMergeWithPreviousInterval(n)) {
                        --n;
                    }
                } else {
                    --n;
                }
                if (valueInterval.end < valueInterval2.end) {
                    this.insertIntervalAt(n + 1, new ValueInterval(valueInterval.end, valueInterval2.end, valueInterval2.value));
                } else if (bl) {
                    this.checkMergeWithNextInterval(n);
                }
            }
        } else if ((n = -n - 1) > 0) {
            ValueInterval valueInterval3 = (ValueInterval)this.list.get(n - 1);
            if (valueInterval3.end > valueInterval.start) {
                this.replaceIntervalAt(n - 1, new ValueInterval(valueInterval3.start, valueInterval.start, valueInterval3.value));
                if (valueInterval3.end > valueInterval.end) {
                    this.insertIntervalAt(n, new ValueInterval(valueInterval.end, valueInterval3.end, valueInterval3.value));
                    this.insertIntervalAt(n, new ValueInterval(valueInterval.start, valueInterval.end, valueInterval3.value + valueInterval.value));
                } else {
                    boolean bl = this.insertIntervalAt(n, new ValueInterval(valueInterval.start, valueInterval3.end, valueInterval3.value + valueInterval.value));
                    if (valueInterval3.end == valueInterval.end) {
                        if (bl) {
                            this.checkMergeWithNextInterval(n);
                        }
                    } else {
                        this.addInterval(new ValueInterval(valueInterval3.end, valueInterval.end, valueInterval.value));
                    }
                }
            } else {
                this.addIntervalPrevOk(n, valueInterval);
            }
        } else {
            this.addIntervalPrevOk(0, valueInterval);
        }
    }

    private void addIntervalPrevOk(int n, ValueInterval valueInterval) {
        if (n >= this.list.size()) {
            boolean bl = this.insertIntervalAt(n, valueInterval);
            if (bl) {
                this.checkMergeWithPreviousInterval(n);
            }
            return;
        }
        ValueInterval valueInterval2 = (ValueInterval)this.list.get(n);
        if (valueInterval.end <= valueInterval2.start) {
            boolean bl = this.insertIntervalAt(n, valueInterval);
            if (bl) {
                if (valueInterval.end == valueInterval2.start) {
                    this.checkMergeWithNextAndPreviousIntervals(n);
                } else {
                    this.checkMergeWithPreviousInterval(n);
                }
            }
        } else {
            boolean bl = this.insertIntervalAt(n, new ValueInterval(valueInterval.start, valueInterval2.start, valueInterval.value));
            if (bl) {
                if (this.checkMergeWithPreviousInterval(n)) {
                    --n;
                }
                ++n;
            }
            if (valueInterval.end <= valueInterval2.end) {
                boolean bl2 = this.replaceIntervalAt(n, new ValueInterval(valueInterval2.start, valueInterval.end, valueInterval.value + valueInterval2.value));
                if (!bl2) {
                    --n;
                }
                if (valueInterval.end == valueInterval2.end) {
                    this.checkMergeWithNextInterval(n);
                } else {
                    this.insertIntervalAt(n + 1, new ValueInterval(valueInterval.end, valueInterval2.end, valueInterval2.value));
                }
            } else {
                this.replaceIntervalAt(n, new ValueInterval(valueInterval2.start, valueInterval2.end, valueInterval.value + valueInterval2.value));
                this.addInterval(new ValueInterval(valueInterval2.end, valueInterval.end, valueInterval.value));
            }
        }
    }

    private boolean insertIntervalAt(int n, ValueInterval valueInterval) {
        if (valueInterval.value != 0) {
            this.list.add(n, valueInterval);
            return true;
        }
        return false;
    }

    private boolean replaceIntervalAt(int n, ValueInterval valueInterval) {
        if (valueInterval.value != 0) {
            this.list.set(n, valueInterval);
            return true;
        }
        this.list.remove(n);
        return false;
    }

    private void checkMergeWithNextAndPreviousIntervals(int n) {
        this.checkMergeWithNextInterval(n);
        this.checkMergeWithPreviousInterval(n);
    }

    private boolean checkMergeWithNextInterval(int n) {
        if (n < this.list.size() - 1) {
            return this.checkMergeWithPreviousInterval(n + 1);
        }
        return false;
    }

    private boolean checkMergeWithPreviousInterval(int n) {
        if (n < 1) {
            return false;
        }
        ValueInterval valueInterval = (ValueInterval)this.list.get(n - 1);
        ValueInterval valueInterval2 = (ValueInterval)this.list.get(n);
        if (valueInterval.end == valueInterval2.start && valueInterval.value == valueInterval2.value) {
            this.list.set(n - 1, new ValueInterval(valueInterval.start, valueInterval2.end, valueInterval.value));
            this.list.remove(n);
            return true;
        }
        return false;
    }

    public void removeInterval(ValueInterval valueInterval) {
        ValueInterval valueInterval2 = new ValueInterval(valueInterval.start, valueInterval.end, -valueInterval.value);
        this.addInterval(valueInterval2);
    }

    public void setInterval(ValueInterval valueInterval) {
        if (valueInterval.value == 0) {
            this.resetInterval(valueInterval);
            return;
        }
        if (this.isEmpty() || valueInterval.start > this.getLastIntervalEnd()) {
            this.list.add(valueInterval);
            return;
        }
        if (valueInterval.end < this.getFirstIntervalStart()) {
            this.list.add(0, valueInterval);
            return;
        }
        this.resetInterval(valueInterval);
        this.addInterval(valueInterval);
    }

    public void resetInterval(Interval interval) {
        ValueInterval valueInterval;
        if (this.isEmpty()) {
            return;
        }
        if (interval.start >= this.getLastIntervalEnd()) {
            return;
        }
        if (interval.end < this.getFirstIntervalStart()) {
            return;
        }
        int n = Collections.binarySearch(this.list, interval, intervalStartComparator);
        if (n < 0 && (n = -n - 1) > 0) {
            valueInterval = (ValueInterval)this.list.get(n - 1);
            if (valueInterval.end > interval.start) {
                this.replaceIntervalAt(n - 1, new ValueInterval(valueInterval.start, interval.start, valueInterval.value));
                if (valueInterval.end > interval.end) {
                    this.insertIntervalAt(n, new ValueInterval(interval.end, valueInterval.end, valueInterval.value));
                    return;
                }
                if (valueInterval.end == interval.end) {
                    return;
                }
            }
        }
        while (n < this.list.size()) {
            valueInterval = (ValueInterval)this.list.get(n);
            if (valueInterval.start > interval.end) {
                return;
            }
            if (valueInterval.end > interval.end) {
                this.replaceIntervalAt(n, new ValueInterval(interval.end, valueInterval.end, valueInterval.value));
                return;
            }
            this.list.remove(n);
            if (valueInterval.end != interval.end) continue;
            return;
        }
    }

    public int getValueAt(long l) {
        ValueInterval valueInterval = this.getValueIntervalAt(l);
        return valueInterval == null ? 0 : valueInterval.value;
    }

    public ValueInterval getValueIntervalAt(long l) {
        return (ValueInterval)this.getIntervalAt(l);
    }

    public int getMinValue(long l, long l2) {
        return this.getMinOrMaxValue(l, l2, false);
    }

    public int getMaxValue(long l, long l2) {
        return this.getMinOrMaxValue(l, l2, true);
    }

    private int getMinOrMaxValue(long l, long l2, boolean bl) {
        long l3;
        int n;
        ValueInterval valueInterval;
        if (this.isEmpty() || l2 < this.getFirstIntervalStart() || l >= this.getLastIntervalEnd()) {
            return 0;
        }
        boolean bl2 = false;
        int n2 = Collections.binarySearch(this.list, new Interval(l, l + 1L), intervalStartComparator);
        if (n2 >= 0) {
            valueInterval = (ValueInterval)this.list.get(n2);
            n = valueInterval.value;
            l3 = valueInterval.end;
        } else if ((n2 = -n2 - 2) < 0) {
            n = 0;
            l3 = 0L;
            bl2 = true;
        } else {
            valueInterval = (ValueInterval)this.list.get(n2);
            if (valueInterval.end > l) {
                n = valueInterval.value;
                l3 = valueInterval.end;
            } else {
                n = 0;
                l3 = 0L;
                bl2 = true;
            }
        }
        ++n2;
        while (n2 < this.list.size()) {
            valueInterval = (ValueInterval)this.list.get(n2);
            if (valueInterval.start >= l2) break;
            if (!bl2) {
                if (valueInterval.start > l3) {
                    if (bl ^ 0 < n) {
                        n = 0;
                    }
                    bl2 = true;
                } else {
                    l3 = valueInterval.end;
                }
            }
            if (bl ^ valueInterval.value < n) {
                n = valueInterval.value;
            }
            ++n2;
        }
        if (!bl2 && l3 < l2 && bl ^ 0 < n) {
            n = 0;
        }
        return n;
    }

    public boolean isValueOver(long l, long l2, int n) {
        return this.isOverOrUnderValue(l, l2, n, true);
    }

    public boolean isValueUnder(long l, long l2, int n) {
        return this.isOverOrUnderValue(l, l2, n, false);
    }

    private boolean isOverOrUnderValue(long l, long l2, int n, boolean bl) {
        long l3;
        ValueInterval valueInterval;
        if (bl) {
            ++n;
        }
        if (this.isEmpty() || l2 < this.getFirstIntervalStart() || l >= this.getLastIntervalEnd()) {
            return 0 < n ^ bl;
        }
        boolean bl2 = false;
        int n2 = Collections.binarySearch(this.list, new Interval(l, l + 1L), intervalStartComparator);
        if (n2 >= 0) {
            valueInterval = (ValueInterval)this.list.get(n2);
            if (valueInterval.value < n ^ bl) {
                return true;
            }
            l3 = valueInterval.end;
        } else if ((n2 = -n2 - 2) < 0) {
            if (0 < n ^ bl) {
                return true;
            }
            l3 = 0L;
            bl2 = true;
        } else {
            valueInterval = (ValueInterval)this.list.get(n2);
            if (valueInterval.end > l) {
                if (valueInterval.value < n ^ bl) {
                    return true;
                }
                l3 = valueInterval.end;
            } else {
                if (0 < n ^ bl) {
                    return true;
                }
                l3 = 0L;
                bl2 = true;
            }
        }
        ++n2;
        while (n2 < this.list.size()) {
            valueInterval = (ValueInterval)this.list.get(n2);
            if (valueInterval.start >= l2) break;
            if (!bl2) {
                if (valueInterval.start > l3) {
                    if (0 < n ^ bl) {
                        return true;
                    }
                    bl2 = true;
                } else {
                    l3 = valueInterval.end;
                }
            }
            if (valueInterval.value < n ^ bl) {
                return true;
            }
            ++n2;
        }
        return !bl2 && l3 < l2 && 0 < n ^ bl;
    }
}

