/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.util;

import com.triloggroup.gantt.util.AbstractIntervals;
import com.triloggroup.gantt.util.Interval;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Intervals
extends AbstractIntervals<Interval> {
    public void addInterval(long l, long l2) {
        this.addInterval(new Interval(l, l2));
    }

    public void addInterval(Interval interval) {
        if (this.list.isEmpty()) {
            this.list.add(interval);
            return;
        }
        if (interval.start > this.getLastIntervalEnd()) {
            this.list.add(interval);
            return;
        }
        if (interval.end < this.getFirstIntervalStart()) {
            this.list.add(0, interval);
            return;
        }
        int n = Collections.binarySearch(this.list, interval, intervalStartComparator);
        if (n >= 0) {
            Interval interval2 = (Interval)this.list.get(n);
            if (interval.end > interval2.end) {
                this.list.set(n, interval);
                this.fixOverlappingIntervals(n, interval);
            }
        } else if ((n = -n - 1) > 0) {
            Interval interval3 = (Interval)this.list.get(n - 1);
            if (interval3.end < interval.start) {
                this.list.add(n, interval);
                this.fixOverlappingIntervals(n, interval);
            } else {
                if (interval3.end >= interval.end) {
                    return;
                }
                Interval interval4 = new Interval(interval3.start, interval.end);
                this.list.set(n - 1, interval4);
                this.fixOverlappingIntervals(n - 1, interval4);
            }
        } else {
            this.list.add(0, interval);
            this.fixOverlappingIntervals(0, interval);
        }
    }

    private void fixOverlappingIntervals(int n, Interval interval) {
        ++n;
        while (n < this.list.size()) {
            Interval interval2 = (Interval)this.list.get(n);
            if (interval2.start > interval.end) {
                return;
            }
            if (interval2.end > interval.end) {
                this.list.set(n - 1, new Interval(interval.start, interval2.end));
                this.list.remove(n);
                return;
            }
            this.list.remove(n);
            if (interval2.end == interval.end) {
                return;
            }
            --n;
            ++n;
        }
    }

    public void removeInterval(long l, long l2) {
        this.removeInterval(new Interval(l, l2));
    }

    public void removeInterval(Interval interval) {
        if (this.list.isEmpty()) {
            return;
        }
        if (interval.end < this.getFirstIntervalStart() || interval.start > this.getLastIntervalEnd()) {
            return;
        }
        int n = Collections.binarySearch(this.list, interval, intervalStartComparator);
        if (n >= 0) {
            Interval interval2 = (Interval)this.list.get(n);
            if (interval.end < interval2.end) {
                this.list.set(n, new Interval(interval.end, interval2.end));
            } else {
                this.list.remove(n);
                if (interval.end > interval2.end) {
                    this.fixIntervalsForRemove(n, interval.end);
                }
            }
        } else if ((n = -n - 1) > 0) {
            Interval interval3 = (Interval)this.list.get(n - 1);
            if (interval3.end < interval.start) {
                this.fixIntervalsForRemove(n, interval.end);
            } else {
                if (interval3.end > interval.end) {
                    this.list.set(n - 1, new Interval(interval3.start, interval.start));
                    this.list.add(n, new Interval(interval.end, interval3.end));
                    return;
                }
                Interval interval4 = new Interval(interval3.start, interval.start);
                this.list.set(n - 1, interval4);
                this.fixIntervalsForRemove(n, interval.end);
            }
        } else {
            this.fixIntervalsForRemove(n, interval.end);
        }
    }

    private void fixIntervalsForRemove(int n, long l) {
        while (n < this.list.size()) {
            Interval interval = (Interval)this.list.get(n);
            if (interval.start > l) {
                return;
            }
            if (interval.end > l) {
                this.list.set(n, new Interval(l, interval.end));
                return;
            }
            this.list.remove(n);
            if (interval.end == l) {
                return;
            }
            --n;
            ++n;
        }
    }
}

