/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.renderer;

import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.util.GanttCalendarUtil;
import com.triloggroup.gantt.util.Interval;
import com.triloggroup.gantt.util.Intervals;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.ui.UGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.DateRange;
import org.jfree.ui.RectangleEdge;

public abstract class TGNodeRenderer
extends BarRenderer {
    public static final Color BACKGROUND_SELECTION_COLOR = UGraphic.getColorWithAlphaForWhiteBackground((Color)UIConstants.BACKGROUND_SELECTION_COLOR, (int)128);
    public static final Color OFF_DAY_COLOR = UGraphic.getColorWithAlphaForWhiteBackground((Color)TGChart.OFF_DAY_COLOR, (int)128);
    public static final int LABEL_GAP_SIZE = 10;
    public static final int PREDECESSOR_AREA_WIDTH = 8;
    public static final Color HEALTH_CRITICAL_COLOR = new Color(255, 51, 51);
    public static final Color HEALTH_WARNING_COLOR = new Color(255, 204, 102);
    public static final Color HEALTH_DONE_COLOR = new Color(51, 153, 255);
    public static final Color HEALTH_DEFAULT_COLOR = new Color(102, 204, 153);
    public static final Color HEALTH_ABORTED_COLOR = new Color(102, 102, 102);
    protected static final Color WBS_COLOR = Color.BLACK;
    protected static final Color SUBPROJECT_COLOR = new Color(176, 176, 176);
    protected boolean renderPredecessorLinks = false;
    protected double startPercent = 0.35;
    protected double endPercent = 0.65;

    public TGNodeRenderer() {
        this.setDrawBarOutline(false);
    }

    protected abstract void drawNode(Graphics2D var1, CategoryItemRendererState var2, Rectangle2D var3, TGCategoryPlot var4, CategoryAxis var5, ValueAxis var6, GanttDataset var7, int var8, int var9);

    protected void drawPredecessors(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2) {
    }

    public void setRenderPredecessorLinks(boolean bl) {
        this.renderPredecessorLinks = bl;
    }

    public boolean isRenderPredecessorLinks() {
        return this.renderPredecessorLinks;
    }

    public int getPassCount() {
        return this.renderPredecessorLinks ? 2 : 1;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        categoryItemRendererState.setBarWidth(12.0);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof GanttDataset) {
            GanttDataset ganttDataset = (GanttDataset)categoryDataset;
            if (n3 == 0) {
                this.drawNode(graphics2D, categoryItemRendererState, rectangle2D, (TGCategoryPlot)categoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2);
            } else {
                this.drawPredecessors(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2);
            }
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawShapeOutline(Graphics2D graphics2D, Shape shape, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(n, n2);
            Paint paint = this.getItemOutlinePaint(n, n2);
            if (stroke != null && paint != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint);
                graphics2D.draw(shape);
            }
        }
    }

    protected void drawBackgroundSelection(TGNode tGNode, Graphics2D graphics2D, double d, Rectangle2D rectangle2D, CategoryPlot categoryPlot) {
        TGCategoryPlot tGCategoryPlot = (TGCategoryPlot)categoryPlot;
        if (!tGCategoryPlot.isFocused()) {
            return;
        }
        this.drawRowBackground(BACKGROUND_SELECTION_COLOR, graphics2D, d, rectangle2D, tGCategoryPlot);
    }

    protected void drawRowBackground(Paint paint, Graphics2D graphics2D, double d, Rectangle2D rectangle2D, CategoryPlot categoryPlot) {
        if (paint != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(categoryPlot.getInsets().getLeft(), d - 2.0 - 1.0, rectangle2D.getWidth(), GanttChart.getRowHeight());
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    protected void drawCalendarOffDays(Graphics2D graphics2D, ScheduleCalendar scheduleCalendar, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, double d) {
        if (scheduleCalendar == null) {
            return;
        }
        DateRange dateRange = (DateRange)valueAxis.getRange();
        Intervals intervals = GanttCalendarUtil.getOffPeriods(scheduleCalendar, dateRange.getLowerDate().getTime(), dateRange.getUpperDate().getTime());
        if (intervals != null && !intervals.isEmpty()) {
            double d2 = d - 2.0 - 1.0;
            double d3 = GanttChart.getRowHeight();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            graphics2D.setPaint(OFF_DAY_COLOR);
            for (int i = 0; i < intervals.size(); ++i) {
                Object t = intervals.get(i);
                int n = (int)valueAxis.lengthToJava2D((double)(((Interval)t).end - ((Interval)t).start), rectangle2D, rectangleEdge);
                if (n <= 2) continue;
                int n2 = (int)valueAxis.valueToJava2D((double)((Interval)t).start, rectangle2D, rectangleEdge);
                Rectangle2D.Double double_ = new Rectangle2D.Double(n2, d2, n + 1, d3);
                graphics2D.fill(double_);
            }
        }
    }

    protected void drawPercentComplete(Graphics2D graphics2D, TGNode tGNode, Rectangle2D rectangle2D) {
        Double d = tGNode.getPercentComplete();
        if (d != null && d > 0.0) {
            double d2 = d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.startPercent * rectangle2D.getHeight(), rectangle2D.getWidth() * d2, rectangle2D.getHeight() * (this.endPercent - this.startPercent));
            graphics2D.setPaint(Color.black);
            graphics2D.fill(double_);
        }
    }

    protected void checkHorizontalOrientation(CategoryPlot categoryPlot) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation != PlotOrientation.HORIZONTAL) {
            throw new IllegalStateException("Orientation not supported: " + plotOrientation);
        }
    }

    protected Color getHealthStatusColor(GanttNode ganttNode) {
        boolean bl = "Aborted".equals(ganttNode.getStatus());
        if (ganttNode.isProjectRoot() && ganttNode.getProjectContext() instanceof GanttProjectContext) {
            bl = "Aborted".equals(((GanttProjectContext)ganttNode.getProjectContext()).getProjectStatus());
        }
        if (bl) {
            return HEALTH_ABORTED_COLOR;
        }
        int n = ganttNode.getHealthStatus();
        switch (n) {
            case 3: {
                return HEALTH_CRITICAL_COLOR;
            }
            case 2: {
                return HEALTH_WARNING_COLOR;
            }
            case 0: {
                return HEALTH_DONE_COLOR;
            }
        }
        return HEALTH_DEFAULT_COLOR;
    }
}

