/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.projects;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBDocument;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.docdb.TDBView;
import com.flowbuilder.docdb.TDBViewEntry;
import com.flowbuilder.util.TString;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.projects.ProjectNode;
import com.triloggroup.lwpbeans.util.db.DBEntries;
import com.triloggroup.lwpbeans.util.db.DBUtil;
import com.triloggroup.pe.schedule.ScheduleUtil;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.project.schedule.WBSComputation;
import com.triloggroup.project.schedule.xsp.XspWBSComputation;
import java.awt.Color;
import java.sql.Date;

class XSPProjectsLoader {
    private static final String PRJ_VIEW_NAME = "allprojectsdescbyid";
    private static int NAME_COL_IDX = -1;
    private static int SITE_ID_COL_IDX = -1;
    private static int ID_COL_IDX = -1;
    private static int START_COL_IDX = -1;
    private static int END_COL_IDX = -1;
    private static int STATUS_COL_IDX = -1;
    private static int WARNING_COL_IDX = -1;
    private static int CRITICAL_COL_IDX = -1;
    private static int CALENDAR_COL_IDX = -1;
    private TDBSession session;
    private GlobalContext globalCtx;
    private int nodeIdx = 0;
    private boolean hasSubprojects = false;

    XSPProjectsLoader(TDBSession tDBSession, GlobalContext globalContext) {
        this.session = tDBSession;
        this.globalCtx = globalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGNode loadProjects(String string, String ... tDBDatabase) throws Exception {
        TGNode tGNode = TGNode.createFakeRoot();
        tGNode.setNodeContext(this.globalCtx);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("siteid='").append(string).append("' and projectid in(");
        for (String string2 : tDBDatabase) {
            stringBuilder.append('\'').append(string2).append("',");
        }
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), ")");
        TDBDatabase tDBDatabase2 = null;
        DBEntries dBEntries = DBUtil.openSortedEntries((TDBSession)this.session, (String)"tg_pe_project", (String)PRJ_VIEW_NAME, (String)stringBuilder.toString(), (String)"name");
        try {
            this.initViewIdx(dBEntries.getView());
            tDBDatabase2 = this.session.openDatabase("tg_pe_schedule");
            for (String string2 : dBEntries) {
                ProjectNode projectNode = this.createProjectNode((TDBViewEntry)string2, tDBDatabase2, null);
                if (projectNode.getAllSubTaskCount() > 0) {
                    this.hasSubprojects = true;
                }
                tGNode.addSubtask(projectNode);
            }
        }
        finally {
            dBEntries.close();
            if (tDBDatabase2 != null) {
                tDBDatabase2.close();
            }
        }
        return tGNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectNode createProjectNode(TDBViewEntry tDBViewEntry, TDBDatabase tDBDatabase, XspWBSComputation.WBSTree wBSTree) throws Exception {
        ScheduleCalendar scheduleCalendar;
        TDBDocument tDBDocument;
        String string;
        String string2 = tDBViewEntry.getString(NAME_COL_IDX);
        String string3 = tDBViewEntry.getString(SITE_ID_COL_IDX);
        String string4 = tDBViewEntry.getString(ID_COL_IDX);
        Date date = tDBViewEntry.getDate(START_COL_IDX);
        Date date2 = tDBViewEntry.getDate(END_COL_IDX);
        String string5 = tDBViewEntry.getString(STATUS_COL_IDX);
        if (date.after(date2)) {
            date2 = date;
        }
        ProjectNode projectNode = new ProjectNode(string2, string4, date, date2, "PRJ_NODE_" + this.nodeIdx++);
        projectNode.setDocId(tDBViewEntry.getId());
        projectNode.setNodeContext(this.globalCtx);
        projectNode.setStatus(string5);
        if (wBSTree == null) {
            XspWBSComputation xspWBSComputation = new XspWBSComputation();
            wBSTree = xspWBSComputation.loadWbsSubtree(tDBDatabase, string3, projectNode.getProjectId(), "1");
            xspWBSComputation.rescheduleAllWBSProgress((WBSComputation.IWBS)wBSTree.root);
        }
        double d = wBSTree.root.getProgress();
        double d2 = wBSTree.root.getPlannedProgress();
        double d3 = tDBViewEntry.getDouble(WARNING_COL_IDX);
        double d4 = tDBViewEntry.getDouble(CRITICAL_COL_IDX);
        String string6 = ScheduleUtil.getProgressColor((java.util.Date)projectNode.getFinishDate(), (float)((float)d2 * 100.0f), (float)((float)d * 100.0f), (float)((float)d3), (float)((float)d4));
        Color color = new Color(Integer.parseInt(string6.substring(1), 16));
        projectNode.setColor(color);
        projectNode.setProgress(d);
        String string7 = tDBViewEntry.getString(CALENDAR_COL_IDX);
        TDBView tDBView = tDBViewEntry.getView().getDatabase().openView("allcalendars");
        try {
            TDBDocument tDBDocument2 = tDBView.getDocumentByKey(new String[]{string3, string4, string7});
            Object object = new ScheduleCalendar(tDBDocument2.getDOM());
            if (!object.isBaseCalendar() && !TString.isEmpty((String)(string = object.getBaseCalendarId()))) {
                tDBDocument = tDBView.getDocumentByKey(new String[]{string3, string4, string});
                scheduleCalendar = new ScheduleCalendar(tDBDocument.getDOM());
                object.mergeWithBaseCalendar(scheduleCalendar);
            }
            projectNode.setCalendar((ScheduleCalendar)object);
        }
        catch (Exception exception) {
            System.out.println("Unable to load project calendar");
            exception.printStackTrace();
        }
        finally {
            tDBView.close();
        }
        if (wBSTree.subprojects != null) {
            for (Object object : wBSTree.subprojects.keySet()) {
                string = "siteid='" + string3 + "' and projectid ='" + (String)object + '\'';
                tDBDocument = DBUtil.openEntries((TDBDatabase)tDBViewEntry.getView().getDatabase(), (String)PRJ_VIEW_NAME, (String)string.toString());
                try {
                    scheduleCalendar = (XspWBSComputation.WBSTree)wBSTree.subprojects.get(object);
                    ProjectNode projectNode2 = this.createProjectNode(tDBDocument.getEntries().getFirstEntry(), tDBDatabase, (XspWBSComputation.WBSTree)scheduleCalendar);
                    projectNode.addSubtask(projectNode2);
                }
                finally {
                    tDBDocument.close();
                }
            }
        }
        return projectNode;
    }

    boolean hasSubprojects() {
        return this.hasSubprojects;
    }

    private void initViewIdx(TDBView tDBView) throws TDBException {
        if (NAME_COL_IDX >= 0) {
            return;
        }
        NAME_COL_IDX = tDBView.getColumnIndexByName("name");
        SITE_ID_COL_IDX = tDBView.getColumnIndexByName("siteid");
        ID_COL_IDX = tDBView.getColumnIndexByName("id");
        START_COL_IDX = tDBView.getColumnIndexByName("startdate");
        END_COL_IDX = tDBView.getColumnIndexByName("enddate");
        STATUS_COL_IDX = tDBView.getColumnIndexByName("status");
        WARNING_COL_IDX = tDBView.getColumnIndexByName("warningthreshold");
        CRITICAL_COL_IDX = tDBView.getColumnIndexByName("criticalthreshold");
        CALENDAR_COL_IDX = tDBView.getColumnIndexByName("calendarid");
    }
}

