/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.projects;

import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.XMLException;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.NodeSetModel;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.pe.xsp.PEXSPTimeUnits;
import com.triloggroup.gantt.projects.ProjectNode;
import com.triloggroup.gantt.projects.ProjectRenderer;
import com.triloggroup.gantt.projects.ProjectsChart;
import com.triloggroup.gantt.projects.XSPProjectsLoader;
import com.triloggroup.gantt.xsp.IXSPGanttChart;
import com.triloggroup.gantt.xsp.UXSPGanttChart;
import com.triloggroup.util.NLSBundle;
import java.util.Map;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSPProjectsChart
extends ProjectsChart
implements IXSPGanttChart {
    public static final String CHART_TYPE = "projects_time_chart";

    public void initProjects(TDBSession tDBSession, String string, String ... stringArray) throws Exception {
        if (this.locale == null) {
            this.initLocale(null, null, null);
        }
        TGChartModel tGChartModel = new TGChartModel(string);
        tGChartModel.getGlobalContext().init(null, this.nlsBundle, this.createTimeUnits(this.nlsBundle));
        XSPProjectsLoader xSPProjectsLoader = new XSPProjectsLoader(tDBSession, tGChartModel.getGlobalContext());
        TGNode tGNode = xSPProjectsLoader.loadProjects(string, stringArray);
        NodeSetModel nodeSetModel = tGChartModel.getNodeSetModel();
        nodeSetModel.initRoot(tGNode);
        this.setModel(tGChartModel);
        ((CategoryPlot)this.chart.getPlot()).setRenderer((CategoryItemRenderer)new ProjectRenderer());
        this.getTreeTable().setVisibleColumns(new String[]{"Name", "StartDate", "EndDate"});
        if (!xSPProjectsLoader.hasSubprojects()) {
            this.getTreeTable().getTreeCellRenderer().showBorder(false);
        }
    }

    protected ITimeUnits createTimeUnits(NLSBundle nLSBundle) {
        return PEXSPTimeUnits.get(nLSBundle);
    }

    @Override
    public String applyCommand(Context context, String string, Map<String, String[]> map) throws Exception {
        if (TString.isEmpty((String)string)) {
            return "";
        }
        return UXSPGanttChart.applyCommand(this, context, string, map);
    }

    public String applyCommand(String string, Map<String, String[]> map) throws Exception {
        return this.applyCommand(null, string, map);
    }

    @Override
    public void rebuildAllFromDatabase(Context context) throws XMLException, TDBException, XSPException, GanttChartException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public void refreshNodeFromDatabase(Context context, String string) throws Exception {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public String getChartType() {
        return CHART_TYPE;
    }

    @Override
    protected String getDetailsURL(TGNode tGNode) {
        ProjectNode projectNode = (ProjectNode)tGNode;
        return "/projexec/dashboard/pe_portfolio_project_tooltip.xsp?ganttProjectId=" + projectNode.getProjectId() + "&ganttSiteId=" + this.model.getSiteId() + "&docId=" + tGNode.getDocId();
    }
}

