/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.xsp;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBDocument;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.util.TString;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttGlobalContext;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.pe.xsp.PEXSPProjectModel;
import com.triloggroup.gantt.pe.xsp.PEXSPTimeUnits;
import com.triloggroup.gantt.xsp.XSPGanttChartModel;
import com.triloggroup.gantt.xsp.XSPProjectModel;
import com.triloggroup.pe.schedule.ScheduleComputation;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.NLSBundle;
import java.util.Date;

public class PEXSPGanttChartModel
extends XSPGanttChartModel {
    private static String PROJECT_DB_NAME;
    private static final String PERCENT_THRESHOLD_DBNAME;
    private static final String PERCENT_THRESHOLD_VIEWNAME = "allprojectsdescbyid";

    public PEXSPGanttChartModel(String string, String string2) {
        super(string, string2);
    }

    protected XSPProjectModel createProjectModel(String string) {
        return new PEXSPProjectModel(this.globalContext, string);
    }

    public void init(Context context, TDBSession tDBSession, Date date, NLSBundle nLSBundle) throws TDBException, XSPException, GanttChartException {
        if (context != null) {
            String string = "sessionData.siteId='" + this.getSiteId() + "'; import pe_portlet_initialization; initializeMetaData(); setUserAttributes();";
            context.evaluateAsStringExpr(string);
        }
        super.init(context, tDBSession, date, nLSBundle);
        this.initProjectCalendar(context, tDBSession, this.getMainProjectModel());
    }

    protected ITimeUnits createTimeUnits(NLSBundle nLSBundle) {
        return PEXSPTimeUnits.get(nLSBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initProjectCalendar(Context context, TDBSession tDBSession, ProjectModel projectModel) {
        TDBDatabase tDBDatabase = null;
        try {
            tDBDatabase = tDBSession.openDatabase(PROJECT_DB_NAME);
            String string = tDBDatabase.getLookupValue(PERCENT_THRESHOLD_VIEWNAME, this.getSiteId() + "|" + projectModel.getProjectId(), "calendarid");
            TDBDocument tDBDocument = tDBDatabase.getDocumentByKey("allcalendarsdescbyid", string);
            ScheduleCalendar scheduleCalendar = new ScheduleCalendar(tDBDocument.getJDOM());
            projectModel.getProjectContext().setProjectCalendar(scheduleCalendar);
        }
        catch (Exception exception) {
            projectModel.getProjectContext().setProjectCalendar(null);
            exception.printStackTrace();
        }
        finally {
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
        }
    }

    protected void initNodeContext(TDBSession tDBSession, Date date, NLSBundle nLSBundle) throws TDBException, GanttChartException {
        GanttGlobalContext ganttGlobalContext;
        ITimeUnits iTimeUnits;
        double d = 0.1;
        double d2 = 0.2;
        String string = tDBSession.getLookupValue(PERCENT_THRESHOLD_DBNAME, PERCENT_THRESHOLD_VIEWNAME, this.getSiteId() + '|' + this.getMainProjectModel().getProjectId(), "warningthreshold|criticalthreshold");
        String[] stringArray = TString.splitString((String)string, (char)'|');
        if (stringArray.length == 2) {
            try {
                d = Double.valueOf(stringArray[0]) / 100.0;
                d2 = Double.valueOf(stringArray[1]) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        ITimeUnits iTimeUnits2 = iTimeUnits = (ganttGlobalContext = this.getGlobalContext()) != null && ganttGlobalContext.getTimeUnits() != null ? ganttGlobalContext.getTimeUnits() : this.createTimeUnits(nLSBundle);
        if (nLSBundle == null && ganttGlobalContext != null) {
            nLSBundle = ganttGlobalContext.getNLSBundle();
        }
        ((GanttGlobalContext)this.globalContext).init(date, nLSBundle, iTimeUnits, ganttGlobalContext);
        if (d <= 0.0) {
            d = 0.1;
        }
        if (d2 <= 0.0) {
            d2 = 0.2;
        }
        this.getMainProjectModel().getProjectContext().init(d, d2);
        try {
            if (ScheduleComputation.isTimePrecision((TDBSession)tDBSession, (String)this.getSiteId())) {
                this.globalContext.setTimePrecision(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String getViewSubQuery(Context context, String string) throws XSPException {
        String string2 = (String)this.viewSubQueryByProjectId.get(string);
        if (string2 == null) {
            if (context != null) {
                String string3 = "import pe_document_security; return getViewSubquery('local', 'pe_sc', '" + string + "', false, '" + this.getSiteId() + "');";
                string2 = context.evaluateAsStringExpr(string3);
                string2 = TString.fromJavaString((String)string2);
            }
            if (TString.isEmpty((String)string2)) {
                string2 = "projectid = '" + string + "' AND siteid = '" + this.getSiteId() + "'";
            }
            this.viewSubQueryByProjectId.put(string, string2);
        }
        return string2;
    }

    static {
        PERCENT_THRESHOLD_DBNAME = PROJECT_DB_NAME = "tg_pe_project";
    }
}

