/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation.xsp;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.allocation.AllocationNodeSetModel;
import com.triloggroup.gantt.allocation.loading.AllocationData;
import com.triloggroup.gantt.allocation.loading.ProjectRef;
import com.triloggroup.gantt.allocation.xsp.PEXSPAllocationChartModel;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.gantt.xsp.XSPProjectDataLoader;
import com.triloggroup.pe.util.ProjectUtil;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class PEXSPAllocationsLoader {
    private TDBSession session;
    private Context xspContext;
    private NLSBundle nls;
    private AllocationNodeSetModel nodeSetModel;
    private AllocationData allocData;
    private TDBDatabase prjDatabase;

    PEXSPAllocationsLoader(Context context, TDBSession tDBSession, NLSBundle nLSBundle) {
        this.xspContext = context;
        this.session = tDBSession;
        this.nls = nLSBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AllocationData loadDataFromDataBase(AllocationNodeSetModel allocationNodeSetModel) throws TDBException, XSPException, GanttChartException {
        this.nodeSetModel = allocationNodeSetModel;
        this.allocData = new AllocationData();
        this.prjDatabase = this.session.openDatabase("tg_pe_project");
        try {
            Object object32;
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = allocationNodeSetModel.getResourceDns();
            if (!allocationNodeSetModel.isSingleProject()) {
                stringArray = allocationNodeSetModel.getProjectIds();
                object32 = stringArray != null && stringArray.length > 0 ? this.getProjects(stringArray) : this.getProjectsReadableByUser(PEXSPAllocationChartModel.DEFAULT_PRJ_STATUS);
                Arrays.sort((Object[])object32);
                if (stringArray == null || stringArray.length != ((Object[])object32).length) {
                    stringArray = new String[((Object[])object32).length];
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((ProjectRef)object32[i]).projectId;
                }
                allocationNodeSetModel.setProjectIds(stringArray);
            }
            if (stringArray2 == null) {
                this.getDataFromDataBaseForProjects();
                stringArray = this.allocData;
                return stringArray;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                object32 = this.getProjectElementsForResource(stringArray2[i], null);
                if (object32 == null) continue;
                for (Object object2 : object32) {
                    hashMap.put(((ProjectRef)object2).projectId, ((ProjectRef)object2).name);
                    this.allocData.addResourceToProject(stringArray2[i], ((ProjectRef)object2).projectId);
                }
            }
            for (Object object32 : hashMap.keySet()) {
                ProjectData projectData = this.createProjectDataFromDatabase((String)object32);
                projectData.name = (String)hashMap.get(object32);
                this.allocData.projectsById.put(projectData.projectId, projectData);
            }
            Object object4 = new HashSet<ProjectData>(this.allocData.projectsById.values());
            while (object4 != null && !((HashSet)object4).isEmpty()) {
                object32 = null;
                Iterator iterator = ((HashSet)object4).iterator();
                while (iterator.hasNext()) {
                    ProjectData projectData = (ProjectData)iterator.next();
                    for (NodeData nodeData : projectData.nodes) {
                        if (nodeData.subProject == null) continue;
                        String string = nodeData.subProject.getId();
                        this.allocData.addSubproject(projectData.projectId, string);
                        ProjectData projectData2 = this.allocData.projectsById.get(string);
                        if (projectData2 != null) continue;
                        projectData2 = this.createProjectDataFromDatabase(string);
                        projectData2.name = nodeData.subProject.getName();
                        if (object32 == null) {
                            object32 = new HashSet();
                        }
                        ((HashSet)object32).add(projectData2);
                        this.allocData.projectsById.put(string, projectData2);
                    }
                }
                object4 = object32;
            }
            object32 = this.allocData;
            return object32;
        }
        finally {
            this.prjDatabase.close();
            this.prjDatabase = null;
            this.allocData = null;
            allocationNodeSetModel = null;
        }
    }

    private ProjectData createProjectDataFromDatabase(String string) throws TDBException, XSPException, GanttChartException {
        String string2 = this.getViewSubQuery(string);
        XSPProjectDataLoader xSPProjectDataLoader = new XSPProjectDataLoader(this.session, this.getSiteId());
        xSPProjectDataLoader.setForAllocations(true);
        return xSPProjectDataLoader.loadAllNodes(string, string2, this.nls);
    }

    private ProjectRef[] getProjectElementsForResource(String string, String[] stringArray) throws TDBException {
        String[] stringArray2 = this.prjDatabase.getLookupValues("allenabledprojectusersbysiteidanddn", this.getSiteId() + "|" + string, "projectid|projectname");
        if (stringArray2 == null) {
            return null;
        }
        if (stringArray == null) {
            ProjectRef[] projectRefArray = new ProjectRef[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = UString.splitString((String)stringArray2[i], (char)'|');
                projectRefArray[i] = new ProjectRef(this.getSiteId(), stringArray3[0], stringArray3[1]);
            }
            return projectRefArray;
        }
        ArrayList<ProjectRef> arrayList = new ArrayList<ProjectRef>();
        block1: for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray4 = UString.splitString((String)stringArray2[i], (char)'|');
            String string2 = this.prjDatabase.getLookupValue("allprojects", this.getSiteId() + "|" + stringArray4[1] + "|" + stringArray4[0], "status");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!UString.equals((String)string2, (String)stringArray[j])) continue;
                ProjectRef projectRef = new ProjectRef(this.getSiteId(), stringArray4[0], stringArray4[1]);
                arrayList.add(projectRef);
                continue block1;
            }
        }
        ProjectRef[] projectRefArray = arrayList.toArray(new ProjectRef[arrayList.size()]);
        return projectRefArray;
    }

    private void getDataFromDataBaseForProjects() throws TDBException, XSPException, GanttChartException {
        Object object;
        String[] stringArray = this.nodeSetModel.getProjectIds();
        if (stringArray == null) {
            stringArray = new String[]{this.nodeSetModel.getSingleProjectId()};
        }
        for (String object2 : stringArray) {
            object = this.createProjectDataFromDatabase(object2);
            ((ProjectData)object).name = ProjectUtil.getProjectName((TDBSession)this.session, (String)this.getSiteId(), (String)object2);
            this.allocData.projectsById.put(((ProjectData)object).projectId, (ProjectData)object);
            ((ProjectData)object).canEdit = this.currentUserCanEditProject(((ProjectData)object).projectId);
        }
        Object object3 = new HashSet<ProjectData>(this.allocData.projectsById.values());
        while (object3 != null && !((HashSet)object3).isEmpty()) {
            HashSet<ProjectData> hashSet = null;
            Iterator iterator = ((HashSet)object3).iterator();
            while (iterator.hasNext()) {
                String[] stringArray2;
                ProjectData projectData = (ProjectData)iterator.next();
                object = new HashSet();
                if (projectData.canEdit) {
                    for (String string : stringArray2 = this.prjDatabase.getLookupValues("allusersbysiteidprojectidanddn", this.getSiteId() + "|" + projectData.projectId, "userdn")) {
                        ((HashSet)object).add(string);
                    }
                } else if (this.xspContext != null) {
                    ((HashSet)object).add(this.xspContext.getUser().getDistinguishedName());
                }
                stringArray2 = projectData.nodes.iterator();
                while (stringArray2.hasNext()) {
                    String[] stringArray3 = stringArray2.next();
                    if (stringArray3.subProject == null) continue;
                    String string = stringArray3.subProject.getId();
                    this.allocData.addSubproject(projectData.projectId, string);
                    ProjectData projectData2 = this.allocData.projectsById.get(string);
                    if (projectData2 != null) continue;
                    projectData2 = this.createProjectDataFromDatabase(string);
                    projectData2.name = stringArray3.subProject.getName();
                    projectData2.canEdit = this.currentUserCanEditProject(projectData2.projectId);
                    if (hashSet == null) {
                        hashSet = new HashSet<ProjectData>();
                    }
                    hashSet.add(projectData2);
                    this.allocData.projectsById.put(string, projectData2);
                }
                this.allocData.setProjectResources((HashSet<String>)object, projectData.projectId);
            }
            object3 = hashSet;
        }
    }

    private boolean currentUserCanEditProject(String string) {
        if (this.xspContext != null) {
            String string2 = "import pe_security; return hasEditAccessForSchedule('" + TString.toJavaString((String)this.xspContext.getUser().getDistinguishedName(), (boolean)false) + "', '" + string + "', '" + this.getSiteId() + "');";
            try {
                return this.xspContext.evaluateAsBooleanExpr(string2, false);
            }
            catch (XSPException xSPException) {
                TDiag.exception((Throwable)xSPException, (String)("Cannot check if current user can edit project " + string));
                return false;
            }
        }
        return true;
    }

    private ProjectRef[] getProjects(String[] stringArray) throws TDBException {
        ProjectRef[] projectRefArray = new ProjectRef[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = ProjectUtil.getProjectName((TDBSession)this.session, (String)this.getSiteId(), (String)stringArray[i]);
            projectRefArray[i] = new ProjectRef(this.getSiteId(), stringArray[i], string);
        }
        return projectRefArray;
    }

    private ProjectRef[] getProjectsReadableByUser(String[] stringArray) throws TDBException {
        ProjectRef[] projectRefArray;
        Object object;
        boolean bl = false;
        if (this.xspContext != null) {
            try {
                object = "import pe_administration_util; return canReadAllProjectsOnSite('" + this.getSiteId() + "');";
                bl = this.xspContext.evaluateAsBooleanExpr((String)object, false);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)"Error during evaluation of script canReadAllProjectsOnSite");
            }
        }
        object = null;
        if (bl || this.xspContext == null) {
            object = this.prjDatabase.getLookupValues("allprojectsdescbyid", this.getSiteId(), "id|name");
        } else {
            projectRefArray = this.xspContext.getUser().getDistinguishedName();
            object = this.prjDatabase.getLookupValues("allenabledprojectusersbysiteidanddn", this.getSiteId() + "|" + (String)projectRefArray, "projectid|projectname");
        }
        if (object != null) {
            if (stringArray == null) {
                projectRefArray = new ProjectRef[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String[] stringArray2 = UString.splitString((String)object[i], (char)'|');
                    projectRefArray[i] = new ProjectRef(this.getSiteId(), stringArray2[0], stringArray2[1]);
                }
                return projectRefArray;
            }
            projectRefArray = new ArrayList();
            block3: for (int i = 0; i < ((String[])object).length; ++i) {
                String[] stringArray3 = UString.splitString((String)object[i], (char)'|');
                String string = this.prjDatabase.getLookupValue("allprojects", this.getSiteId() + "|" + stringArray3[1] + "|" + stringArray3[0], "status");
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!UString.equals((String)string, (String)stringArray[j])) continue;
                    ProjectRef projectRef = new ProjectRef(this.getSiteId(), stringArray3[0], stringArray3[1]);
                    projectRefArray.add(projectRef);
                    continue block3;
                }
            }
            ProjectRef[] projectRefArray2 = new ProjectRef[projectRefArray.size()];
            projectRefArray2 = projectRefArray.toArray(projectRefArray2);
            return projectRefArray2;
        }
        return null;
    }

    private String getSiteId() {
        return this.nodeSetModel.getSiteId();
    }

    private String getViewSubQuery(String string) throws XSPException {
        String string2 = null;
        if (this.xspContext != null) {
            String string3 = "import pe_document_security; return getViewSubquery('local', 'pe_sc', '" + string + "', false, '" + this.getSiteId() + "');";
            string2 = this.xspContext.evaluateAsStringExpr(string3);
            string2 = TString.fromJavaString((String)string2);
        }
        if (TString.isEmpty(string2)) {
            string2 = "projectid = '" + string + "' AND siteid = '" + this.getSiteId() + "'";
        }
        string2 = "(schema=='pe_task' OR subprojectid<>'') AND " + string2;
        return string2;
    }
}

