/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.NodeFilter;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ProjectAllocationsNode;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.util.UString;

public class AllocationNodeFilter
extends NodeFilter {
    public boolean accept(TGNode tGNode) {
        if (super.accept(tGNode)) {
            IAllocationGlobalContext iAllocationGlobalContext = (IAllocationGlobalContext)tGNode.getGlobalContext();
            if (tGNode instanceof GanttTask) {
                if (iAllocationGlobalContext.getDisplayMode() == 1 || iAllocationGlobalContext.getDisplayMode() == 3) {
                    return false;
                }
                GanttTask ganttTask = (GanttTask)tGNode;
                for (TGNode tGNode2 = tGNode.getParent(); tGNode2 != null; tGNode2 = tGNode2.getParent()) {
                    if (!(tGNode2 instanceof ResourceAllocationsNode)) continue;
                    if (this.acceptResourceFilter(((ResourceAllocationsNode)tGNode2).getResource().getDn())) {
                        return this.isResourceAllocatedTo(ganttTask, ((ResourceAllocationsNode)tGNode2).getResource());
                    }
                    return false;
                }
                return false;
            }
            if (tGNode instanceof ProjectAllocationsNode) {
                if (iAllocationGlobalContext.getDisplayMode() == 1) {
                    return false;
                }
                TGNode tGNode3 = tGNode.getParent();
                if (tGNode3 instanceof ResourceAllocationsNode) {
                    return this.acceptResourceFilter(((ResourceAllocationsNode)tGNode3).getResource().getDn());
                }
                return true;
            }
            if (tGNode instanceof ResourceAllocationsNode) {
                if (((ResourceAllocationsNode)tGNode).isUnassignedTasksNode()) {
                    if (this.filterOnResources) {
                        return false;
                    }
                    return this.hasUnassignedTask(tGNode);
                }
                return this.acceptResourceFilter(((ResourceAllocationsNode)tGNode).getResource().getDn());
            }
            return true;
        }
        return false;
    }

    private boolean hasUnassignedTask(TGNode tGNode) {
        for (int i = 0; i < tGNode.getAllSubTaskCount(); ++i) {
            GanttTask ganttTask;
            TaskResource[] taskResourceArray;
            TGNode tGNode2 = tGNode.getSubtaskInAll(i);
            if (!(tGNode2 instanceof GanttTask ? (taskResourceArray = (ganttTask = (GanttTask)tGNode.getSubtaskInAll(i)).getResources()) == null || taskResourceArray.length == 0 : this.hasUnassignedTask(tGNode2))) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptResourceFilter(String string) {
        if (this.filterOnResources) {
            for (int i = 0; i < this.resourcesFilter.length; ++i) {
                if (!UString.equals((String)string, (String)this.resourcesFilter[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isResourceAllocatedTo(GanttTask ganttTask, Resource resource) {
        TaskResource[] taskResourceArray = ganttTask.getResources();
        if (taskResourceArray != null && taskResourceArray.length > 0) {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                if (!taskResourceArray[i].getResource().equals(resource)) continue;
                return true;
            }
        } else {
            return resource.getDn() == "UnassignedTasksRes";
        }
        return false;
    }

    public boolean acceptAll() {
        return false;
    }
}

