/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.util.UString;

public class NodeFilter
implements INodeFilter {
    protected boolean filterOnStatus;
    protected String statusFilter;
    protected boolean filterOnName;
    protected boolean filterNameStart;
    protected boolean filterNameEnd;
    protected boolean filterNameContain;
    protected String nameFilter;
    protected boolean filterOnResources;
    protected String[] resourcesFilter;
    protected boolean applyByDefault;

    public NodeFilter() {
    }

    public NodeFilter(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public NodeFilter(boolean bl, String string, boolean bl2, String string2, String string3, boolean bl3, String string4, boolean bl4) {
        this.init(bl, string, bl2, string2, string3, bl3, string4, bl4);
    }

    public void setFilterValues(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public void setFilterValues(boolean bl, String string, boolean bl2, String string2, String string3, boolean bl3, String string4, boolean bl4) {
        this.init(bl, string, bl2, string2, string3, bl3, string4, bl4);
    }

    protected void init(String string, String string2, String string3, String string4) {
        if (!UString.isEmpty((String)string)) {
            this.statusFilter = string;
            this.filterOnStatus = true;
        } else {
            this.filterOnStatus = false;
        }
        int n = UString.isEmpty((String)string2) ? 46 : (int)string2.charAt(0);
        this.filterNameStart = n == 83;
        this.filterNameEnd = n == 69;
        this.filterNameContain = n == 67;
        this.filterOnName = (this.filterNameStart || this.filterNameEnd || this.filterNameContain) && !UString.isEmpty((String)string3);
        this.nameFilter = this.filterOnName ? string3 : null;
        this.filterOnResources = !UString.isEmpty((String)string4);
        this.resourcesFilter = this.filterOnResources ? UString.splitString((String)string4, (char)'|') : null;
    }

    protected void init(boolean bl, String string, boolean bl2, String string2, String string3, boolean bl3, String string4, boolean bl4) {
        this.filterOnStatus = bl;
        this.filterOnName = bl2;
        this.filterOnResources = bl3;
        this.applyByDefault = bl4;
        this.statusFilter = string;
        int n = UString.isEmpty((String)string2) ? 46 : (int)string2.charAt(0);
        this.filterNameStart = n == 83;
        this.filterNameEnd = n == 69;
        this.filterNameContain = n == 67;
        this.nameFilter = string3;
        this.resourcesFilter = !UString.isEmpty((String)string4) ? UString.splitString((String)string4, (char)'|') : null;
    }

    public boolean accept(TGNode tGNode) {
        if (tGNode instanceof GanttTask) {
            char c;
            GanttTask ganttTask = (GanttTask)tGNode;
            if (this.filterOnStatus && this.statusFilter.indexOf(c = ganttTask.getStatus().charAt(0)) < 0) {
                return false;
            }
            if (this.filterOnName) {
                String string = ganttTask.getName().toUpperCase();
                this.nameFilter = this.nameFilter.toUpperCase();
                if (this.filterNameStart && !string.startsWith(this.nameFilter)) {
                    return false;
                }
                if (this.filterNameEnd && !string.endsWith(this.nameFilter)) {
                    return false;
                }
                if (this.filterNameContain && string.indexOf(this.nameFilter) < 0) {
                    return false;
                }
            }
            if (this.filterOnResources) {
                TaskResource[] taskResourceArray = ganttTask.getResources();
                boolean bl = false;
                if (taskResourceArray != null) {
                    block0: for (int i = 0; i < taskResourceArray.length; ++i) {
                        for (int j = 0; j < this.resourcesFilter.length; ++j) {
                            if (!UString.equals((String)taskResourceArray[i].getDn(), (String)this.resourcesFilter[j])) continue;
                            bl = true;
                            break block0;
                        }
                    }
                }
                if (!bl) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean acceptAll() {
        return !this.filterOnStatus && !this.filterOnName && !this.filterOnResources;
    }

    public boolean isHideEmptyWBS() {
        return false;
    }

    public boolean isFilterOnStatus() {
        return this.filterOnStatus;
    }

    public String getStatusFilter() {
        return this.statusFilter;
    }

    public boolean isFilterOnTaskName() {
        return this.filterOnName;
    }

    public String getTaskNameFilter() {
        if (this.filterNameStart) {
            return "S";
        }
        if (this.filterNameEnd) {
            return "E";
        }
        if (this.filterNameContain) {
            return "C";
        }
        return ".";
    }

    public String getTaskNameTxt() {
        return this.nameFilter;
    }

    public boolean isFilterOnResources() {
        return this.filterOnResources;
    }

    public String getResourcesDN() {
        if (this.resourcesFilter == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.resourcesFilter.length; ++i) {
            if (i > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(this.resourcesFilter[i]);
        }
        return stringBuilder.toString();
    }

    public boolean isApplyByDefault() {
        return this.applyByDefault;
    }
}

