/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttCategoryPlot;
import com.triloggroup.gantt.GanttChartHeader;
import com.triloggroup.gantt.IDateMover;
import com.triloggroup.project.components.ui.UIConstants;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttDateAxis
extends DateAxis {
    private static final double DISPLAY_MARGIN_COEF = 0.05;
    protected Locale locale;
    private long cachedStartTime;
    private long cachedEndTime;
    private double cachedWidth;
    private List<Tick> cachedTicks;
    protected GanttChartHeader separateAxis;

    public GanttDateAxis() {
        this(null, null);
    }

    public GanttDateAxis(Locale locale, TimeZone timeZone) {
        super(null, timeZone == null ? TimeZone.getDefault() : timeZone);
        this.locale = locale != null ? locale : Locale.getDefault();
        this.setTickLabelInsets(new RectangleInsets(0.0, 2.0, 0.0, 2.0));
        this.setLowerMargin(0.05);
        this.setUpperMargin(0.05);
        this.setStandardTickUnits(this.createGanttDateTickUnits());
        this.setAutoTickUnitSelection(false, false);
    }

    public GanttChartHeader createSeparateAxisComponent(IDateMover iDateMover) {
        this.separateAxis = new GanttChartHeader(this, iDateMover);
        return this.separateAxis;
    }

    public GanttChartHeader getHeader() {
        return this.separateAxis;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (this.separateAxis != null) {
            AxisState axisState = new AxisState(d);
            axisState.setTicks(this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge));
            return axisState;
        }
        return super.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
    }

    public void updateWidth(Graphics2D graphics2D, int n) {
        if ((double)n != this.cachedWidth) {
            Rectangle rectangle = new Rectangle(0, 0, n, 100);
            this.refreshTicksHorizontal(graphics2D, rectangle, RectangleEdge.TOP);
        }
    }

    protected void drawHeaderTickMarksAndLabels(Graphics2D graphics2D, int n) {
        if (this.cachedWidth > 0.0) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = new Rectangle(0, 0, (int)this.cachedWidth, 100);
            this.setTickLabelFont(UIConstants.DEFAULT_FONT);
            super.drawTickMarksAndLabels(graphics2D, (double)(n - 1), (Rectangle2D)rectangle2, (Rectangle2D)rectangle, RectangleEdge.TOP);
        }
    }

    protected TickUnitSource createGanttDateTickUnits() {
        TickUnits tickUnits = new TickUnits();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d-MMM, HH:mm", this.locale);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("d-MMM", this.locale);
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("MMM-yyyy", this.locale);
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy", this.locale);
        TimeZone timeZone = this.getTimeZone();
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat2.setTimeZone(timeZone);
        simpleDateFormat3.setTimeZone(timeZone);
        simpleDateFormat4.setTimeZone(timeZone);
        tickUnits.add((TickUnit)new GanttDateTickUnit(3, 1, simpleDateFormat));
        tickUnits.add((TickUnit)new GanttDateTickUnit(3, 2, simpleDateFormat, 1));
        tickUnits.add((TickUnit)new GanttDateTickUnit(3, 3, simpleDateFormat, 1));
        tickUnits.add((TickUnit)new GanttDateTickUnit(3, 6, simpleDateFormat));
        tickUnits.add((TickUnit)new GanttDateTickUnit(3, 12, simpleDateFormat));
        tickUnits.add((TickUnit)new DateTickUnit(2, 1, (DateFormat)simpleDateFormat2));
        tickUnits.add((TickUnit)new GanttDateTickUnit(2, 2, simpleDateFormat2, 1));
        tickUnits.add((TickUnit)new GanttDateTickUnit(2, 7, simpleDateFormat2, 1));
        tickUnits.add((TickUnit)new DateTickUnit(2, 14, (DateFormat)simpleDateFormat2));
        tickUnits.add((TickUnit)new DateTickUnit(1, 1, (DateFormat)simpleDateFormat3));
        tickUnits.add((TickUnit)new DateTickUnit(1, 2, (DateFormat)simpleDateFormat3));
        tickUnits.add((TickUnit)new DateTickUnit(1, 3, (DateFormat)simpleDateFormat3));
        tickUnits.add((TickUnit)new DateTickUnit(1, 4, (DateFormat)simpleDateFormat3));
        tickUnits.add((TickUnit)new DateTickUnit(1, 6, (DateFormat)simpleDateFormat3));
        tickUnits.add((TickUnit)new DateTickUnit(0, 1, (DateFormat)simpleDateFormat4));
        tickUnits.add((TickUnit)new DateTickUnit(0, 2, (DateFormat)simpleDateFormat4));
        tickUnits.add((TickUnit)new DateTickUnit(0, 5, (DateFormat)simpleDateFormat4));
        tickUnits.add((TickUnit)new DateTickUnit(0, 10, (DateFormat)simpleDateFormat4));
        tickUnits.add((TickUnit)new DateTickUnit(0, 25, (DateFormat)simpleDateFormat4));
        return tickUnits;
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        if (dateTickUnit.getUnit() == 2 && dateTickUnit.getCount() % 7 == 0) {
            Calendar calendar = Calendar.getInstance(this.getTimeZone());
            calendar.setTime(date);
            calendar.set(7, 2);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date date2 = calendar.getTime();
            if (date2.getTime() >= date.getTime()) {
                calendar.add(5, -7);
                date2 = calendar.getTime();
            }
            return date2;
        }
        return super.previousStandardDate(date, dateTickUnit);
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit dateTickUnit) {
        if (dateTickUnit instanceof GanttDateTickUnit && ((GanttDateTickUnit)dateTickUnit).minorTickCount > 0) {
            return this.previousStandardDate(this.getMinimumDate(), dateTickUnit);
        }
        return this.nextStandardDate(this.getMinimumDate(), dateTickUnit);
    }

    int getCachedWidth() {
        return (int)this.cachedWidth;
    }

    protected List<Tick> refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        GanttDateTickUnit ganttDateTickUnit;
        long l = this.getMinimumDate().getTime();
        long l2 = this.getMaximumDate().getTime();
        double d = rectangle2D.getWidth();
        if (this.cachedTicks != null && l == this.cachedStartTime && l2 == this.cachedEndTime && d == this.cachedWidth) {
            return this.cachedTicks;
        }
        this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        ArrayList<Tick> arrayList = null;
        if (this.getTickUnit() instanceof GanttDateTickUnit && (ganttDateTickUnit = (GanttDateTickUnit)this.getTickUnit()).minorTickCount > 0) {
            arrayList = new ArrayList<Tick>();
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            Date date = this.calculateLowestVisibleTickValue(ganttDateTickUnit);
            Date date2 = this.getMaximumDate();
            Date date3 = this.getMinimumDate();
            int n = ganttDateTickUnit.getCount() / ganttDateTickUnit.minorTickCount;
            int n2 = 0;
            while (date.before(date2)) {
                if (!this.isHiddenValue(date.getTime())) {
                    Object object;
                    if (n2 == 0) {
                        ++n2;
                        if (!date.before(date3)) {
                            DateFormat dateFormat = this.getDateFormatOverride();
                            object = dateFormat != null ? dateFormat.format(date) : ganttDateTickUnit.dateToString(date);
                            TextAnchor textAnchor = null;
                            TextAnchor textAnchor2 = null;
                            double d2 = 0.0;
                            if (this.isVerticalTickLabels()) {
                                textAnchor = TextAnchor.CENTER_RIGHT;
                                textAnchor2 = TextAnchor.CENTER_RIGHT;
                                d2 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                            } else if (rectangleEdge == RectangleEdge.TOP) {
                                textAnchor = TextAnchor.BOTTOM_CENTER;
                                textAnchor2 = TextAnchor.BOTTOM_CENTER;
                            } else {
                                textAnchor = TextAnchor.TOP_CENTER;
                                textAnchor2 = TextAnchor.TOP_CENTER;
                            }
                            DateTick dateTick = new DateTick(date, (String)object, textAnchor, textAnchor2, d2);
                            arrayList.add((Tick)dateTick);
                        }
                    } else {
                        if (++n2 == n) {
                            n2 = 0;
                        }
                        if (!date.before(date3)) {
                            object = new MinorDateTick(date);
                            arrayList.add((Tick)object);
                        }
                    }
                    date = ganttDateTickUnit.rollDate(date, this.getTimeZone());
                    continue;
                }
                date = ganttDateTickUnit.rollDate(date, this.getTimeZone());
            }
        }
        if (arrayList == null) {
            arrayList = super.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        }
        boolean bl = this.cachedWidth != d;
        this.cachedStartTime = l;
        this.cachedEndTime = l2;
        this.cachedWidth = d;
        this.cachedTicks = arrayList;
        if (this.separateAxis != null && !((GanttCategoryPlot)this.getPlot()).isPrinting()) {
            if (bl) {
                this.separateAxis.revalidate();
            }
            this.separateAxis.repaint();
        }
        return arrayList;
    }

    private static class MinorDateTick
    extends DateTick {
        public MinorDateTick(Date date) {
            super(date, null, TextAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 0.0);
        }

        public TickType getTickType() {
            return TickType.MINOR;
        }
    }

    private static class GanttDateTickUnit
    extends DateTickUnit {
        private int minorTickCount;

        public GanttDateTickUnit(int n, int n2, DateFormat dateFormat) {
            super(n, n2, n, n2, dateFormat);
        }

        public GanttDateTickUnit(int n, int n2, DateFormat dateFormat, int n3) {
            super(n, n2, n, n3 > 0 ? n3 : n2, dateFormat);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= n2 || n2 % n3 != 0) {
                throw new IllegalArgumentException("Invalid minorTicksCount: " + n3 + " (count=" + n2 + ')');
            }
            this.minorTickCount = n3;
        }

        public int getMinorTickCount() {
            return this.minorTickCount;
        }

        public Date addToDate(Date date, TimeZone timeZone) {
            if (this.getUnit() == 3 && timeZone.useDaylightTime() && 24 % this.getCount() == 0) {
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTime(date);
                int n = calendar.get(11);
                calendar.set(11, n + this.getCount());
                return calendar.getTime();
            }
            return super.addToDate(date, timeZone);
        }
    }
}

