/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttGlobalContext;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.util.Intervals;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;

public abstract class GanttChartModel
extends TGChartModel {
    private TaskPredecessor selectedPredecessor;
    protected HashMap<String, ProjectModel> projectModels = new HashMap();
    private int headerColorIdx = 0;
    private static final Color[] HEADER_COLORS = new Color[]{new Color(250, 250, 220), new Color(245, 235, 225), new Color(230, 230, 210), new Color(230, 210, 230), new Color(210, 210, 210)};

    public GanttChartModel(String string, String string2) {
        super(string2);
        this.nodeSetModel = this.createProjectModel(string);
        this.projectModels.put(string, (ProjectModel)this.nodeSetModel);
    }

    protected GlobalContext createGlobalContext(String string) {
        return new GanttGlobalContext(string);
    }

    protected abstract ProjectModel createProjectModel(String var1);

    public GanttGlobalContext getGlobalContext() {
        return (GanttGlobalContext)this.globalContext;
    }

    public ProjectModel getMainProjectModel() {
        return (ProjectModel)this.nodeSetModel;
    }

    public ProjectModel getProjectModel(String string) {
        return this.projectModels.get(string);
    }

    public TGNode getNodeByDocId(String string) {
        for (ProjectModel projectModel : this.projectModels.values()) {
            TGNode tGNode = projectModel.getNodeByDocId(string);
            if (tGNode == null) continue;
            return tGNode;
        }
        return null;
    }

    public Intervals getOffPeriods(long l, long l2) {
        return this.getMainProjectModel().getOffPeriods(l, l2);
    }

    public synchronized void setSelectedNodes(TGNode ... tGNodeArray) {
        if (this.updatingselection) {
            return;
        }
        super.setSelectedNodes(tGNodeArray);
        this.selectedPredecessor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSelectedPredecessor(TaskPredecessor taskPredecessor) {
        if (this.updatingselection) {
            return;
        }
        try {
            Object[] objectArray;
            this.updatingselection = true;
            if (taskPredecessor == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = taskPredecessor;
            }
            Object[] objectArray3 = objectArray;
            GanttModelSelectionEvent ganttModelSelectionEvent = this.createModelSelectionEvent(2, objectArray3);
            this.selectedPredecessor = taskPredecessor;
            this.selectedNodes = null;
            this.fireSelectionChanged(ganttModelSelectionEvent);
        }
        finally {
            this.updatingselection = false;
        }
    }

    public TaskPredecessor getSelectedPredecessor() {
        return this.selectedPredecessor;
    }

    protected GanttModelSelectionEvent createModelSelectionEvent(int n, Object[] objectArray) {
        boolean bl;
        int n2 = 0;
        Object[] objectArray2 = this.getSelectedNodes();
        if (objectArray2 != null) {
            n2 = 1;
        } else {
            TaskPredecessor taskPredecessor = this.getSelectedPredecessor();
            if (taskPredecessor != null) {
                objectArray2 = new Object[]{taskPredecessor};
                n2 = 2;
            }
        }
        boolean bl2 = objectArray2 == null || objectArray2.length == 0;
        boolean bl3 = bl = objectArray == null || objectArray.length == 0;
        if (bl2 && bl) {
            return null;
        }
        if (Arrays.equals(objectArray2, objectArray)) {
            return null;
        }
        return new GanttModelSelectionEvent(this, n2, objectArray2, n, objectArray);
    }

    public void updateLineIds() {
        GanttNode ganttNode = (GanttNode)this.getRootNode();
        this.headerColorIdx = 0;
        this.updateLineIds(ganttNode, 1, null);
    }

    private int updateLineIds(GanttNode ganttNode, int n, String string) {
        ganttNode.setFullLineId(string == null ? String.valueOf(n) : string + String.valueOf(n));
        ganttNode.setLineId(n++);
        int n2 = ganttNode.getAllSubTaskCount();
        if (n2 == 1 && ((GanttWBS)ganttNode).isSubProject()) {
            GanttNode ganttNode2 = ganttNode.getSubtaskInAll(0);
            ganttNode2.getProjectContext().setHeaderColor(HEADER_COLORS[this.headerColorIdx++ % HEADER_COLORS.length]);
            this.updateLineIds(ganttNode2, 1, string);
        } else {
            for (int i = 0; i < n2; ++i) {
                GanttNode ganttNode3 = ganttNode.getSubtaskInAll(i);
                n = this.updateLineIds(ganttNode3, n, string);
            }
        }
        return n;
    }
}

