/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttDateAxis;
import com.triloggroup.gantt.IDateMover;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.project.components.ui.UIConstants;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jfree.data.time.DateRange;

public class GanttChartHeader
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int HEIGHT = TGChart.getRowHeight();
    private GanttDateAxis axis;
    private IDateMover dateMover;
    private int startDragX = -1;
    private int xTranslate;

    public GanttChartHeader(GanttDateAxis ganttDateAxis, IDateMover iDateMover) {
        this.axis = ganttDateAxis;
        this.dateMover = iDateMover;
        this.setOpaque(true);
        this.setBackground(UIConstants.BACKGROUND_HEADER_COLOR);
        if (iDateMover != null) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.axis.getCachedWidth(), HEIGHT);
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.xTranslate != 0) {
            graphics.translate(this.xTranslate, 0);
        }
        this.axis.drawHeaderTickMarksAndLabels((Graphics2D)graphics, HEIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics, int n) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, HEIGHT);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, n, HEIGHT);
        try {
            this.axis.updateWidth((Graphics2D)graphics, n);
            this.axis.drawHeaderTickMarksAndLabels((Graphics2D)graphics, HEIGHT);
        }
        finally {
            graphics.setClip(shape);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.setCursor(this.dateMover.getMoveDatesCursor());
            this.startDragX = mouseEvent.getX();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.xTranslate = 0;
            this.xTranslate = mouseEvent.getX() - this.startDragX;
            double d = this.getWidth();
            DateRange dateRange = (DateRange)this.axis.getRange();
            double d2 = dateRange.getUpperDate().getTime() - dateRange.getLowerDate().getTime();
            long l = (long)(d2 * (double)this.xTranslate / d);
            this.setCursor(Cursor.getDefaultCursor());
            this.startDragX = -1;
            this.xTranslate = 0;
            this.dateMover.moveDates(-l);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startDragX >= 0) {
            this.xTranslate = mouseEvent.getX() - this.startDragX;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

