/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.NodeSetModel;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.project.NameId;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.SubprojectOptions;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Date;
import org.jdom.Element;

public class ChartModelUtil {
    private static final long MIN_MEMORY_REQUIRED = 5000000L;

    private ChartModelUtil() {
    }

    public static void checkEnoughAvailableMemory(NLSBundle nLSBundle) throws GanttChartException {
        long l;
        long l2;
        long l3 = Runtime.getRuntime().maxMemory();
        long l4 = l3 - (l2 = Runtime.getRuntime().totalMemory()) + (l = Runtime.getRuntime().freeMemory());
        if (l4 < 5000000L) {
            System.out.println("Insufficient memory to process this request - Available memory = " + l4);
            String string = nLSBundle != null ? nLSBundle.getString("InsufficientMemory") : "Insufficient memory to process ";
            throw new GanttChartException(10, string + " " + l4 / 1000L + "kb");
        }
    }

    public static GanttNode createGanttNode(NodeSetModel nodeSetModel, Element element, ProjectContext projectContext) throws XMLException {
        Date date = new Date();
        String string = JDOMUtil.getString((Element)element, (String)"docId");
        String string2 = JDOMUtil.getString((Element)element, (String)"hId");
        String string3 = JDOMUtil.getString((Element)element, (String)"name");
        String string4 = JDOMUtil.getString((Element)element, (String)"inId");
        Date date2 = ChartModelUtil.parseDate(element.getChildText("startDa"));
        Date date3 = ChartModelUtil.parseDate(element.getChildText("endDa"));
        if (date2 == null) {
            date2 = date;
        }
        if (date3 == null) {
            date3 = date2;
        }
        if (date2.getTime() > date3.getTime()) {
            date3 = date2;
        }
        if (string4.startsWith("Task_")) {
            int n;
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            GanttTask ganttTask = new GanttTask(string, string2, string3, string4, date2, date3);
            String[] stringArray2 = JDOMUtil.getStrings((Element)element, (String)"predId");
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray = JDOMUtil.getStrings((Element)element, (String)"liT");
                object3 = JDOMUtil.getStrings((Element)element, (String)"lag");
                object2 = JDOMUtil.getStrings((Element)element, (String)"lagF");
                object = new ArrayList();
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n2 = Predecessor.predecessorTypeAsInt((String)stringArray[i]);
                    n = (int)JDOMUtil.parseLong((String)object3[i]);
                    int n3 = (int)JDOMUtil.parseLong((String)object2[i]);
                    ((ArrayList)object).add(new Predecessor(stringArray2[i], n2, n, n3));
                }
                ganttTask.setPredecessors((ArrayList<Predecessor>)object);
            }
            ganttTask.setPercentComplete(JDOMUtil.getDouble((Element)element, (String)"perc"));
            stringArray = JDOMUtil.getStrings((Element)element, (String)"resDn");
            if (stringArray.length > 0) {
                object3 = nodeSetModel.getResources(stringArray);
                object2 = new TaskResource[((Object[])object3).length];
                object = JDOMUtil.getLongs((Element)element, (String)"resU");
                double[] dArray = JDOMUtil.getDoubles((Element)element, (String)"resW");
                boolean[] blArray = JDOMUtil.getBooleans((Element)element, (String)"resWS");
                for (n = 0; n < ((Object[])object3).length; ++n) {
                    object2[n] = new TaskResource((Resource)object3[n], (int)object[n]);
                    ((TaskResource)object2[n]).setWork(dArray[n]);
                    ((TaskResource)object2[n]).setWorkSpecified(blArray[n]);
                }
                ganttTask.setResources((TaskResource[])object2);
            }
            ganttTask.setNodeContext(projectContext);
            object3 = element.getAttributeValue("canRead");
            if (!UString.isEmpty((String)object3)) {
                ganttTask.setReadeable(JDOMUtil.parseBoolean((String)object3));
            }
            object2 = element.getAttributeValue("lastMT");
            ganttTask.setLastModificationTime(JDOMUtil.parseLong((String)object2));
            ganttTask.setStatus(JDOMUtil.getString((Element)element, (String)"stat"));
            return ganttTask;
        }
        if (string4.startsWith("Wbs_")) {
            Object object;
            String string5;
            Resource[] resourceArray;
            GanttWBS ganttWBS = new GanttWBS(string, string2, string3, string4, date2, date3);
            ganttWBS.setNodeContext(projectContext);
            String[] stringArray = JDOMUtil.getStrings((Element)element, (String)"resDn");
            if (stringArray.length > 0) {
                resourceArray = nodeSetModel.getResources(stringArray);
                ganttWBS.setResources(resourceArray);
            }
            if (!UString.isEmpty((String)(resourceArray = element.getChildText("subprjid")))) {
                string5 = element.getChildText("subprjname");
                object = new NameId(string5, (String)resourceArray);
                ganttWBS.setSubProject((NameId)object);
                String string6 = element.getChildText("subprjopt");
                ganttWBS.setSubprojectOptions(new SubprojectOptions(string6));
            }
            if (!UString.isEmpty((String)(string5 = element.getAttributeValue("canRead")))) {
                ganttWBS.setReadeable(JDOMUtil.parseBoolean((String)string5));
            }
            object = element.getAttributeValue("lastMT");
            ganttWBS.setLastModificationTime(JDOMUtil.parseLong((String)object));
            return ganttWBS;
        }
        return null;
    }

    public static GanttNode createGanttNode(NodeSetModel nodeSetModel, NodeData nodeData, ProjectContext projectContext) {
        Date date = new Date();
        Date date2 = nodeData.startDate;
        Date date3 = nodeData.endDate;
        if (date2 == null) {
            date2 = date;
        }
        if (date3 == null) {
            date3 = date2;
        }
        if (date2.getTime() > date3.getTime()) {
            date3 = date2;
        }
        if (nodeData.uid.startsWith("Task_")) {
            GanttTask ganttTask = new GanttTask(nodeData.docId, nodeData.hierarchicalId, nodeData.name, nodeData.uid, date2, date3);
            ganttTask.setPredecessors(nodeData.predecessors);
            ganttTask.setPercentComplete(nodeData.percentComplete);
            if (nodeData.resourceDns != null && nodeData.resourceDns.length > 0) {
                Resource[] resourceArray = nodeSetModel.getResources(nodeData.resourceDns);
                TaskResource[] taskResourceArray = new TaskResource[resourceArray.length];
                for (int i = 0; i < resourceArray.length; ++i) {
                    taskResourceArray[i] = new TaskResource(resourceArray[i], nodeData.resourceUnits[i]);
                }
                ganttTask.setResources(taskResourceArray);
            } else {
                ganttTask.setResources(new TaskResource[0]);
            }
            ganttTask.setNodeContext(projectContext);
            ganttTask.setStatus(nodeData.status);
            return ganttTask;
        }
        if (nodeData.uid.startsWith("Wbs_")) {
            GanttWBS ganttWBS = new GanttWBS(nodeData.docId, nodeData.hierarchicalId, nodeData.name, nodeData.uid, date2, date3);
            ganttWBS.setNodeContext(projectContext);
            if (nodeData.resourceDns != null && nodeData.resourceDns.length > 0) {
                Resource[] resourceArray = nodeSetModel.getResources(nodeData.resourceDns);
                ganttWBS.setResources(resourceArray);
            } else {
                ganttWBS.setResources(new Resource[0]);
            }
            ganttWBS.setSubProject(nodeData.subProject);
            if (nodeData.subProject != null) {
                ganttWBS.setSubprojectOptions(new SubprojectOptions(nodeData.subprojectOptions));
            }
            return ganttWBS;
        }
        return null;
    }

    public static void updateGanttNode(NodeSetModel nodeSetModel, GanttNode ganttNode, Element element) throws XMLException {
        ganttNode.setDocId(JDOMUtil.getString((Element)element, (String)"docId"));
        ganttNode.setHierarchicalId(JDOMUtil.getString((Element)element, (String)"hId"));
        ganttNode.setName(JDOMUtil.getString((Element)element, (String)"name"));
        Date date = ChartModelUtil.parseDate(element.getChildText("startDa"));
        Date date2 = ChartModelUtil.parseDate(element.getChildText("endDa"));
        ganttNode.setDuration(date, date2);
        String string = element.getAttributeValue("canRead");
        if (!UString.isEmpty((String)string)) {
            ganttNode.setReadeable(JDOMUtil.parseBoolean((String)string));
        }
        String string2 = element.getAttributeValue("lastMT");
        ganttNode.setLastModificationTime(JDOMUtil.parseLong((String)string2));
        if (ganttNode instanceof GanttTask) {
            int n;
            Object object;
            Object[] objectArray;
            Object[] objectArray2;
            String[] stringArray;
            GanttTask ganttTask = (GanttTask)ganttNode;
            String[] stringArray2 = JDOMUtil.getStrings((Element)element, (String)"predId");
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray = JDOMUtil.getStrings((Element)element, (String)"liT");
                objectArray2 = JDOMUtil.getStrings((Element)element, (String)"lag");
                objectArray = JDOMUtil.getStrings((Element)element, (String)"lagF");
                object = new ArrayList<Predecessor>();
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n2 = Predecessor.predecessorTypeAsInt((String)stringArray[i]);
                    n = (int)JDOMUtil.parseLong((String)objectArray2[i]);
                    int n3 = (int)JDOMUtil.parseLong((String)objectArray[i]);
                    ((ArrayList)object).add(new Predecessor(stringArray2[i], n2, n, n3));
                }
                ganttTask.setPredecessors((ArrayList<Predecessor>)object);
            } else {
                ganttTask.setPredecessors(null);
            }
            ganttTask.setPercentComplete(JDOMUtil.getDouble((Element)element, (String)"perc"));
            stringArray = JDOMUtil.getStrings((Element)element, (String)"resDn");
            if (stringArray.length > 0) {
                objectArray2 = nodeSetModel.getResources(stringArray);
                objectArray = new TaskResource[objectArray2.length];
                object = JDOMUtil.getLongs((Element)element, (String)"resU");
                double[] dArray = JDOMUtil.getDoubles((Element)element, (String)"resW");
                boolean[] blArray = JDOMUtil.getBooleans((Element)element, (String)"resWS");
                for (n = 0; n < objectArray2.length; ++n) {
                    objectArray[n] = new TaskResource((Resource)objectArray2[n], (int)object[n]);
                    ((TaskResource)objectArray[n]).setWork(dArray[n]);
                    ((TaskResource)objectArray[n]).setWorkSpecified(blArray[n]);
                }
                ganttTask.setResources((TaskResource[])objectArray);
            } else {
                ganttTask.setResources(new TaskResource[0]);
            }
            ganttTask.setStatus(JDOMUtil.getString((Element)element, (String)"stat"));
        } else if (ganttNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            String[] stringArray = JDOMUtil.getStrings((Element)element, (String)"resDn");
            Resource[] resourceArray = nodeSetModel.getResources(stringArray);
            ganttWBS.setResources(resourceArray);
            String string3 = element.getChildText("subprjid");
            if (UString.isEmpty((String)string3)) {
                ganttWBS.setSubProject(null);
                ganttWBS.setSubprojectOptions(null);
            } else {
                String string4 = element.getChildText("subprjname");
                NameId nameId = new NameId(string4, string3);
                ganttWBS.setSubProject(nameId);
                String string5 = element.getChildText("subprjopt");
                ganttWBS.setSubprojectOptions(new SubprojectOptions(string5));
            }
        }
    }

    public static void updateGanttNode(NodeSetModel nodeSetModel, GanttNode ganttNode, NodeData nodeData) {
        ganttNode.setHierarchicalId(nodeData.hierarchicalId);
        ganttNode.setName(nodeData.name);
        Date date = nodeData.startDate;
        Date date2 = nodeData.endDate;
        ganttNode.setDuration(date, date2);
        if (ganttNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            ganttTask.setPredecessors(nodeData.predecessors);
            ganttTask.setPercentComplete(nodeData.percentComplete);
            if (nodeData.resourceDns != null && nodeData.resourceDns.length > 0) {
                Resource[] resourceArray = nodeSetModel.getResources(nodeData.resourceDns);
                TaskResource[] taskResourceArray = new TaskResource[resourceArray.length];
                for (int i = 0; i < resourceArray.length; ++i) {
                    taskResourceArray[i] = new TaskResource(resourceArray[i], nodeData.resourceUnits[i]);
                }
                ganttTask.setResources(taskResourceArray);
            } else {
                ganttTask.setResources(new TaskResource[0]);
            }
            ganttTask.setStatus(nodeData.status);
        } else if (ganttNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            if (nodeData.resourceDns != null && nodeData.resourceDns.length > 0) {
                Resource[] resourceArray = nodeSetModel.getResources(nodeData.resourceDns);
                ganttWBS.setResources(resourceArray);
            } else {
                ganttWBS.setResources(new Resource[0]);
            }
            ganttWBS.setSubProject(nodeData.subProject);
            if (nodeData.subProject != null) {
                ganttWBS.setSubprojectOptions(new SubprojectOptions(nodeData.subprojectOptions));
            } else {
                ganttWBS.setSubprojectOptions(null);
            }
        }
    }

    private static Date parseDate(String string) {
        return JDOMUtil.parseUtilDate((String)string);
    }
}

