/*
 * Decompiled with CFR 0.152.
 */
package com.projexec.extensions;

import com.darwino.commons.Plugin;
import com.projexec.extensions.Extension;
import com.projexec.extensions.ProjExecPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactory {
    protected static final String _SERVICES_LOCATION = "META-INF/services/";
    private static List<ProjExecPlugin> plugins = new ArrayList<ProjExecPlugin>();
    private static Map<Class<?>, List<Extension>> extensions;
    private static Map<Class<?>, Map<Object, Extension>> extensionsMap;

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ExtensionFactory.class.getClassLoader();
        }
        ExtensionFactory.findServiceEntries(cl, plugins, Plugin.class);
        Iterator<ProjExecPlugin> it = plugins.iterator();
        while (it.hasNext()) {
            ProjExecPlugin p = it.next();
            if (p.isEnabled()) continue;
            it.remove();
        }
        extensions = new HashMap();
        extensionsMap = new HashMap();
    }

    public static Iterator<ProjExecPlugin> findPlugins() {
        return plugins.iterator();
    }

    public static <T extends Extension> Iterator<T> findExtensions(Class<T> extensionClass) {
        List<T> o = ExtensionFactory.getExtensions(extensionClass);
        return new FilteredIterator<T>((Iterator)o.iterator()){

            @Override
            protected boolean accept(Object object) {
                return ((Extension)object).isEnabled();
            }
        };
    }

    public static <T extends Extension> List<T> findExtensionsList(Class<T> extensionClass) {
        List<T> ext = ExtensionFactory.getExtensions(extensionClass);
        ArrayList<Extension> res = new ArrayList<Extension>();
        int i = 0;
        while (i < ext.size()) {
            Extension o = (Extension)ext.get(i);
            if (o.isEnabled()) {
                res.add(o);
            }
            ++i;
        }
        return res;
    }

    public static boolean extensionExists(Class<? extends Extension> extensionClass) {
        return !ExtensionFactory.getExtensions(extensionClass).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends Extension> T findExtensionByKey(Class<T> extensionClass, Object key) {
        Extension o;
        Map<Object, Extension> map = extensionsMap.get(extensionClass);
        if (map == null) {
            Class<ExtensionFactory> clazz = ExtensionFactory.class;
            // MONITORENTER : com.projexec.extensions.ExtensionFactory.class
            map = extensionsMap.get(extensionClass);
            if (map == null) {
                List<Extension> allExt = ExtensionFactory.getExtensions(extensionClass);
                map = Collections.emptyMap();
                Iterator<Extension> iterator = allExt.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        extensionsMap.put(extensionClass, map);
                        break;
                    }
                    Extension e = iterator.next();
                    Object k = e._getKey();
                    if (k == null) continue;
                    if (map.containsKey(k)) {
                        throw new IllegalStateException("Duplicated ProjExec extension key:" + key + ", class:" + e.getClass());
                    }
                    if (map.size() == 0) {
                        map = Collections.singletonMap(k, e);
                        continue;
                    }
                    if (map.size() == 1) {
                        map = new HashMap<Object, Extension>(map);
                        map.put(k, e);
                        continue;
                    }
                    map.put(k, e);
                }
            }
            // MONITOREXIT : clazz
        }
        if ((o = map.get(key)) == null) return null;
        if (!o.isEnabled()) return null;
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends Extension> List<T> getExtensions(Class<T> extensionClass) {
        List<Extension> o = extensions.get(extensionClass);
        if (o != null) return o;
        Class<ExtensionFactory> clazz = ExtensionFactory.class;
        synchronized (ExtensionFactory.class) {
            o = extensions.get(extensionClass);
            if (o != null) return o;
            o = ExtensionFactory._createExtensions(extensionClass);
            extensions.put(extensionClass, o);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetExtensions() {
        Class<ExtensionFactory> clazz = ExtensionFactory.class;
        synchronized (ExtensionFactory.class) {
            extensions.clear();
            extensionsMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static List<Extension> _createExtensions(Class<? extends Extension> extensionClass) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ProjExecPlugin p : plugins) {
            p.findExtensions(extensionClass, list);
        }
        Collections.sort(list);
        return list;
    }

    protected static List<?> findServiceEntries(ClassLoader loader, List<?> list, Class<?> serviceClass) {
        try {
            Enumeration<URL> e = ExtensionFactory.getResourcesList(loader, serviceClass);
            if (e != null) {
                while (e.hasMoreElements()) {
                    URL res = e.nextElement();
                    BufferedReader r = new BufferedReader(ExtensionFactory.openResource(res));
                    try {
                        list = ExtensionFactory.parseResource(loader, list, r, serviceClass, res);
                    }
                    finally {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }

    protected static Enumeration<URL> getResourcesList(ClassLoader loader, Class<?> serviceClass) throws IOException {
        return loader.getResources(_SERVICES_LOCATION + serviceClass.getName());
    }

    protected static Reader openResource(Object res) throws IOException {
        return new InputStreamReader(((URL)res).openStream(), "utf-8");
    }

    protected static List<?> parseResource(ClassLoader loader, List<?> list, BufferedReader r, Class<?> serviceClass, Object desc) throws IOException {
        String s;
        while ((s = r.readLine()) != null) {
            int comment = s.indexOf(35);
            if (comment >= 0) {
                s = s.substring(0, comment);
            }
            if ((s = s.trim()).length() <= 0) continue;
            try {
                Class<?> c = loader.loadClass(s);
                Object o = c.newInstance();
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(o);
            }
            catch (Throwable ex) {
                IOException ioe = new IOException("Runtime error while parsing service file " + desc);
                ioe.initCause(ex);
                throw ioe;
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FilteredIterator<T>
    implements Iterator<T> {
        private boolean initialized;
        private Iterator<T> iterator;
        private boolean hasnext;
        private T current;

        FilteredIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        protected abstract boolean accept(Object var1);

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.next();
                this.initialized = true;
            }
            return this.hasnext;
        }

        @Override
        public T next() {
            T result = this.current;
            this.hasnext = false;
            while (!this.hasnext && this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (!this.accept(this.current)) continue;
                this.hasnext = true;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

