/*
 * Decompiled with CFR 0.152.
 */
package com.darwino.commons.util;

import com.projexec.util.ProjExecUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Serializable,
Comparable<Version> {
    public static final Version EMPTY = new Version(0, 0, 0);
    private final int major;
    private final int minor;
    private final int subversion;
    private static final char POINT = '.';
    private static final long serialVersionUID = 1L;

    public static Version parse(String s) {
        if (Version.isEmpty(s)) {
            return EMPTY;
        }
        String sMajor = "";
        String sMinor = "";
        String sSubversion = "";
        int d1 = s.indexOf(46);
        if (d1 >= 0) {
            sMajor = s.substring(0, d1);
            int d2 = s.indexOf(46, d1 + 1);
            if (d2 >= 0) {
                sMinor = s.substring(d1 + 1, d2);
                sSubversion = s.substring(d2 + 1);
            } else {
                sMinor = s.substring(d1 + 1);
            }
        } else {
            sMajor = s;
        }
        try {
            int major = Version.isEmpty(sMajor) ? 0 : Integer.parseInt(sMajor);
            int minor = Version.isEmpty(sMinor) ? 0 : Integer.parseInt(sMinor);
            int subversion = Version.isEmpty(sSubversion) ? 0 : Integer.parseInt(sSubversion);
            return new Version(major, minor, subversion);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ProjExecUtil.format("Invalid version format {0}", s), ex);
        }
    }

    public Version(int major, int minor, int subversion) {
        this.major = major;
        this.minor = minor;
        this.subversion = subversion;
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major) {
        this(major, 0, 0);
    }

    public boolean isUnknown() {
        return this.major == 0 && this.minor == 0 && this.subversion == 0;
    }

    public String toString() {
        return ProjExecUtil.format("{0}.{1}.{2}", this.getMajor(), this.getMinor(), this.getSubversion());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getSubversion() {
        return this.subversion;
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            Version v = (Version)o;
            return this == v || v.major == this.major && v.minor == this.minor && v.subversion == this.subversion;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = hash * prime + this.getMajor();
        hash = hash * prime + this.getMinor();
        hash = hash * prime + this.getSubversion();
        return hash;
    }

    @Override
    public int compareTo(Version v) {
        if (this.equals(v)) {
            return 0;
        }
        if (this.greaterThan(v)) {
            return 1;
        }
        return -1;
    }

    public boolean isAtLeast(Version version) {
        return this.isAtLeast(version.getMajor(), version.getMinor(), version.getSubversion());
    }

    public boolean isAtLeast(int _major) {
        return this.isAtLeast(_major, 0, 0);
    }

    public boolean isAtLeast(int _major, int _minor) {
        return this.isAtLeast(_major, _minor, 0);
    }

    public boolean isAtLeast(int _major, int _minor, int _subversion) {
        if (this.major < _major) {
            return true;
        }
        if (this.major == _major) {
            if (this.minor < _minor) {
                return true;
            }
            if (this.minor == _minor && this.subversion <= _subversion) {
                return true;
            }
        }
        return false;
    }

    public boolean greaterThan(Version v) {
        if (this.major > v.major) {
            return true;
        }
        if (this.major == v.major) {
            if (this.minor > v.minor) {
                return true;
            }
            if (this.minor == v.minor && this.subversion > v.subversion) {
                return true;
            }
        }
        return false;
    }

    public boolean lessThan(Version v) {
        if (this.major < v.major) {
            return true;
        }
        if (this.major == v.major) {
            if (this.minor < v.minor) {
                return true;
            }
            if (this.minor == v.minor && this.subversion < v.subversion) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

