/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.IView;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TGTable
extends JTable
implements MouseListener {
    protected IView view;
    protected static final int TOOLTIP_MAX_LINE_LENGTH = 136;
    protected static final int TOOLTIP_MAX_WORD_WRAP_CHARS = 20;
    protected boolean editCellOnlyWhenFocused = true;

    public TGTable(ITGTableModel iTGTableModel) {
        super(iTGTableModel);
        this.addMouseListener(this);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSurrendersFocusOnKeystroke(true);
    }

    public ITGTableModel getTGTableModel() {
        return (ITGTableModel)this.getModel();
    }

    public void setView(IView iView) {
        this.view = iView;
    }

    public IView getView() {
        return this.view;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.editCellOnlyWhenFocused && !this.cellHasFocus(n, n2)) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    public boolean cellHasFocus(int n, int n2) {
        return this.selectionModel.getLeadSelectionIndex() == n && this.columnModel.getSelectionModel().getLeadSelectionIndex() == n2;
    }

    public boolean stopCellEditing(boolean bl) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor == null) {
            return true;
        }
        boolean bl2 = tableCellEditor.stopCellEditing();
        if (bl && !bl2) {
            tableCellEditor.cancelCellEditing();
            return true;
        }
        return bl2;
    }

    public void cancelCellEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        String string = null;
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, n);
            Component component = this.prepareRenderer(tableCellRenderer, n2, n);
            if (component instanceof JComponent) {
                Rectangle rectangle = this.getCellRect(n2, n, false);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                int n3 = component.getWidth();
                int n4 = component.getHeight();
                int n5 = component.getX();
                int n6 = component.getY();
                try {
                    component.setSize(rectangle.width, rectangle.height);
                    component.setLocation(0, 0);
                    string = ((JComponent)component).getToolTipText(mouseEvent2);
                }
                finally {
                    component.setSize(n3, n4);
                    component.setLocation(n5, n6);
                }
            }
            if (string == null && (string = this.getToolTipText(n2, n, point, tableCellRenderer, component)) != null) {
                return string;
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return this.getToolTipString(string);
    }

    protected String getToolTipText(int n, int n2, Point point, TableCellRenderer tableCellRenderer, Component component) {
        if (component instanceof JLabel) {
            String string = ((JLabel)component).getText();
            if (string.indexOf(10) >= 0) {
                return this.getToolTipString(string);
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            if (component.getPreferredSize().width >= tableColumn.getWidth()) {
                return this.getToolTipString(string);
            }
        }
        return null;
    }

    protected String getToolTipString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.indexOf(10) < 0 && string.length() < 136 || string.startsWith("<html>")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        int n = string.length();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = this.getSwingHtmlReplaceChar(c);
            if (c == '\n') {
                n2 = 0;
            } else if (++n2 == 116) {
                n3 = this.getBestBreakLocation(string, i + 1, i + 20);
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            if (i != n3) continue;
            stringBuffer.append("<br>");
            n2 = 0;
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    protected int getBestBreakLocation(String string, int n, int n2) {
        if (string.length() <= n2) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        int n3 = -1;
        int n4 = -1;
        for (int i = n; i < n2 - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                return -1;
            }
            if (Character.isWhitespace(c)) {
                n3 = i;
                n4 = 10;
                continue;
            }
            if (n4 >= 10 || Character.isLetterOrDigit(c)) continue;
            n3 = i;
            n4 = 5;
        }
        if (n3 == -1) {
            if (string.charAt(n2) == '\n' || string.length() > n2 + 1 && string.charAt(n2 + 1) == '\n') {
                return -1;
            }
            return n2;
        }
        return n3;
    }

    private String getSwingHtmlReplaceChar(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return "<br>";
            }
            case ' ': {
                return "&nbsp;";
            }
        }
        return null;
    }

    public JPopupMenu getPopupMenuForCurrentSelection(Point point) {
        return null;
    }

    public boolean isEditCellOnlyWhenFocused() {
        return this.editCellOnlyWhenFocused;
    }

    public void setEditCellOnlyWhenFocused(boolean bl) {
        this.editCellOnlyWhenFocused = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Component component;
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        this.stopCellEditing(true);
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (!this.isRowSelected(n)) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
        if ((component = mouseEvent.getComponent()) == null) {
            component = this;
        }
        SwingUtilities.convertPointToScreen(point, component);
        JPopupMenu jPopupMenu = this.getPopupMenuForCurrentSelection(point);
        if (jPopupMenu != null) {
            jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

