/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.projects;

import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.projects.ProjectNode;
import com.triloggroup.gantt.renderer.TGNodeRenderer;
import com.triloggroup.project.components.ui.UIConstants;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;

class ProjectRenderer
extends TGNodeRenderer {
    ProjectRenderer() {
        this.setDrawBarOutline(true);
    }

    protected void drawNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2) {
        double d = this.calculateBarW0(tGCategoryPlot, tGCategoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (d + (double)GanttChart.getRowHeight() < rectangle.getMinY() || d > rectangle.getMaxY()) {
            return;
        }
        TGNode tGNode = ganttDataset.getNode(n, n2);
        if (tGCategoryPlot.isSelectedNode(tGNode)) {
            this.drawBackgroundSelection(tGNode, graphics2D, d, rectangle2D, tGCategoryPlot);
        }
        if (tGNode instanceof ProjectNode) {
            this.drawProject(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, (ProjectNode)tGNode, d);
        }
    }

    protected void drawProject(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, ProjectNode projectNode, double d) {
        double d2;
        this.checkHorizontalOrientation(categoryPlot);
        this.drawCalendarOffDays(graphics2D, projectNode.getCalendar(), rectangle2D, categoryPlot, valueAxis, d);
        double d3 = projectNode.getStartDate().getTime();
        double d4 = projectNode.getFinishDate().getTime();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d5 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d6 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        d5 = Math.round(d5);
        d6 = Math.round(d6);
        if (d6 < d5) {
            d2 = d6;
            d6 = d5;
            d5 = d2;
        }
        d2 = categoryItemRendererState.getBarWidth();
        double d7 = d6 - d5;
        if (d7 <= 0.0) {
            d7 = 1.0;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d, d7, d2);
        graphics2D.setPaint(projectNode.getColor());
        graphics2D.fill(double_);
        this.drawPercentComplete(graphics2D, projectNode, double_);
        this.drawShapeOutline(graphics2D, double_, categoryItemRendererState, n, n2);
        this.drawLabel(graphics2D, rectangle2D, categoryAxis, n, n2, projectNode, double_, true);
    }

    protected void drawLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryAxis categoryAxis, int n, int n2, ProjectNode projectNode, Rectangle2D rectangle2D2, boolean bl) {
        if (this.isSeriesItemLabelsVisible(n)) {
            Double d;
            categoryAxis.getTickLabelPaint();
            StringBuilder stringBuilder = new StringBuilder(projectNode.getName());
            if (bl && (d = projectNode.getPercentComplete()) != null && d >= 0.0) {
                double d2 = d;
                stringBuilder.append(" - ");
                stringBuilder.append((int)(d2 * 100.0));
                stringBuilder.append("%");
            }
            d = TextUtilities.createTextBlock((String)stringBuilder.toString(), (Font)UIConstants.DEFAULT_FONT, (Paint)categoryAxis.getTickLabelPaint());
            Size2D size2D = d.calculateDimensions(graphics2D);
            double d3 = rectangle2D2.getX() + rectangle2D2.getWidth() + 10.0;
            if (d3 + size2D.getWidth() > rectangle2D.getWidth() && rectangle2D2.getX() - 10.0 - size2D.getWidth() > rectangle2D.getX()) {
                d3 = rectangle2D2.getX() - 10.0 - size2D.getWidth();
            }
            d.draw(graphics2D, (float)d3, (float)rectangle2D2.getY(), TextBlockAnchor.TOP_LEFT);
        }
    }
}

