/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation.xsp;

import com.flowbuilder.docdb.TDBDatabase;
import com.flowbuilder.docdb.TDBDocument;
import com.flowbuilder.docdb.TDBDocumentCollection;
import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBServer;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.docdb.TDBView;
import com.flowbuilder.docdb.TDBViewEntry;
import com.flowbuilder.docdb.TDBViewEntryCollection;
import com.flowbuilder.lib.Application;
import com.flowbuilder.lib.I18n;
import com.flowbuilder.server.directory.DirectoryUser;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.allocation.AllocationChartModel;
import com.triloggroup.gantt.allocation.AllocationNodeSetModel;
import com.triloggroup.gantt.allocation.AllocationProjectContext;
import com.triloggroup.gantt.allocation.AllocationsNode;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ProjectAllocationsNode;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.gantt.allocation.loading.AllocationData;
import com.triloggroup.gantt.allocation.loading.ProjectRef;
import com.triloggroup.gantt.allocation.xsp.PEXSPAllocationNodeSetModel;
import com.triloggroup.gantt.allocation.xsp.PEXSPAllocationsLoader;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.gantt.xsp.XSPProjectDataLoader;
import com.triloggroup.lwpbeans.util.db.DBUtil;
import com.triloggroup.pe.schedule.ScheduleComputation;
import com.triloggroup.pe.util.SubprojectUtil;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEXSPAllocationChartModel
extends AllocationChartModel {
    private static final String PERCENT_THRESHOLD_DBNAME = "tg_pe_project";
    private static final String PERCENT_THRESHOLD_VIEWNAME = "allprojectsdescbyid";
    static final String[] DEFAULT_PRJ_STATUS = new String[]{"Pending", "In Progress"};
    static final String PROJECT_DB_NAME = "tg_pe_project";
    static final String PRJ_USERS_VIEW_NAME = "allenabledprojectusersbysiteidanddn";
    private static boolean CROSS_SITE_ALLOCATIONS = true;

    public PEXSPAllocationChartModel(String[] stringArray, String[] stringArray2, String string) {
        super(stringArray, stringArray2, string);
    }

    public PEXSPAllocationChartModel(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    public PEXSPAllocationChartModel(String[] stringArray, String string) {
        super(stringArray, string);
    }

    @Override
    protected AllocationNodeSetModel createNodeSetModel(String[] stringArray, String[] stringArray2) {
        return new PEXSPAllocationNodeSetModel(this.globalContext, stringArray, stringArray2);
    }

    @Override
    protected AllocationNodeSetModel createNodeSetModel(String string) {
        return new PEXSPAllocationNodeSetModel(this.globalContext, string);
    }

    public void init(Context context, TDBSession tDBSession, java.util.Date date, NLSBundle nLSBundle) throws TDBException, XSPException, GanttChartException {
        Object object;
        if (context != null) {
            object = "sessionData.siteId='" + this.getSiteId() + "'; import pe_portlet_initialization; initializeMetaData(); setUserAttributes();";
            context.evaluateAsStringExpr((String)object);
        }
        this.initGlobalContext(tDBSession, date, nLSBundle);
        object = new PEXSPAllocationsLoader(context, tDBSession, nLSBundle);
        AllocationData allocationData = ((PEXSPAllocationsLoader)object).loadDataFromDataBase(this.getNodeSetModel());
        this.initProjectContext(context, tDBSession, allocationData.projectsById.values());
        this.initData(allocationData);
        if (!this.getGlobalContext().isGanttResource() && this.getGlobalContext().getDisplayMode() != 0) {
            this.initAllProjectsAllocations(tDBSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAllFromDatabase(Context context, NLSBundle nLSBundle) throws TDBException, XSPException, GanttChartException {
        INodeFilter iNodeFilter = this.getFilter();
        if (context != null) {
            this.init(context, context.getDBSession(), this.globalContext.getCurrentDate(), nLSBundle);
        } else {
            TDBServer tDBServer = null;
            TDBSession tDBSession = null;
            try {
                tDBServer = Application.getDBServer(null);
                DirectoryUser directoryUser = new DirectoryUser("pcollins", "floflo");
                tDBSession = tDBServer.createSession(directoryUser);
                this.init(context, tDBSession, this.globalContext.getCurrentDate(), nLSBundle);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)"Could not rebuild all the graph with data from dtabase");
            }
            finally {
                if (tDBServer != null) {
                    if (tDBSession != null) {
                        tDBSession.close();
                    }
                    tDBServer.close();
                }
            }
        }
        this.setFilter(iNodeFilter);
        this.fireStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMode(int n, Context context) throws TDBException, XSPException {
        if (this.getGlobalContext().isGanttResource()) {
            return;
        }
        this.setDisplayMode(n);
        if (n != 0 && this.getRootNode().hasVisibleSubtask() && ((ResourceAllocationsNode)this.getRootNode().getVisibleSubtask(0)).getIntervals() == null) {
            if (context != null) {
                this.initAllProjectsAllocations(context.getDBSession());
            } else {
                TDBServer tDBServer = null;
                TDBSession tDBSession = null;
                try {
                    tDBServer = Application.getDBServer(null);
                    DirectoryUser directoryUser = new DirectoryUser("pcollins", "floflo");
                    tDBSession = tDBServer.createSession(directoryUser);
                    this.initAllProjectsAllocations(tDBSession);
                }
                catch (Exception exception) {
                    TDiag.exception((Throwable)exception, (String)"Could not rebuild all the graph with data from dtabase");
                }
                finally {
                    if (tDBSession != null) {
                        tDBSession.close();
                    }
                    if (tDBServer != null) {
                        tDBServer.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TGNode> refreshNodeFromDatabase(Context context, String string, NLSBundle nLSBundle) throws Exception {
        if (context == null) {
            throw new Exception("Cannot update Gantt node with null context");
        }
        ArrayList<TGNode> arrayList = this.getNodeSetModel().getNodesByDocIdInAll(string);
        if (arrayList.isEmpty()) {
            return null;
        }
        String string2 = ((GanttNode)arrayList.get(0)).getProjectId();
        TDBSession tDBSession = context.getDBSession();
        TDBDatabase tDBDatabase = tDBSession.openDatabase("tg_pe_schedule");
        TDBView tDBView = null;
        TDBViewEntryCollection tDBViewEntryCollection = null;
        try {
            Object object;
            String string3 = this.getViewSubQuery(context, string2);
            string3 = UString.isEmpty((String)string3) ? "fbdocid='" + string + "'" : string3 + " AND fbdocid='" + string + "'";
            tDBView = tDBDatabase.openView("alltasksandwbsforgantt", string3);
            tDBViewEntryCollection = tDBView.getAllEntries();
            XSPProjectDataLoader xSPProjectDataLoader = new XSPProjectDataLoader(tDBSession, this.getSiteId());
            xSPProjectDataLoader.setForAllocations(true);
            NodeData nodeData = xSPProjectDataLoader.loadNodeData(tDBViewEntryCollection.getFirstEntry());
            for (int i = 0; i < arrayList.size(); ++i) {
                TaskResource[] taskResourceArray;
                TGNode tGNode = (GanttTask)arrayList.get(i);
                object = ((GanttTask)tGNode).getResources();
                this.getNodeSetModel().updateNode((GanttNode)tGNode, nodeData);
                if (i != 0 || this.sameResources((TaskResource[])object, taskResourceArray = ((GanttTask)tGNode).getResources())) continue;
                this.rebuildAllFromDatabase(context, nLSBundle);
                List<TGNode> list = null;
                return list;
            }
            for (TGNode tGNode : arrayList) {
                for (object = tGNode.getParent(); object != null && object instanceof AllocationsNode; object = object.getParent()) {
                    ((AllocationsNode)object).computeIntervals();
                }
            }
            ArrayList<TGNode> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (tDBViewEntryCollection != null) {
                tDBViewEntryCollection.close();
            }
            if (tDBView != null) {
                tDBView.close();
            }
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
        }
    }

    private boolean sameResources(TaskResource[] taskResourceArray, TaskResource[] taskResourceArray2) {
        if (taskResourceArray == null) {
            return taskResourceArray2 == null || taskResourceArray2.length == 0;
        }
        if (taskResourceArray2 == null) {
            return taskResourceArray.length == 0;
        }
        block0: for (TaskResource taskResource : taskResourceArray) {
            for (TaskResource taskResource2 : taskResourceArray2) {
                if (TString.equals((String)taskResource.getDn(), (String)taskResource2.getDn())) continue block0;
            }
            return false;
        }
        return true;
    }

    private ProjectRef[] getProjectElementsForResource(String string, ProjectRef[] projectRefArray, TDBDatabase tDBDatabase) throws TDBException {
        ProjectRef[] projectRefArray2 = this.getProjectElementsForResource(string, (String[])null, tDBDatabase);
        if (projectRefArray2 != null) {
            return this.intersecProjectIdsNamesWithReadable(projectRefArray2, projectRefArray);
        }
        return null;
    }

    private ProjectRef[] getProjectElementsForResource(String string, String[] stringArray, TDBDatabase tDBDatabase) throws TDBException {
        String[] stringArray2 = tDBDatabase.getLookupValues(PRJ_USERS_VIEW_NAME, this.getSiteId() + "|" + string, "projectid|projectname");
        if (stringArray2 == null) {
            return null;
        }
        if (stringArray == null) {
            ProjectRef[] projectRefArray = new ProjectRef[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = UString.splitString((String)stringArray2[i], (char)'|');
                projectRefArray[i] = new ProjectRef(this.getSiteId(), stringArray3[0], stringArray3[1]);
            }
            return projectRefArray;
        }
        ArrayList<ProjectRef> arrayList = new ArrayList<ProjectRef>();
        block1: for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray4 = UString.splitString((String)stringArray2[i], (char)'|');
            String string2 = tDBDatabase.getLookupValue("allprojects", this.getSiteId() + "|" + stringArray4[1] + "|" + stringArray4[0], "status");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!UString.equals((String)string2, (String)stringArray[j])) continue;
                ProjectRef projectRef = new ProjectRef(this.getSiteId(), stringArray4[0], stringArray4[1]);
                arrayList.add(projectRef);
                continue block1;
            }
        }
        ProjectRef[] projectRefArray = arrayList.toArray(new ProjectRef[arrayList.size()]);
        return projectRefArray;
    }

    private ProjectRef[] getProjectsReadableByUser(String[] stringArray, TDBDatabase tDBDatabase, Context context) throws TDBException {
        ProjectRef[] projectRefArray;
        Object object;
        boolean bl = false;
        if (context != null) {
            try {
                object = "import pe_administration_util; return canReadAllProjectsOnSite('" + this.getSiteId() + "');";
                bl = context.evaluateAsBooleanExpr((String)object, false);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)"Error during evaluation of script canReadAllProjectsOnSite");
            }
        }
        object = null;
        if (bl || context == null) {
            object = tDBDatabase.getLookupValues(PERCENT_THRESHOLD_VIEWNAME, this.getSiteId(), "id|name");
        } else {
            projectRefArray = context.getUser().getDistinguishedName();
            object = tDBDatabase.getLookupValues(PRJ_USERS_VIEW_NAME, this.getSiteId() + "|" + (String)projectRefArray, "projectid|projectname");
        }
        if (object != null) {
            if (stringArray == null) {
                projectRefArray = new ProjectRef[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String[] stringArray2 = UString.splitString((String)object[i], (char)'|');
                    projectRefArray[i] = new ProjectRef(this.getSiteId(), stringArray2[0], stringArray2[1]);
                }
                return projectRefArray;
            }
            projectRefArray = new ArrayList();
            block3: for (int i = 0; i < ((String[])object).length; ++i) {
                String[] stringArray3 = UString.splitString((String)object[i], (char)'|');
                String string = tDBDatabase.getLookupValue("allprojects", this.getSiteId() + "|" + stringArray3[1] + "|" + stringArray3[0], "status");
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!UString.equals((String)string, (String)stringArray[j])) continue;
                    ProjectRef projectRef = new ProjectRef(this.getSiteId(), stringArray3[0], stringArray3[1]);
                    projectRefArray.add(projectRef);
                    continue block3;
                }
            }
            ProjectRef[] projectRefArray2 = new ProjectRef[projectRefArray.size()];
            projectRefArray2 = projectRefArray.toArray(projectRefArray2);
            return projectRefArray2;
        }
        return null;
    }

    private ProjectRef[] intersecProjectIdsNamesWithReadable(ProjectRef[] projectRefArray, ProjectRef[] projectRefArray2) {
        if (projectRefArray2 == null || projectRefArray == null) {
            return null;
        }
        if (projectRefArray2.length == 0 || projectRefArray.length == 0) {
            return null;
        }
        ArrayList<ProjectRef> arrayList = new ArrayList<ProjectRef>();
        block0: for (ProjectRef projectRef : projectRefArray) {
            for (ProjectRef projectRef2 : projectRefArray2) {
                if (!projectRef.equals(projectRef2)) continue;
                arrayList.add(projectRef);
                continue block0;
            }
        }
        ProjectRef[] projectRefArray3 = arrayList.toArray(new ProjectRef[arrayList.size()]);
        return projectRefArray3;
    }

    private String getViewSubQuery(Context context, String string) throws XSPException {
        String string2 = null;
        if (context != null) {
            String string3 = "import pe_document_security; return getViewSubquery('local', 'pe_sc', '" + string + "', false, '" + this.getSiteId() + "');";
            string2 = context.evaluateAsStringExpr(string3);
            string2 = TString.fromJavaString((String)string2);
        }
        if (TString.isEmpty(string2)) {
            string2 = "projectid = '" + string + "' AND siteid = '" + this.getSiteId() + "'";
        }
        string2 = "(schema=='pe_task' OR subprojectid<>'') AND " + string2;
        return string2;
    }

    private void initGlobalContext(TDBSession tDBSession, java.util.Date date, NLSBundle nLSBundle) {
        this.initGlobalContext(date, nLSBundle);
        try {
            if (ScheduleComputation.isTimePrecision((TDBSession)tDBSession, (String)this.getSiteId())) {
                this.globalContext.setTimePrecision(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProjectContext(Context context, TDBSession tDBSession, Collection<ProjectData> collection) {
        HashMap<String, ProjectContext> hashMap = new HashMap<String, ProjectContext>();
        if (collection != null) {
            TDBDatabase tDBDatabase = null;
            try {
                for (ProjectData projectData : collection) {
                    Object object;
                    Object object2;
                    double d = 0.1;
                    double d2 = 0.2;
                    try {
                        object2 = tDBSession.getLookupValue("tg_pe_project", PERCENT_THRESHOLD_VIEWNAME, projectData.siteId + '|' + projectData.projectId, "warningthreshold|criticalthreshold");
                        object = TString.splitString((String)object2, (char)'|');
                        if (((String[])object).length == 2) {
                            try {
                                d = Double.valueOf(object[0]) / 100.0;
                                d2 = Double.valueOf(object[1]) / 100.0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                numberFormatException.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        TDiag.exception((Throwable)exception, (String)("Error to get threshold of project " + projectData.projectId));
                    }
                    if (d <= 0.0) {
                        d = 0.1;
                    }
                    if (d2 <= 0.0) {
                        d2 = 0.2;
                    }
                    object2 = new AllocationProjectContext((IAllocationGlobalContext)((Object)this.globalContext), projectData.projectId, d, d2);
                    try {
                        if (tDBDatabase == null) {
                            tDBDatabase = tDBSession.openDatabase("tg_pe_project");
                        }
                        object = this.getProjectCalendarId(tDBDatabase, projectData.projectId);
                        HashMap<String, ScheduleCalendar> hashMap2 = this.getProjectCalendars(tDBDatabase, projectData.projectId);
                        ((ProjectContext)object2).setProjectCalendar(hashMap2.get(object));
                        ((AllocationProjectContext)object2).setResourcesCalendarId(this.getProjectResourcesCalendarId(tDBDatabase, projectData.projectId));
                        ((AllocationProjectContext)object2).setProjectCalendars(hashMap2);
                        ((ProjectContext)object2).setShowPercentComplete(true);
                        hashMap.put(projectData.projectId, (ProjectContext)object2);
                    }
                    catch (Exception exception) {
                        TDiag.exception((Throwable)exception, (String)("Error to get calendars of project " + projectData.projectId));
                    }
                }
            }
            finally {
                if (tDBDatabase != null) {
                    tDBDatabase.close();
                }
            }
            this.getNodeSetModel().setProjectContexts(hashMap);
        }
    }

    private String getProjectCalendarId(TDBDatabase tDBDatabase, String string) {
        try {
            return tDBDatabase.getLookupValue(PERCENT_THRESHOLD_VIEWNAME, this.getSiteId() + "|" + string, "calendarid");
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Could not get calendar if of project " + string));
            return null;
        }
    }

    private HashMap<String, String> getProjectResourcesCalendarId(TDBDatabase tDBDatabase, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = tDBDatabase.getLookupValues("allusersbysiteidprojectidandcn", this.getSiteId() + "|" + string, "userdn|calendarid");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = TString.splitString((String)stringArray[i], (char)'|');
                    hashMap.put(stringArray2[0], stringArray2[1]);
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Could not get the calendars document of the project " + string));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ScheduleCalendar> getProjectCalendars(TDBDatabase tDBDatabase, String string) {
        HashMap<String, ScheduleCalendar> hashMap = new HashMap<String, ScheduleCalendar>();
        TDBView tDBView = null;
        TDBDocumentCollection tDBDocumentCollection = null;
        try {
            tDBView = tDBDatabase.openView("allcalendars");
            String[] stringArray = new String[]{this.getSiteId(), string};
            tDBDocumentCollection = tDBView.getAllDocumentsByKey(stringArray);
            if (tDBDocumentCollection != null) {
                String string2;
                TDBDocument tDBDocument = tDBDocumentCollection.getFirstDocument();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (tDBDocument != null) {
                    ScheduleCalendar scheduleCalendar = new ScheduleCalendar(tDBDocument.getJDOM());
                    string2 = scheduleCalendar.getCalendarId();
                    arrayList.add(string2);
                    hashMap.put(string2, scheduleCalendar);
                    tDBDocument = tDBDocumentCollection.getNextDocument();
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3;
                    string2 = hashMap.get(arrayList.get(i));
                    if (string2.isBaseCalendar() || TString.isEmpty((String)(string3 = string2.getBaseCalendarId()))) continue;
                    ScheduleCalendar scheduleCalendar = hashMap.get(string3);
                    string2.mergeWithBaseCalendar(scheduleCalendar);
                }
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Could not get the calendars document of the project " + string));
        }
        finally {
            if (tDBDocumentCollection != null) {
                tDBDocumentCollection.close();
            }
            if (tDBView != null) {
                tDBView.close();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllProjectsAllocations(TDBSession tDBSession) throws TDBException {
        TDBDatabase tDBDatabase = tDBSession.openDatabase("tg_pe_schedule");
        try {
            String string = "startdatetime|enddatetime|units|projectstatus|resourcedn";
            int n = this.getRootNode().getVisibleSubtaskCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                String[] stringArray;
                String string2;
                TGNode tGNode = this.getRootNode().getVisibleSubtask(i);
                if (!(tGNode instanceof ResourceAllocationsNode)) continue;
                ResourceAllocationsNode resourceAllocationsNode = (ResourceAllocationsNode)tGNode;
                ValueIntervals valueIntervals = new ValueIntervals();
                long l = -1L;
                long l2 = -1L;
                String string3 = resourceAllocationsNode.getResource().getDn();
                if (CROSS_SITE_ALLOCATIONS) {
                    string2 = "resourcedn=" + TString.toJavaString((String)string3, (boolean)true);
                    stringArray = DBUtil.openEntries((TDBDatabase)tDBDatabase, (String)"alltasksbysiteidresourcednandprojectid", (String)string2);
                    try {
                        n3 = stringArray.getView().getColumnIndexByName("resourcedn");
                        int n4 = stringArray.getView().getColumnIndexByName("startdatetime");
                        n2 = stringArray.getView().getColumnIndexByName("enddatetime");
                        int n5 = stringArray.getView().getColumnIndexByName("units");
                        int n6 = stringArray.getView().getColumnIndexByName("projectstatus");
                        for (TDBViewEntry tDBViewEntry : stringArray) {
                            if (!string3.equals(tDBViewEntry.getString(n3))) continue;
                            String string4 = tDBViewEntry.getString(n6);
                            boolean bl = true;
                            for (int j = 0; j < DEFAULT_PRJ_STATUS.length; ++j) {
                                if (!UString.equals((String)DEFAULT_PRJ_STATUS[j], (String)string4)) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                            }
                            Timestamp timestamp = tDBViewEntry.getTimestamp(n4);
                            Timestamp timestamp2 = tDBViewEntry.getTimestamp(n2);
                            if (((java.util.Date)timestamp2).getTime() > ((java.util.Date)timestamp).getTime()) {
                                int n7 = tDBViewEntry.getInteger(n5);
                                valueIntervals.addInterval(new ValueInterval(((java.util.Date)timestamp).getTime(), ((java.util.Date)timestamp2).getTime(), n7));
                            }
                            l = l == -1L ? ((java.util.Date)timestamp).getTime() : Math.min(l, ((java.util.Date)timestamp).getTime());
                            if (l2 == -1L) {
                                l2 = ((java.util.Date)timestamp2).getTime();
                                continue;
                            }
                            l2 = Math.max(l2, ((java.util.Date)timestamp2).getTime());
                        }
                    }
                    finally {
                        stringArray.close();
                    }
                } else {
                    string2 = this.getSiteId() + "|" + string3;
                    stringArray = tDBDatabase.getLookupValues("alltasksbysiteidresourcednandprojectid", string2, string);
                    if (stringArray != null) {
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            String[] stringArray2 = UString.splitString((String)stringArray[n3], (char)'|');
                            n2 = 0;
                            if (string3.equals(stringArray2[4])) {
                                for (int j = 0; j < DEFAULT_PRJ_STATUS.length; ++j) {
                                    if (!UString.equals((String)DEFAULT_PRJ_STATUS[j], (String)stringArray2[3])) continue;
                                    n2 = 1;
                                    break;
                                }
                            }
                            if (n2 == 0) continue;
                            Date date = JDOMUtil.parseDate((String)stringArray2[0]);
                            Date date2 = JDOMUtil.parseDate((String)stringArray2[1]);
                            int n8 = JDOMUtil.parseInteger((String)stringArray2[2]);
                            if (date2.getTime() > date.getTime()) {
                                valueIntervals.addInterval(new ValueInterval(date.getTime(), date2.getTime(), n8));
                            }
                            l = l == -1L ? date.getTime() : Math.min(l, date.getTime());
                            l2 = l2 == -1L ? date2.getTime() : Math.max(l2, date2.getTime());
                        }
                    }
                }
                if (l == -1L || l2 == -1L) {
                    resourceAllocationsNode.setDuration(resourceAllocationsNode.getParent().getDuration());
                } else {
                    resourceAllocationsNode.setDuration((TimePeriod)new SimpleTimePeriod(l, l2));
                }
                resourceAllocationsNode.setIntervals(valueIntervals);
            }
        }
        finally {
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getTasksInfoInTimeFrame(Context context, String string, String string2, java.util.Date date, java.util.Date date2, boolean bl) {
        String string3 = this.computeTaskInDatesSubQuery(date, date2);
        String string4 = " resourcedn LIKE '%" + string + "%'";
        String string5 = "(siteid = '" + this.getSiteId() + "') AND (" + string3 + ") AND (" + string4 + ")";
        TDBSession tDBSession = null;
        TDBDatabase tDBDatabase = null;
        try {
            TDBServer tDBServer = Application.getDBServer(null);
            tDBSession = tDBServer.createSession();
            tDBDatabase = tDBSession.openDatabase("tg_pe_project");
            ProjectRef[] projectRefArray = this.getProjectsForTasksInfo(context, tDBDatabase, string, string2, bl);
            Object[] objectArray = this.getTasksInfoForQuery(context, tDBSession, tDBDatabase, projectRefArray, string5, string, bl);
            return objectArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
            if (tDBSession != null) {
                tDBSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getTasksInfoOfAllConflict(Context context, String string, String string2, boolean bl) {
        Object object;
        Serializable serializable;
        ValueIntervals valueIntervals;
        ResourceAllocationsNode resourceAllocationsNode = (ResourceAllocationsNode)this.getNodeSetModel().getNodeByUid(string);
        if (bl) {
            valueIntervals = resourceAllocationsNode.getIntervals();
        } else {
            serializable = null;
            if (!TString.isEmpty((String)string2)) {
                serializable = this.getProjectAllocationsNodeById(resourceAllocationsNode, string2);
            }
            if (serializable == null) {
                serializable = (ProjectAllocationsNode)resourceAllocationsNode.getVisibleSubtask(0);
            }
            valueIntervals = ((ProjectAllocationsNode)serializable).getIntervals();
        }
        serializable = new StringBuilder();
        for (int i = 0; i < valueIntervals.size(); ++i) {
            object = (ValueInterval)valueIntervals.get(i);
            if (((ValueInterval)object).value <= 100) continue;
            if (((StringBuilder)serializable).length() > 0) {
                ((StringBuilder)serializable).append(" OR ");
            }
            ((StringBuilder)serializable).append(this.computeTaskInDatesSubQuery(new java.util.Date(((ValueInterval)object).start), new java.util.Date(((ValueInterval)object).end)));
        }
        if (((StringBuilder)serializable).length() == 0) {
            return new Object[0];
        }
        String string3 = " resourcedn LIKE '%" + string + "%'";
        object = "(siteid = '" + this.getSiteId() + "') AND (" + ((StringBuilder)serializable).toString() + ") AND (" + string3 + ")";
        TDBSession tDBSession = null;
        TDBDatabase tDBDatabase = null;
        try {
            TDBServer tDBServer = Application.getDBServer(null);
            tDBSession = tDBServer.createSession();
            tDBDatabase = tDBSession.openDatabase("tg_pe_project");
            ProjectRef[] projectRefArray = this.getProjectsForTasksInfo(context, tDBDatabase, string, string2, bl);
            Object[] objectArray = this.getTasksInfoForQuery(context, tDBSession, tDBDatabase, projectRefArray, (String)object, string, bl);
            return objectArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            if (tDBDatabase != null) {
                tDBDatabase.close();
            }
            if (tDBSession != null) {
                tDBSession.close();
            }
        }
    }

    private ProjectAllocationsNode getProjectAllocationsNodeById(ResourceAllocationsNode resourceAllocationsNode, String string) {
        for (int i = 0; i < resourceAllocationsNode.getAllSubTaskCount(); ++i) {
            ProjectAllocationsNode projectAllocationsNode;
            TGNode tGNode = resourceAllocationsNode.getSubtaskInAll(i);
            if (!(tGNode instanceof ProjectAllocationsNode) || !(projectAllocationsNode = (ProjectAllocationsNode)tGNode).getProjectId().equals(string)) continue;
            return projectAllocationsNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getTasksInfoForQuery(Context context, TDBSession tDBSession, TDBDatabase tDBDatabase, ProjectRef[] projectRefArray, String string, String string2, boolean bl) {
        int n;
        int n2;
        ArrayList<Object> arrayList;
        block20: {
            arrayList = new ArrayList<Object>();
            TDBDatabase tDBDatabase2 = null;
            TDBView tDBView = null;
            n2 = 0;
            n = 0;
            try {
                int n3;
                tDBDatabase2 = tDBSession.openDatabase("tg_pe_schedule");
                String string3 = string;
                ProjectRef[] projectRefArray2 = null;
                projectRefArray2 = bl ? this.getProjectElementsForResource(string2, DEFAULT_PRJ_STATUS, tDBDatabase) : projectRefArray;
                if (projectRefArray2 != null) {
                    string3 = string3 + " AND projectid IN (";
                    for (n3 = 0; n3 < projectRefArray2.length; ++n3) {
                        string3 = string3 + "'" + projectRefArray2[n3].projectId + "'";
                        if (n3 >= projectRefArray2.length - 1) continue;
                        string3 = string3 + ", ";
                    }
                    string3 = string3 + ") ";
                }
                tDBView = tDBDatabase2.openView("alltasksbysiteidprojectidandid", string3);
                n2 = tDBView.getDocumentCount();
                n3 = tDBView.getColumnIndexByName("name");
                int n4 = tDBView.getColumnIndexByName("startdatetime");
                int n5 = tDBView.getColumnIndexByName("enddatetime");
                int n6 = tDBView.getColumnIndexByName("resourcedn");
                int n7 = tDBView.getColumnIndexByName("units");
                tDBView.close();
                if (projectRefArray == null) break block20;
                for (int i = 0; i < projectRefArray.length; ++i) {
                    TDBViewEntryCollection tDBViewEntryCollection = null;
                    try {
                        String string4 = "import pe_document_security; return getViewSubquery('local', 'pe_sc', '" + projectRefArray[i].projectId + "', false, '" + this.getSiteId() + "');";
                        String string5 = context.evaluateAsStringExpr(string4);
                        string5 = TString.fromJavaString((String)string5);
                        String string6 = "(projectid = '" + projectRefArray[i].projectId + "') AND (" + string5 + ") AND (" + string + ")";
                        tDBView = tDBDatabase2.openView("alltasksbysiteidprojectidandid", string6);
                        tDBViewEntryCollection = tDBView.getAllEntries();
                        TDBViewEntry tDBViewEntry = tDBViewEntryCollection.getFirstEntry();
                        if (tDBViewEntry != null) {
                            arrayList.add(projectRefArray[i].name);
                        }
                        while (tDBViewEntry != null) {
                            ++n;
                            TaskData taskData = new TaskData();
                            taskData.name = tDBViewEntry.getString(n3);
                            taskData.startDate = tDBViewEntry.getDate(n4);
                            taskData.endDate = tDBViewEntry.getDate(n5);
                            String[] stringArray = tDBViewEntry.getStrings(n6);
                            int n8 = -1;
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (!TString.equals((String)stringArray[j], (String)string2)) continue;
                                n8 = j;
                                break;
                            }
                            String[] stringArray2 = tDBViewEntry.getStrings(n7);
                            if (n8 != -1 && n8 < stringArray2.length) {
                                try {
                                    taskData.resourceUnit = Integer.parseInt(stringArray2[n8]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            arrayList.add(taskData);
                            tDBViewEntry = tDBViewEntryCollection.getNextEntry();
                        }
                        continue;
                    }
                    finally {
                        if (tDBViewEntryCollection != null) {
                            tDBViewEntryCollection.close();
                        }
                        if (tDBView != null) {
                            tDBView.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (tDBDatabase2 != null) {
                    tDBDatabase2.close();
                }
            }
        }
        arrayList.add(0, new Integer(n2 - n));
        return arrayList.toArray();
    }

    private ProjectRef[] getProjectsForTasksInfo(Context context, TDBDatabase tDBDatabase, String string, String string2, boolean bl) throws TDBException {
        ProjectRef[] projectRefArray = null;
        if (bl) {
            ProjectRef[] projectRefArray2 = this.getProjectsReadableByUser(DEFAULT_PRJ_STATUS, tDBDatabase, context);
            projectRefArray = this.getProjectElementsForResource(string, projectRefArray2, tDBDatabase);
        } else {
            String string3 = tDBDatabase.getLookupValue(PERCENT_THRESHOLD_VIEWNAME, this.getSiteId() + "|" + string2, "name");
            ProjectRef projectRef = new ProjectRef(this.getSiteId(), string2, string3);
            String[] stringArray = SubprojectUtil.getSubProjects((TDBSession)tDBDatabase.getSession(), (com.triloggroup.project.ProjectRef)projectRef, (int)0);
            projectRefArray = new ProjectRef[stringArray.length + 1];
            projectRefArray[0] = projectRef;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                string3 = tDBDatabase.getLookupValue(PERCENT_THRESHOLD_VIEWNAME, this.getSiteId() + "|" + string4, "name");
                projectRefArray[i + 1] = new ProjectRef(this.getSiteId(), string4, string3);
            }
        }
        return projectRefArray;
    }

    private String computeTaskInDatesSubQuery(java.util.Date date, java.util.Date date2) {
        String string = "#" + I18n.toString((java.util.Date)date, (String)"yyyy-MM-dd HH:mm:ss#");
        String string2 = "#" + I18n.toString((java.util.Date)date2, (String)"yyyy-MM-dd HH:mm:ss") + "#";
        return " ((startdatetime >= " + string + " AND startdatetime < " + string2 + ") OR (enddatetime > " + string + " AND enddatetime <= " + string2 + ") OR (startdatetime<= " + string + " AND enddatetime >= " + string2 + "))";
    }

    public static class TaskData {
        public String name;
        public java.util.Date startDate;
        public java.util.Date endDate;
        public int resourceUnit;
    }
}

