/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation.xsp;

import com.flowbuilder.docdb.TDBException;
import com.flowbuilder.docdb.TDBSession;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.XMLException;
import com.flowbuilder.xsp.servlet.Context;
import com.flowbuilder.xsp.servlet.XSPException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.allocation.AllocationChart;
import com.triloggroup.gantt.allocation.AllocationsNode;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.gantt.allocation.renderer.AllocationNodeRenderer;
import com.triloggroup.gantt.allocation.xsp.PEXSPAllocationChartModel;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.gantt.xsp.IXSPGanttChart;
import com.triloggroup.gantt.xsp.UXSPGanttChart;
import com.triloggroup.pe.util.PEUtil;
import com.triloggroup.util.NLSBundle;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.chart.plot.CategoryPlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEXSPAllocationChart
extends AllocationChart
implements IXSPGanttChart {
    public static final String CHART_TYPE_PROJECT_ALLOCATIONS = "project_allocation";
    public static final String CHART_TYPE_ALLOC_BY_RESOURCE = "resources_allocation";
    public static final String CHART_TYPE_SIMPLE_RESOURCE_ALLOC = "simple_resource_allocation";
    private static final Map<Locale, NLSBundle> nlsBundlesCache = new HashMap<Locale, NLSBundle>();
    public static final String DISPLAY_MODE_CMD = "displaymode";
    public static final String MODE_PARAM = "modeName";

    @Override
    protected void initChart() {
        super.initChart();
        if (Boolean.parseBoolean(PEUtil.projexecProperties.getProperty("projexec.gantt.allocations.waveui"))) {
            AllocationNodeRenderer allocationNodeRenderer = (AllocationNodeRenderer)((CategoryPlot)this.chart.getPlot()).getRenderer();
            allocationNodeRenderer.setWaveui(true);
        }
    }

    public void initLocale(Locale locale, Locale locale2, TimeZone timeZone) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.formatLocale = locale2 == null ? this.locale : locale2;
        this.nlsBundle = this.createNLSBundle(locale);
    }

    public void initData(String[] stringArray, String[] stringArray2, String string, Context context, TDBSession tDBSession, Date date) throws Exception {
        PEXSPAllocationChartModel pEXSPAllocationChartModel = new PEXSPAllocationChartModel(stringArray, stringArray2, string);
        pEXSPAllocationChartModel.init(context, tDBSession, date, this.nlsBundle);
        this.setModel(pEXSPAllocationChartModel);
    }

    public void initData(String string, String string2, boolean bl, Context context, TDBSession tDBSession, Date date) throws Exception {
        PEXSPAllocationChartModel pEXSPAllocationChartModel = new PEXSPAllocationChartModel(string, string2, bl);
        pEXSPAllocationChartModel.init(context, tDBSession, date, this.nlsBundle);
        this.setModel(pEXSPAllocationChartModel);
    }

    public void initDataByResource(String[] stringArray, String string, Context context, TDBSession tDBSession, Date date) throws Exception {
        PEXSPAllocationChartModel pEXSPAllocationChartModel = new PEXSPAllocationChartModel(stringArray, string);
        pEXSPAllocationChartModel.init(context, tDBSession, date, this.nlsBundle);
        this.setModel(pEXSPAllocationChartModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NLSBundle createNLSBundle(Locale locale) {
        NLSBundle nLSBundle;
        Map<Locale, NLSBundle> map = nlsBundlesCache;
        synchronized (map) {
            nLSBundle = nlsBundlesCache.get(locale);
            if (nLSBundle == null) {
                nLSBundle = super.createNLSBundle(locale);
                nlsBundlesCache.put(locale, nLSBundle);
            }
        }
        return nLSBundle;
    }

    @Override
    protected String getDetailsURL(TGNode tGNode) {
        if (tGNode instanceof GanttTask) {
            ProjectContext projectContext = (ProjectContext)tGNode.getNodeContext();
            return "/projexec/schedule/pe_schedule_ganttnode_details.xsp?ganttProjectId=" + projectContext.getProjectId() + "&ganttSiteId=" + projectContext.getGlobalContext().getSiteId() + "&ganttChartType=" + this.getChartType() + "&ganttNodeIsTask=true" + "&docId=" + tGNode.getDocId();
        }
        if (tGNode instanceof AllocationsNode) {
            int n = ((IAllocationGlobalContext)tGNode.getGlobalContext()).getDisplayMode();
            if (n == 0 && tGNode instanceof ResourceAllocationsNode) {
                return null;
            }
            ValueIntervals valueIntervals = ((AllocationsNode)tGNode).getIntervals();
            if (valueIntervals != null && !valueIntervals.isEmpty()) {
                Object object;
                StringBuilder stringBuilder = new StringBuilder("/projexec/schedule/pe_schedule_allocation_details.xsp?");
                String string = tGNode.getDescription();
                stringBuilder.append("ganttNodeId=").append(this.encodeUrlParameter(string));
                stringBuilder.append("&ganttSiteId=").append(this.model.getSiteId());
                stringBuilder.append("&ganttChartType=").append(this.getChartType());
                if (this.getModel().getNodeSetModel().getSingleProjectId() != null) {
                    stringBuilder.append("&ganttProjectId=").append(this.getModel().getNodeSetModel().getSingleProjectId());
                } else {
                    object = this.getModel().getNodeSetModel().getInitialProjectIds();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append('|');
                        }
                        stringBuilder2.append(object[i]);
                    }
                    stringBuilder.append("&ganttProjectId=").append(this.encodeUrlParameter(stringBuilder2.toString()));
                    String[] stringArray = this.getModel().getNodeSetModel().getResourceDns();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringBuilder3.length() > 0) {
                            stringBuilder3.append('|');
                        }
                        stringBuilder3.append(stringArray[i]);
                    }
                    stringBuilder.append("&ganttResourceDns=").append(this.encodeUrlParameter(stringBuilder3.toString()));
                    if (tGNode.getNodeContext() instanceof ProjectContext) {
                        stringBuilder.append("&ganttNodeProjectId=");
                        stringBuilder.append(((ProjectContext)tGNode.getNodeContext()).getProjectId());
                    }
                }
                if (tGNode instanceof ResourceAllocationsNode) {
                    stringBuilder.append("&ganttAllocAllPrjs=true");
                }
                stringBuilder.append("&ganttNodeResourceDn=");
                object = ((AllocationsNode)tGNode).getParentResource();
                stringBuilder.append(this.encodeUrlParameter(((Resource)object).getDn()));
                return stringBuilder.toString();
            }
        }
        return null;
    }

    private String encodeUrlParameter(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return URLEncoder.encode(string);
        }
    }

    @Override
    public String applyCommand(Context context, String string, Map<String, String[]> map) throws Exception {
        if (!TString.isEmpty((String)string)) {
            if (string.equalsIgnoreCase(DISPLAY_MODE_CMD)) {
                try {
                    String string2 = UXSPGanttChart.getParameter(map, MODE_PARAM);
                    int n = 0;
                    if (TString.equals((String)string2, (String)"crossproject")) {
                        n = 1;
                    } else if (TString.equals((String)string2, (String)"all")) {
                        n = 2;
                    } else if (TString.equals((String)string2, (String)"allwithouttask")) {
                        n = 3;
                    }
                    int n2 = this.getModel().getDisplayMode();
                    this.getModel().setDisplayMode(n, context);
                    this.model.reapplyCurrentFilter();
                    if (n == 1 || n == 3) {
                        String[] stringArray = TGTreeTableModel.getColumnKeyNames(true, false, false, false);
                        this.updateTableColumnOption(stringArray);
                    } else if (n2 == 1) {
                        String[] stringArray = UXSPGanttChart.getUserPreferenceTableColumnKeyNames(context, this.getChartType());
                        this.updateTableColumnOption(stringArray);
                    }
                    return "ok";
                }
                catch (Exception exception) {
                    TDiag.exception((Throwable)exception, (String)"Error to show All projects allocations");
                    return "error";
                }
            }
            return UXSPGanttChart.applyCommand(this, context, string, map);
        }
        return "";
    }

    @Override
    public String getChartType() {
        if (this.getModel().getNodeSetModel().isSingleProject()) {
            return CHART_TYPE_PROJECT_ALLOCATIONS;
        }
        if (3 == this.getModel().getDisplayMode()) {
            return CHART_TYPE_SIMPLE_RESOURCE_ALLOC;
        }
        return CHART_TYPE_ALLOC_BY_RESOURCE;
    }

    @Override
    public void rebuildAllFromDatabase(Context context) throws XMLException, TDBException, XSPException, GanttChartException {
        this.getModel().rebuildAllFromDatabase(context, this.nlsBundle);
        this.model.reapplyCurrentFilter();
        if (this.treeTable != null) {
            this.treeTable.computePreferredWidth();
        }
    }

    @Override
    public void refreshNodeFromDatabase(Context context, String string) throws Exception {
        if (context == null) {
            throw new Exception("Cannot update Gantt node with null context");
        }
        List<TGNode> list = this.getModel().refreshNodeFromDatabase(context, string, this.nlsBundle);
        if (this.treeTable != null) {
            this.treeTable.computePreferredWidth();
        }
    }

    public Object[] getTasksInfoInTimeFrame(Context context, String string, String string2, Date date, Date date2, boolean bl) {
        return this.getModel().getTasksInfoInTimeFrame(context, string, string2, date, date2, bl);
    }

    public Object[] getTasksInfoOfAllConflict(Context context, String string, String string2, boolean bl) {
        return this.getModel().getTasksInfoOfAllConflict(context, string, string2, bl);
    }

    public IntervalData[] getAllocationIntervalsOfNode(String string) {
        ValueIntervals valueIntervals;
        TGNode tGNode;
        if (string != null && (tGNode = this.getModel().getNodeSetModel().getNodeByUid(string)) != null && tGNode instanceof AllocationsNode && !(valueIntervals = ((AllocationsNode)tGNode).getIntervals()).isEmpty()) {
            IntervalData[] intervalDataArray = new IntervalData[valueIntervals.size()];
            for (int i = 0; i < valueIntervals.size(); ++i) {
                ValueInterval valueInterval = (ValueInterval)valueIntervals.get(i);
                intervalDataArray[i] = new IntervalData();
                intervalDataArray[i].start = valueInterval.start;
                intervalDataArray[i].end = valueInterval.end;
                intervalDataArray[i].value = valueInterval.value;
            }
            return intervalDataArray;
        }
        return null;
    }

    @Override
    protected BufferedImage imgCreateBufferedImage(int n, int n2, int n3) {
        return new BufferedImage(n, n2, 8);
    }

    @Override
    protected int imgGetMinVisibleRows() {
        if (this.getModel().getDisplayMode() == 3) {
            return 1;
        }
        return super.imgGetMinVisibleRows();
    }

    @Override
    public int imgGetRowCountPerTile() {
        if (this.getModel().getDisplayMode() == 3) {
            return Integer.MAX_VALUE;
        }
        return super.imgGetRowCountPerTile();
    }

    @Override
    public PEXSPAllocationChartModel getModel() {
        return (PEXSPAllocationChartModel)this.model;
    }

    public static class IntervalData {
        public long start;
        public long end;
        public int value;
    }
}

