/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.ChartModelUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.NodeSetModel;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ProjectAllocationsNode;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.gantt.allocation.loading.AllocationData;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.loading.ProjectData;
import com.triloggroup.util.UString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocationNodeSetModel
extends NodeSetModel {
    protected String singleProjectId = null;
    protected String[] resourceDns = null;
    protected String[] projectIds = null;
    private String[] initialProjectIds;
    protected HashMap<String, ProjectContext> prjContexts = new HashMap();
    private int nodeIdx = 0;

    public AllocationNodeSetModel(GlobalContext globalContext, String[] stringArray, String[] stringArray2) {
        super(globalContext);
        this.resourceDns = stringArray;
        this.projectIds = stringArray2;
        this.initialProjectIds = (String[])stringArray2.clone();
    }

    public AllocationNodeSetModel(GlobalContext globalContext, String string) {
        super(globalContext);
        this.singleProjectId = string;
    }

    public void setProjectContexts(HashMap<String, ProjectContext> hashMap) {
        this.prjContexts = hashMap;
    }

    public boolean isSingleProject() {
        return !UString.isEmpty((String)this.singleProjectId);
    }

    public String getSingleProjectId() {
        return this.singleProjectId;
    }

    public String[] getInitialProjectIds() {
        return this.initialProjectIds;
    }

    public String[] getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(String[] stringArray) {
        this.projectIds = stringArray;
    }

    public String[] getResourceDns() {
        return this.resourceDns;
    }

    protected void initData(AllocationData allocationData) throws GanttChartException {
        this.rootNode = null;
        allocationData.addSubprojectResourcesToParentProject(this);
        long l = -1L;
        long l2 = -1L;
        Date date = new Date();
        if (!((IAllocationGlobalContext)((Object)this.getGlobalContext())).isGanttResource()) {
            Object[] objectArray = this.isSingleProject() ? this.getResources(allocationData.getProjectResources(this.singleProjectId).toArray(new String[0])) : this.getResources(this.resourceDns);
            Arrays.sort(objectArray);
            this.rootNode = TGNode.createFakeRoot();
            this.rootNode.setNodeContext(this.globalContext);
            this.allNodes.put(this.rootNode.getHierarchicalId(), this.rootNode);
            for (Object object : objectArray) {
                String[] stringArray;
                String[] stringArray2;
                long l3 = -1L;
                long l4 = -1L;
                ResourceAllocationsNode resourceAllocationsNode = new ResourceAllocationsNode((Resource)object);
                resourceAllocationsNode.setNodeContext(this.globalContext);
                this.allNodes.put(((Resource)object).getDn(), resourceAllocationsNode);
                this.rootNode.addSubtask(resourceAllocationsNode);
                if (this.projectIds != null) {
                    stringArray2 = this.projectIds;
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = this.singleProjectId;
                }
                for (String string : stringArray = stringArray2) {
                    if (!allocationData.getProjectResources(string).contains(((Resource)object).getDn())) continue;
                    ChartModelUtil.checkEnoughAvailableMemory(this.globalContext.getNLSBundle());
                    ProjectData projectData = allocationData.getProjectById(string);
                    ProjectAllocationsNode projectAllocationsNode = this.createPrjAllocationsAndTasks(allocationData, projectData, (Resource)object);
                    resourceAllocationsNode.addSubtask(projectAllocationsNode);
                    projectAllocationsNode.computeIntervals();
                    this.allNodes.put(projectAllocationsNode.getDescription(), projectAllocationsNode);
                    TimePeriod timePeriod = projectAllocationsNode.getDuration();
                    Date date2 = timePeriod.getStart();
                    Date date3 = timePeriod.getEnd();
                    l3 = l3 == -1L ? date2.getTime() : Math.min(l3, date2.getTime());
                    l4 = l4 == -1L ? date3.getTime() : Math.max(l4, date3.getTime());
                    l = l == -1L ? l3 : Math.min(l, l3);
                    l2 = l2 == -1L ? l4 : Math.max(l2, l4);
                }
                if (l3 != -1L && l4 != -1L) {
                    resourceAllocationsNode.setDuration((TimePeriod)new SimpleTimePeriod(l3, l4));
                } else {
                    resourceAllocationsNode.setDuration(null);
                }
                resourceAllocationsNode.computeIntervals();
            }
        }
        if (l == -1L) {
            l = date.getTime();
        }
        if (l2 == -1L) {
            l2 = date.getTime();
        }
        this.rootNode.setDuration((TimePeriod)new SimpleTimePeriod(l, l2));
        this.dataStartDate = new Date(l);
        this.dataEndDate = new Date(l2);
    }

    protected ProjectAllocationsNode createPrjAllocationsAndTasks(AllocationData allocationData, ProjectData projectData, Resource resource) throws GanttChartException {
        ProjectAllocationsNode projectAllocationsNode = new ProjectAllocationsNode(projectData.name, projectData.projectId, this.nodeIdx++);
        ProjectContext projectContext = this.prjContexts.get(projectData.projectId);
        projectAllocationsNode.setNodeContext(projectContext);
        long l = -1L;
        long l2 = -1L;
        long l3 = new Date().getTime();
        if (projectData.nodes != null) {
            for (int i = 0; i < projectData.nodes.size(); ++i) {
                Serializable serializable;
                Object object;
                NodeData nodeData = projectData.nodes.get(i);
                if (nodeData.subProject != null) {
                    if (allocationData.getProjectResources(nodeData.subProject.getId()).contains(resource.getDn())) {
                        object = allocationData.getProjectById(nodeData.subProject.getId());
                        serializable = this.createPrjAllocationsAndTasks(allocationData, (ProjectData)object, resource);
                        projectAllocationsNode.addSubtask((Task)serializable);
                        this.allNodes.put(serializable.getDescription(), serializable);
                    }
                } else if (this.isUserAssigned(nodeData, resource)) {
                    object = this.createNode(nodeData, projectContext);
                    ((GanttNode)object).setUid("task_" + this.nodeIdx++);
                    projectAllocationsNode.addSubtask((Task)object);
                    this.allNodes.put(((GanttNode)object).getUid(), object);
                }
                object = nodeData.startDate;
                serializable = nodeData.endDate;
                l = l == -1L ? ((Date)object).getTime() : Math.min(l, ((Date)object).getTime());
                l2 = l2 == -1L ? ((Date)serializable).getTime() : Math.max(l2, ((Date)serializable).getTime());
            }
            if (l == -1L) {
                l = l3;
            }
            if (l2 == -1L) {
                l2 = l3;
            }
            projectAllocationsNode.setDuration((TimePeriod)new SimpleTimePeriod(l, l2));
        }
        return projectAllocationsNode;
    }

    private boolean isUserAssigned(NodeData nodeData, Resource resource) {
        if (resource == null) {
            return nodeData.resourceDns == null || nodeData.resourceDns.length == 0;
        }
        if (nodeData.resourceDns != null) {
            for (String string : nodeData.resourceDns) {
                if (!TString.equals((String)string, (String)resource.getDn())) continue;
                return true;
            }
        }
        return false;
    }

    public GanttNode createNode(NodeData nodeData, ProjectContext projectContext) {
        return ChartModelUtil.createGanttNode((NodeSetModel)this, nodeData, projectContext);
    }

    public void updateNode(GanttNode ganttNode, NodeData nodeData) throws XMLException {
        ChartModelUtil.updateGanttNode((NodeSetModel)this, ganttNode, nodeData);
    }

    public ArrayList<TGNode> getNodesByDocIdInAll(String string) {
        ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
        Iterator iterator = this.allNodes.entrySet().iterator();
        while (iterator.hasNext()) {
            TGNode tGNode = (TGNode)iterator.next().getValue();
            if (!UString.equals((String)tGNode.getDocId(), (String)string)) continue;
            arrayList.add(tGNode);
        }
        return arrayList;
    }
}

