/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation;

import com.triloggroup.gantt.ChartModelUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.allocation.AllocationGlobalContext;
import com.triloggroup.gantt.allocation.AllocationNodeSetModel;
import com.triloggroup.gantt.allocation.loading.AllocationData;
import com.triloggroup.gantt.pe.xsp.PEXSPTimeUnits;
import com.triloggroup.util.NLSBundle;
import java.util.Date;

public abstract class AllocationChartModel
extends TGChartModel {
    protected AllocationChartModel(String[] stringArray, String[] stringArray2, String string) {
        super(string);
        boolean bl = false;
        this.globalContext = new AllocationGlobalContext(string, bl);
        this.nodeSetModel = this.createNodeSetModel(stringArray, stringArray2);
    }

    protected AllocationChartModel(String string, String string2, boolean bl) {
        super(string2);
        this.globalContext = new AllocationGlobalContext(string2, bl);
        this.nodeSetModel = this.createNodeSetModel(string);
    }

    protected AllocationChartModel(String[] stringArray, String string) {
        super(string);
        boolean bl = true;
        this.globalContext = new AllocationGlobalContext(string, bl);
        this.nodeSetModel = this.createNodeSetModel(null, stringArray);
    }

    protected abstract AllocationNodeSetModel createNodeSetModel(String[] var1, String[] var2);

    protected abstract AllocationNodeSetModel createNodeSetModel(String var1);

    public AllocationGlobalContext getGlobalContext() {
        return (AllocationGlobalContext)this.globalContext;
    }

    public AllocationNodeSetModel getNodeSetModel() {
        return (AllocationNodeSetModel)this.nodeSetModel;
    }

    public void setDisplayMode(int n) {
        this.getGlobalContext().setDisplayMode(n);
    }

    public int getDisplayMode() {
        return this.getGlobalContext().getDisplayMode();
    }

    protected void initData(AllocationData allocationData) throws GanttChartException {
        ChartModelUtil.checkEnoughAvailableMemory(this.globalContext.getNLSBundle());
        this.resetTaskSeriesForInit();
        ((AllocationNodeSetModel)this.nodeSetModel).initData(allocationData);
    }

    protected void initGlobalContext(Date date, NLSBundle nLSBundle) {
        ITimeUnits iTimeUnits = this.globalContext.getTimeUnits();
        if (iTimeUnits == null) {
            iTimeUnits = this.createTimeUnits(nLSBundle);
        }
        ((AllocationGlobalContext)this.globalContext).init(date, nLSBundle, iTimeUnits);
    }

    protected ITimeUnits createTimeUnits(NLSBundle nLSBundle) {
        return PEXSPTimeUnits.get(nLSBundle);
    }
}

