/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.project.components.IContext;
import com.triloggroup.project.components.IGlobalContext;
import com.triloggroup.util.UString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGNode
extends Task
implements Serializable {
    protected static Date DUMMY_DATE = new Date();
    public static final Comparator<TGNode> sortedIdComparator = new Comparator<TGNode>(){

        @Override
        public int compare(TGNode tGNode, TGNode tGNode2) {
            String string = tGNode.hierarchicalId;
            String string2 = tGNode2.hierarchicalId;
            int n = string.length();
            int n2 = string2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = string.charAt(i);
                if (c2 == (c = string2.charAt(i))) continue;
                if (c2 == '.') {
                    return -1;
                }
                if (c == '.') {
                    return 1;
                }
                int n4 = c2 - c;
                while (i < n3) {
                    c2 = string.charAt(i);
                    c = string2.charAt(i);
                    if (c2 == '.') {
                        return c == '.' ? n4 : -1;
                    }
                    if (c == '.') {
                        return 1;
                    }
                    ++i;
                }
                if (n == n2) {
                    return n4;
                }
                if (n > n2) {
                    return string.charAt(i) == '.' ? n4 : 1;
                }
                return string2.charAt(i) == '.' ? n4 : -1;
            }
            return n - n2;
        }
    };
    protected static final String FAKE_ROOT_NAME = "FakeRoot";
    protected String docId;
    private String hierarchicalId;
    private String parentHierarchicalId;
    protected String name;
    protected String nodeDescription;
    protected IContext nodeContext;
    protected TGNode parentNode;
    protected boolean readable = true;
    protected long lastModificationTime = 0L;
    protected boolean hiddenByFilter = false;
    protected boolean isExpanded = false;

    public static TGNode createFakeRoot() {
        Date date = new Date();
        TGNode tGNode = new TGNode(null, "1", FAKE_ROOT_NAME, FAKE_ROOT_NAME, date, date);
        tGNode.setExpanded(true);
        return tGNode;
    }

    public TGNode(String string, String string2, String string3, String string4, Date date, Date date2) {
        super(string4, date, date2);
        this.docId = string;
        this.hierarchicalId = string2;
        this.name = string3;
        this.setPercentComplete(0.0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addSubtask(Task task) {
        super.addSubtask(task);
        ((TGNode)task).setParent(this);
    }

    public void removeSubtask(Task task) {
        super.removeSubtask(task);
        TGNode tGNode = (TGNode)task;
        if (tGNode.parentNode == this) {
            tGNode.setParent(null);
        }
    }

    public boolean isFakeRoot() {
        return this.name == FAKE_ROOT_NAME;
    }

    public String getParentHierarchicalId() {
        if (this.parentHierarchicalId == null) {
            if (this.hierarchicalId == null) {
                return null;
            }
            int n = this.hierarchicalId.lastIndexOf(46);
            this.parentHierarchicalId = n < 0 ? "0" : this.hierarchicalId.substring(0, n);
        }
        return this.parentHierarchicalId;
    }

    public String getHierarchicalId() {
        return this.hierarchicalId;
    }

    public void setHierarchicalId(String string) {
        this.hierarchicalId = string;
        this.parentHierarchicalId = null;
    }

    public String getSortableId() {
        String[] stringArray = UString.splitString((String)this.hierarchicalId, (char)'.');
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 4);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            switch (string.length()) {
                case 1: {
                    stringBuilder.append("000");
                    break;
                }
                case 2: {
                    stringBuilder.append("00");
                    break;
                }
                case 3: {
                    stringBuilder.append("0");
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getNodeDescription() {
        return this.nodeDescription;
    }

    public void setNodeDescription(String string) {
        this.nodeDescription = string;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String string) {
        if (this.docId == null || string == null) {
            this.docId = string;
        } else if (!TString.equals((String)this.docId, (String)string)) {
            throw new IllegalStateException("It is not possible to change doc id. Node: " + this.hierarchicalId);
        }
    }

    public boolean setExpanded(boolean bl) {
        this.isExpanded = bl;
        return true;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public Date getStartDate() {
        return this.getDuration().getStart();
    }

    public void setStartDate(Date date) {
        this.setDuration(date, this.getFinishDate());
    }

    public Date getFinishDate() {
        return this.getDuration().getEnd();
    }

    public void setFinishDate(Date date) {
        Date date2 = this.getStartDate();
        if (date != null) {
            if (date2 == null) {
                date2 = new Date();
            }
            if (date2.after(date)) {
                date2 = (Date)date.clone();
            }
        }
        this.setDuration(date2, date);
    }

    public void setDuration(Date date, Date date2) {
        if (date == null) {
            date = new Date();
        }
        if (date2 == null || date.getTime() > date2.getTime()) {
            date2 = (Date)date.clone();
        }
        this.resetMillis(date);
        this.resetMillis(date2);
        this.setDuration((TimePeriod)new SimpleTimePeriod(date, date2));
    }

    protected void resetMillis(Date date) {
        long l = date.getTime();
        long l2 = l % 1000L;
        if (l2 != 0L) {
            date.setTime(l - l2);
        }
    }

    public void setPercentComplete(Double d) {
        if (d == null) {
            d = new Double(0.0);
        } else {
            double d2 = d;
            if (d2 < 0.0) {
                d = new Double(0.0);
            } else if (d2 > 1.0) {
                d = new Double(1.0);
            }
        }
        super.setPercentComplete(d);
    }

    public double getProgress() {
        Double d = super.getPercentComplete();
        return d == null ? 0.0 : d;
    }

    public void setProgress(double d) {
        this.setPercentComplete(d);
    }

    public void setNodeContext(IContext iContext) {
        this.nodeContext = iContext;
    }

    public IContext getNodeContext() {
        return this.nodeContext;
    }

    public IGlobalContext getGlobalContext() {
        return this.nodeContext.getGlobalContext();
    }

    public boolean isReadeable() {
        return this.readable;
    }

    public void setReadeable(boolean bl) {
        this.readable = bl;
    }

    public long getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void setLastModificationTime(long l) {
        this.lastModificationTime = l;
    }

    public String toString() {
        return this.name;
    }

    public String dump() {
        int n = this.getVisibleSubtaskCount();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString());
        if (!this.isLeaf()) {
            stringBuilder.append("\n[\n");
            for (int i = 0; i < n; ++i) {
                TGNode tGNode = this.getVisibleSubtask(i);
                if (tGNode == null) {
                    stringBuilder.append("-UNEXPECTED NULL\n");
                    continue;
                }
                stringBuilder.append("-");
                stringBuilder.append(tGNode.dump());
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    public int getSubtaskCount() {
        return this.getVisibleSubtaskCount();
    }

    public TGNode getSubtask(int n) {
        return this.getVisibleSubtask(n);
    }

    public boolean isVisible() {
        return this.isReadeable() && !this.hiddenByFilter;
    }

    protected List<TGNode> getVisibleSubTasks() {
        int n = super.getSubtaskCount();
        ArrayList<TGNode> arrayList = new ArrayList<TGNode>(n);
        if (this.getGlobalContext().isEditable() && this.getGlobalContext().getFilter() == null) {
            for (int i = 0; i < n; ++i) {
                arrayList.add((TGNode)super.getSubtask(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                TGNode tGNode = (TGNode)super.getSubtask(i);
                if (!tGNode.isVisible()) continue;
                arrayList.add(tGNode);
            }
        }
        return arrayList;
    }

    public TGNode getVisibleSubtask(int n) {
        if (this.getGlobalContext().isEditable() && this.getGlobalContext().getFilter() == null) {
            return (TGNode)super.getSubtask(n);
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            TGNode tGNode;
            if ((tGNode = (TGNode)super.getSubtask(n3)).isVisible()) {
                if (n2 == n) {
                    return tGNode;
                }
                ++n2;
            }
            ++n3;
        }
    }

    public TGNode getLastVisibleSubtask() {
        for (int i = super.getSubtaskCount() - 1; i >= 0; --i) {
            TGNode tGNode = (TGNode)super.getSubtask(i);
            if (!tGNode.isVisible()) continue;
            return tGNode;
        }
        return null;
    }

    public int getVisibleSubtaskCount() {
        int n = super.getSubtaskCount();
        if (this.getGlobalContext().isEditable() && this.getGlobalContext().getFilter() == null) {
            return n;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TGNode tGNode = (TGNode)super.getSubtask(i);
            if (!tGNode.isVisible()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean hasVisibleSubtask() {
        int n = super.getSubtaskCount();
        if (this.getGlobalContext().isEditable() && this.getGlobalContext().getFilter() == null) {
            return n > 0;
        }
        for (int i = 0; i < n; ++i) {
            TGNode tGNode = (TGNode)super.getSubtask(i);
            if (!tGNode.isVisible()) continue;
            return true;
        }
        return false;
    }

    public int getAllSubTaskCount() {
        return super.getSubtaskCount();
    }

    public TGNode getSubtaskInAll(int n) {
        return (TGNode)super.getSubtask(n);
    }

    public boolean hasChildInAll(GanttNode ganttNode) {
        int n = this.getAllSubTaskCount();
        for (int i = 0; i < n; ++i) {
            if (this.getSubtaskInAll(i) != ganttNode) continue;
            return true;
        }
        return false;
    }

    public int getAllNonEmptySubTaskCount() {
        return super.getSubtaskCount();
    }

    public void setHiddenByFilter(boolean bl) {
        this.hiddenByFilter = bl;
    }

    public boolean isHiddenByFilter() {
        return this.hiddenByFilter;
    }

    public boolean isLeaf() {
        return this.getAllSubTaskCount() == 0;
    }

    public TGNode getParent() {
        return this.parentNode;
    }

    public void setParent(TGNode tGNode) {
        this.parentNode = tGNode;
    }

    public int getIndex(TGNode tGNode) {
        if (tGNode == null) {
            return -1;
        }
        List<TGNode> list = this.getVisibleSubTasks();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!tGNode.equals(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public Enumeration<TGNode> children() {
        List<TGNode> list = this.getVisibleSubTasks();
        return Collections.enumeration(list);
    }

    public int getSubId() {
        int n = this.hierarchicalId.lastIndexOf(46);
        if (n < 0) {
            return 1;
        }
        String string = this.hierarchicalId.substring(n + 1);
        return Integer.parseInt(string);
    }

    public int getLevel() {
        int n = 1;
        for (int i = 0; i < this.hierarchicalId.length(); ++i) {
            if (this.hierarchicalId.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    public TGNode clone() {
        try {
            TGNode tGNode = (TGNode)super.clone();
            TimePeriod timePeriod = this.getDuration();
            tGNode.setDuration((TimePeriod)new SimpleTimePeriod(timePeriod.getStart().getTime(), timePeriod.getEnd().getTime()));
            return tGNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported");
        }
    }
}

