/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttCategoryAxis;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GanttDateAxis;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTaskSeries;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.IGanttChart;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.NodeFilter;
import com.triloggroup.gantt.RedirectResponseException;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.event.GanttModelEvent;
import com.triloggroup.gantt.event.GanttModelListener;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.event.GanttModelSelectionListener;
import com.triloggroup.gantt.renderer.GanttNodeRenderer;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.time.DateRange;
import org.jfree.ui.RectangleInsets;

public abstract class TGChart
implements IGanttChart,
GanttModelSelectionListener,
GanttModelListener {
    public static final boolean HIDE_SUBPROJECT_LINK_NODE_IF_ROOT_LOADED = true;
    public static final Color OFF_DAY_COLOR = new Color(220, 220, 220);
    public static final double DEFAULT_CATEGORY_SIZE = 14.0;
    public static final double DEFAULT_CATEGORY_GAP_SIZE = 4.0;
    protected static final long MIN_INTERVAL_ALLOWED = 21600000L;
    protected static final long MAX_INTERVAL_ALLOWED = 3153600000000L;
    public static final String NLS_FILE_PATH = "com/triloggroup/gantt/resources/gantt";
    public static boolean isServerMode = true;
    protected Locale locale;
    protected TimeZone timeZone;
    protected Locale formatLocale;
    protected NLSBundle nlsBundle;
    protected GanttDateAxis dateAxis;
    protected Date displayStartDate = null;
    protected Date displayEndDate = null;
    protected JFreeChart chart;
    protected TGTreeTable treeTable;
    protected TGChartModel model;
    private static final boolean DEBUG = false;

    public TGChart(Locale locale, Locale locale2, TimeZone timeZone) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.formatLocale = locale2 == null ? this.locale : locale2;
        this.nlsBundle = this.createNLSBundle(locale);
    }

    protected TGChart() {
    }

    public void setModel(TGChartModel tGChartModel) throws GanttChartException {
        if (tGChartModel == null) {
            throw new GanttChartException(1, "Cannot set a null Gantt Model");
        }
        if (this.model != null) {
            this.model.removeSelectionListener(this);
            this.model.removeGanttModelListener(this);
        }
        this.model = tGChartModel;
        this.model.addSelectionListener(this);
        this.model.addGanttModelListener(this);
        this.displayStartDate = tGChartModel.getDataStartDate();
        this.displayEndDate = tGChartModel.getDataEndDate();
        this.initChart();
        this.initTreeTable();
    }

    public TGChartModel getModel() {
        return this.model;
    }

    protected NLSBundle createNLSBundle(Locale locale) {
        return NLSBundle.getBundle((String)NLS_FILE_PATH, (Locale)locale);
    }

    protected void initChart() {
        long l;
        GanttDataset ganttDataset = new GanttDataset();
        ganttDataset.add(this.createTaskSeries());
        this.model.setGanttDataset(ganttDataset);
        GanttCategoryAxis ganttCategoryAxis = new GanttCategoryAxis();
        ganttCategoryAxis.setVisible(false);
        this.dateAxis = new GanttDateAxis(this.formatLocale, this.timeZone);
        long l2 = this.displayStartDate.getTime();
        long l3 = this.displayEndDate.getTime();
        if (l3 != l2 && l3 - l2 < (l = 1209600000L)) {
            l3 = l2 + l;
        }
        this.setGraphDates(l2, l3);
        this.dateAxis.setFixedDimension(14.0);
        this.dateAxis.setTickMarksVisible(true);
        GanttNodeRenderer ganttNodeRenderer = new GanttNodeRenderer();
        ganttNodeRenderer.setBaseItemLabelsVisible(true);
        ganttNodeRenderer.setRenderPredecessorLinks(true);
        TGCategoryPlot tGCategoryPlot = this.createCategoryPlot(ganttDataset, ganttCategoryAxis, ganttNodeRenderer);
        tGCategoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        AxisSpace axisSpace = new AxisSpace();
        axisSpace.setTop(this.dateAxis.getFixedDimension());
        tGCategoryPlot.setFixedRangeAxisSpace(axisSpace);
        this.chart = new JFreeChart((Plot)tGCategoryPlot);
        this.chart.setBackgroundPaint((Paint)UIManager.getColor("TableHeader.background"));
        this.chart.removeLegend();
    }

    protected TGCategoryPlot createCategoryPlot(GanttDataset ganttDataset, CategoryAxis categoryAxis, GanttNodeRenderer ganttNodeRenderer) {
        return new TGCategoryPlot(this.model, (CategoryDataset)ganttDataset, categoryAxis, (ValueAxis)this.dateAxis, (CategoryItemRenderer)ganttNodeRenderer);
    }

    protected void initTreeTable() {
        TGTreeTableModel tGTreeTableModel = this.createTreeTableModel();
        this.createTreeTable(tGTreeTableModel);
        this.treeTable.setRowHeight(TGChart.getRowHeight());
        int n = this.treeTable.getPreferredWidth();
        this.treeTable.setSize(n, this.getPreferredHeight());
        this.treeTable.getTableHeader().setSize(n, this.treeTable.getRowHeight());
    }

    protected abstract TGTreeTableModel createTreeTableModel();

    protected abstract void createTreeTable(TGTreeTableModel var1);

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getDateLocale() {
        return this.formatLocale;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public TGTreeTable getTreeTable() {
        return this.treeTable;
    }

    public static int getRowHeight() {
        return 18;
    }

    public int getPreferredHeight() {
        return this.getPreferredHeightForEntries(this.model.getNbEntriesAcceptedByFilter());
    }

    public int getCurrentPreferredHeight() {
        return this.getPreferredHeightForEntries(this.chart.getCategoryPlot().getDataset().getColumnCount());
    }

    protected int getPreferredHeightForEntries(int n) {
        AxisSpace axisSpace = ((CategoryPlot)this.chart.getPlot()).getFixedRangeAxisSpace();
        RectangleInsets rectangleInsets = this.chart.getPlot().getInsets();
        return (int)((double)(n * TGChart.getRowHeight()) + axisSpace.getBottom() + axisSpace.getTop() + rectangleInsets.getTop() + rectangleInsets.getBottom());
    }

    public int getPeferredTreeTableWidth() {
        return this.getTreeTable().getPreferredWidth();
    }

    public void updateTableColumnOption(String[] stringArray) {
        this.treeTable.setVisibleColumns(stringArray);
        this.treeTable.setRowHeight(TGChart.getRowHeight());
    }

    public TGNode getNodeFromY(int n) {
        return this.getNodeFromY(n, 0);
    }

    public TGNode getNodeFromY(int n, int n2) {
        TaskSeries taskSeries;
        int n3 = this.getRowIndexFromY(n, n2);
        if (n3 >= 0 && n3 < (taskSeries = this.getTaskSeries()).getItemCount()) {
            return (TGNode)taskSeries.get(n3);
        }
        return null;
    }

    private int getRowIndexFromY(int n, int n2) {
        AxisSpace axisSpace = ((CategoryPlot)this.chart.getPlot()).getFixedRangeAxisSpace();
        RectangleInsets rectangleInsets = this.chart.getPlot().getInsets();
        int n3 = n2 == 0 ? (int)((double)n - axisSpace.getTop() - rectangleInsets.getTop()) : n + n2 * this.imgGetRowCountPerTile() * TGChart.getRowHeight();
        if (n3 < 0) {
            return -1;
        }
        int n4 = n3 / TGChart.getRowHeight();
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doDatesChangeCommand(String string, double d) throws Exception {
        long l = this.displayStartDate.getTime();
        long l2 = this.displayEndDate.getTime();
        long l3 = l2 - l;
        long l4 = this.model.getDataStartDate().getTime();
        long l5 = this.model.getDataEndDate().getTime();
        if (string.equalsIgnoreCase("center")) {
            l = l4;
            l2 = l5;
        } else if (string.equalsIgnoreCase("zoomIn")) {
            if (l3 <= 21600000L) return "";
            if (l + l3 / 2L < l4) {
                l += l3 / 2L;
            } else if (l2 - l3 / 2L > l5) {
                l2 -= l3 / 2L;
            } else {
                l += l3 / 4L;
                l2 -= l3 / 4L;
            }
        } else if (string.equalsIgnoreCase("zoomOut")) {
            if (l3 >= 3153600000000L) return "";
            l -= l3 / 2L;
            l2 += l3 / 2L;
        } else if (string.equalsIgnoreCase("previous")) {
            l -= l3 / 2L;
            if ((l2 -= l3 / 2L) < l4) {
                return "";
            }
        } else if (string.equalsIgnoreCase("next")) {
            l2 += l3 / 2L;
            if ((l += l3 / 2L) > l5) {
                return "";
            }
        } else if (string.equalsIgnoreCase("first")) {
            l = l4;
            l2 = l + l3;
            if (l2 < l4) {
                return "";
            }
        } else if (string.equalsIgnoreCase("last")) {
            l2 = l5;
            l = l2 - l3;
            if (l > l5) {
                return "";
            }
        } else if (string.equalsIgnoreCase("moveDate")) {
            if (d == 0.0) {
                return "";
            }
            long l6 = (long)((double)l3 * d);
            l += l6;
            l2 += l6;
        } else {
            if (!string.equalsIgnoreCase("today")) throw new Exception("Unknown Date command " + string);
            long l7 = this.model.getGlobalContext().getCurrentDate().getTime() - (l + l2) / 2L;
            l += l7;
            l2 += l7;
        }
        this.setGraphDates(l, l2);
        return "ok";
    }

    public Date getDisplayStartDate() {
        return this.displayStartDate;
    }

    public Date getDisplayEndDate() {
        return this.displayEndDate;
    }

    public void setGraphDates(long l, long l2) {
        if (l == l2) {
            l2 += 1209600000L;
        }
        this.displayStartDate = new Date(l);
        this.displayEndDate = new Date(l2);
        this.dateAxis.setRangeWithMargins((Range)new DateRange(this.displayStartDate, this.displayEndDate));
    }

    public void applyFilter(String string, String string2, String string3, String string4) {
        NodeFilter nodeFilter = new NodeFilter(string, string2, string3, string4);
        this.applyFilter(nodeFilter);
    }

    public void applyFilter(INodeFilter iNodeFilter) {
        this.model.setFilter(iNodeFilter);
    }

    public INodeFilter getFilter() {
        return this.model.getFilter();
    }

    public TGNode[] getSelectedNodes() {
        return this.getModel().getSelectedNodes();
    }

    public void setSelectedNode(TGNode tGNode) {
        TGNode[] tGNodeArray;
        if (tGNode == null) {
            tGNodeArray = null;
        } else {
            TGNode[] tGNodeArray2 = new TGNode[1];
            tGNodeArray = tGNodeArray2;
            tGNodeArray2[0] = tGNode;
        }
        this.setSelectedNodes(tGNodeArray);
    }

    public void setSelectedNodes(TGNode ... tGNodeArray) {
        if (tGNodeArray != null) {
            for (TGNode tGNode : tGNodeArray) {
                for (TGNode tGNode2 = tGNode.getParent(); tGNode2 != null; tGNode2 = tGNode2.getParent()) {
                    if (tGNode2.isExpanded()) continue;
                    this.expandNode(tGNode2);
                }
            }
        }
        this.model.setSelectedNodes(tGNodeArray);
    }

    public boolean isSelectedNode(TGNode tGNode) {
        return this.model.isSelectedNode(tGNode);
    }

    public void updateSelectionWithDocId(String string) {
        TGNode tGNode = this.model.getNodeByDocId(string);
        if (tGNode != null) {
            if (this.isSelectedNode(tGNode)) {
                this.setSelectedNode(null);
            }
            this.setSelectedNode(tGNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(GanttModelSelectionEvent ganttModelSelectionEvent) {
        if (this.treeTable.isIgnoreSelectionChange()) {
            return;
        }
        if (ganttModelSelectionEvent.getNewSelectionType() != 1) {
            if (ganttModelSelectionEvent.getOldSelectionType() == 1) {
                this.treeTable.getSelectionModel().clearSelection();
            }
            return;
        }
        Object[] objectArray = ganttModelSelectionEvent.getNewSelection();
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        if (objectArray == null || objectArray.length == 0) {
            listSelectionModel.setSelectionInterval(-1, -1);
        } else {
            int n;
            int[] nArray = new int[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                TGNode tGNode = (TGNode)objectArray[n];
                nArray[n] = this.getModel().getRowIndex(tGNode);
            }
            Arrays.sort(nArray);
            n = 0;
            try {
                int n2 = -1;
                int n3 = -1;
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    if (n4 == -1) continue;
                    if (n2 == -1) {
                        n2 = n3 = n4;
                        continue;
                    }
                    if (n4 == n3 + 1) {
                        n3 = n4;
                        continue;
                    }
                    if (n == 0) {
                        listSelectionModel.setValueIsAdjusting(true);
                        n = 1;
                        listSelectionModel.setSelectionInterval(n2, n3);
                    } else {
                        listSelectionModel.addSelectionInterval(n2, n3);
                    }
                    n2 = n3 = n4;
                }
                if (n2 != -1) {
                    if (n == 0) {
                        listSelectionModel.setSelectionInterval(n2, n3);
                    } else {
                        listSelectionModel.addSelectionInterval(n2, n3);
                    }
                }
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public boolean expandNode(TGNode tGNode) {
        return this.model.expandNode(tGNode);
    }

    public boolean collapseNode(TGNode tGNode) {
        return this.model.collapseNode(tGNode);
    }

    protected void expandNodeToLevelNoEvent(TGNode tGNode, int n) {
        if (tGNode != null) {
            if (n >= 0 && GanttNode.isHiddenSubprojectLink(tGNode)) {
                ++n;
            }
            if (n == 0) {
                tGNode.setExpanded(false);
            } else {
                tGNode.setExpanded(true);
                --n;
            }
            Enumeration<TGNode> enumeration = tGNode.children();
            while (enumeration.hasMoreElements()) {
                TGNode tGNode2 = enumeration.nextElement();
                if (tGNode2.isLeaf()) continue;
                this.expandNodeToLevelNoEvent(tGNode2, n);
            }
        }
    }

    public void sendDetailsPage(TGNode tGNode) throws RedirectResponseException {
        String string;
        if (tGNode != null && !UString.isEmpty((String)(string = this.getDetailsURL(tGNode)))) {
            throw new RedirectResponseException(string);
        }
    }

    protected String getDetailsURL(TGNode tGNode) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskSeries createTaskSeries() {
        GanttTaskSeries ganttTaskSeries = new GanttTaskSeries("");
        ganttTaskSeries.setNotify(false);
        try {
            this.addSubTaskToTaskSeries(this.model.getRootNode(), ganttTaskSeries);
            this.afterCreateTaskSeries(ganttTaskSeries);
        }
        finally {
            ganttTaskSeries.setNotify(true);
        }
        ganttTaskSeries.fireSeriesChanged();
        return ganttTaskSeries;
    }

    protected void afterCreateTaskSeries(TaskSeries taskSeries) {
    }

    protected void updateTaskSeries() {
        GanttDataset ganttDataset = (GanttDataset)this.chart.getCategoryPlot().getDataset();
        TaskSeries taskSeries = this.createTaskSeries();
        ganttDataset.setSeries(taskSeries, 0);
    }

    public TaskSeries getTaskSeries() {
        return ((GanttDataset)this.chart.getCategoryPlot().getDataset()).getSeries(0);
    }

    protected void addSubTaskToTaskSeries(TGNode tGNode, TaskSeries taskSeries) {
        if (!tGNode.isFakeRoot() && !GanttNode.isHiddenSubprojectLink(tGNode)) {
            taskSeries.add((Task)tGNode);
        }
        if (tGNode.hasVisibleSubtask() && tGNode.isExpanded()) {
            List<TGNode> list = tGNode.getVisibleSubTasks();
            for (int i = 0; i < list.size(); ++i) {
                TGNode tGNode2 = list.get(i);
                if (tGNode2.isLeaf()) {
                    taskSeries.add((Task)tGNode2);
                    continue;
                }
                this.addSubTaskToTaskSeries(tGNode2, taskSeries);
            }
        }
    }

    public void nodeCollapsed(GanttModelEvent ganttModelEvent) {
        if (ganttModelEvent.getFirstNode().hasVisibleSubtask()) {
            this.updateTaskSeries();
        }
        if (this.treeTable != null) {
            this.treeTable.nodeCollapsed();
        }
    }

    public void nodeExpanded(GanttModelEvent ganttModelEvent) {
        if (ganttModelEvent.getFirstNode().hasVisibleSubtask()) {
            this.updateTaskSeries();
        }
        if (this.treeTable != null) {
            this.treeTable.nodeExpanded();
        }
    }

    public void nodesChanged(GanttModelEvent ganttModelEvent) {
    }

    public void structureChanged(GanttModelEvent ganttModelEvent) {
        this.updateTaskSeries();
    }

    public void setChartGraphicsRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    protected BufferedImage imgCreateBufferedImage(int n, int n2, int n3) {
        return new BufferedImage(n, n2, 8);
    }

    protected int imgGetMinVisibleRows() {
        return 20;
    }

    protected int imgGetRowCountToShow() {
        return Math.max(this.chart.getCategoryPlot().getDataset().getColumnCount(), this.imgGetMinVisibleRows());
    }

    public int imgGetRowCountPerTile() {
        return 50;
    }

    public int imgGetTilesCount() {
        double d = this.imgGetRowCountToShow();
        return (int)Math.ceil(d / (double)this.imgGetRowCountPerTile());
    }

    public int imgGetTileForNode(TGNode tGNode) {
        CategoryDataset categoryDataset;
        int n;
        int n2 = -1;
        if (tGNode != null && (n = (categoryDataset = this.getChart().getCategoryPlot().getDataset()).getColumnIndex((Comparable)((Object)tGNode.getDescription()))) >= 0) {
            n2 = n / this.imgGetRowCountPerTile();
        }
        return n2;
    }

    public void imgWriteImageAsPNG(OutputStream outputStream, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = this.imgGetTilesCount();
        if (n2 >= n6) {
            throw new IllegalArgumentException("Invalid tile: " + n2 + " (tile count=" + n6 + ')');
        }
        AxisSpace axisSpace = ((CategoryPlot)this.chart.getPlot()).getFixedRangeAxisSpace();
        RectangleInsets rectangleInsets = this.chart.getPlot().getInsets();
        int n7 = (int)(axisSpace.getTop() + rectangleInsets.getTop());
        int n8 = (int)(axisSpace.getBottom() + rectangleInsets.getBottom());
        int n9 = TGChart.getRowHeight();
        int n10 = this.imgGetRowCountPerTile();
        int n11 = 0;
        if (n2 == 0) {
            n5 = 0;
            n11 += n7;
        } else {
            n5 = n7 + n10 * n2 * n9;
        }
        int n12 = this.imgGetRowCountToShow();
        if (n2 == n6 - 1) {
            n11 += n8;
            n4 = n12 % n10;
            if (n4 == 0) {
                n4 = n10;
            }
            n11 += n4 * n9;
        } else {
            n11 += n10 * n9;
        }
        n4 = n12 * n9 + n7 + n8;
        BufferedImage bufferedImage = this.imgCreateBufferedImage(n, n11, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n3 != 1) {
            this.setChartGraphicsRenderingHints(graphics2D);
        }
        graphics2D.translate(0, -n5);
        graphics2D.setClip(new Rectangle(0, n5, n, n11));
        if (n3 == 2) {
            this.imgDrawChart(graphics2D, n, n4);
        } else if (n3 == 1) {
            this.getTreeTable().setSize(n, n4);
            graphics2D.setPaint(Color.white);
            graphics2D.fillRect(0, 0, n, n11);
            this.getTreeTable().printAll(graphics2D, n, n4, true);
        } else if (n3 == 3) {
            int n13 = this.getTreeTable().getPreferredWidth();
            this.getTreeTable().setSize(n13, n4);
            graphics2D.setPaint(Color.white);
            graphics2D.fillRect(0, 0, n13, n11);
            this.getTreeTable().printAll(graphics2D, n13, n4, true);
            graphics2D.translate(n13, 0);
            this.imgDrawChart(graphics2D, n - n13, n4);
        }
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
    }

    private void imgDrawChart(Graphics2D graphics2D, int n, int n2) {
        this.chart.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, n, n2));
        graphics2D.setColor(UIConstants.GRID_COLOR);
        graphics2D.drawLine(0, 0, n - 1, 0);
        graphics2D.drawLine(0, 0, 0, TGChart.getRowHeight() - 1);
        graphics2D.drawLine(n - 1, 0, n - 1, TGChart.getRowHeight() - 1);
    }

    public static TGNode getUIParentNode(TGNode tGNode) {
        if (tGNode instanceof GanttWBS && ((GanttWBS)tGNode).isProjectRoot() && tGNode.getParent() != null) {
            tGNode = tGNode.getParent();
        }
        return tGNode.getParent();
    }
}

