/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.ChartModelUtil;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.NodeSetModel;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.loading.NodeData;
import com.triloggroup.gantt.util.GanttCalendarUtil;
import com.triloggroup.gantt.util.Intervals;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectModel
extends NodeSetModel {
    protected ProjectContext prjContext;
    private long cachedRangeStart = -1L;
    private long cachedRangeEnd = -1L;
    private Intervals cachedIntervals;
    protected HashMap<String, TGNode> wbsNodes;

    public ProjectModel(GlobalContext globalContext, String string) {
        super(globalContext);
        this.prjContext = this.createProjectContext(string);
    }

    public Collection<TGNode> getAllWBS() {
        return Collections.unmodifiableCollection(this.wbsNodes.values());
    }

    @Override
    protected void resetTaskSeriesForInit() {
        super.resetTaskSeriesForInit();
        this.wbsNodes = this.clearMap(this.wbsNodes);
    }

    public abstract ScheduleCalendar getProjectCalendar();

    protected ProjectContext createProjectContext(String string) {
        return new GanttProjectContext(this.globalContext, string);
    }

    public ProjectContext getProjectContext() {
        return this.prjContext;
    }

    public String getProjectId() {
        return this.getProjectContext().getProjectId();
    }

    @Override
    public GanttNode getNodeByUid(String string) {
        return (GanttNode)super.getNodeByUid(string);
    }

    public GanttWBS getWBSByHierarchicalId(String string) {
        if (UString.isEmpty((String)string)) {
            return null;
        }
        if (string.equals("1")) {
            return (GanttWBS)this.rootNode;
        }
        return (GanttWBS)this.wbsNodes.get(string);
    }

    public GanttNode getNodeByHierarchicalId(String string) {
        GanttNode ganttNode = (GanttNode)this.getRootNode();
        return this.getNodeByHierarchicalId(string, ganttNode);
    }

    private GanttNode getNodeByHierarchicalId(String string, GanttNode ganttNode) {
        if (string.equals(ganttNode.getHierarchicalId())) {
            return ganttNode;
        }
        int n = ganttNode.getAllSubTaskCount();
        for (int i = 0; i < n; ++i) {
            GanttNode ganttNode2;
            GanttNode ganttNode3 = ganttNode.getSubtaskInAll(i);
            if (!string.startsWith(ganttNode3.getHierarchicalId()) || (ganttNode2 = this.getNodeByHierarchicalId(string, ganttNode3)) == null) continue;
            return ganttNode2;
        }
        return null;
    }

    public GanttNode getNodeByLineId(int n) {
        GanttNode ganttNode = (GanttNode)this.getRootNode();
        return this.getNodeByLineId(n, ganttNode);
    }

    private GanttNode getNodeByLineId(int n, GanttNode ganttNode) {
        if (n == ganttNode.getLineId()) {
            return ganttNode;
        }
        int n2 = ganttNode.getAllSubTaskCount();
        for (int i = n2 - 1; i >= 0; --i) {
            GanttNode ganttNode2;
            GanttNode ganttNode3 = ganttNode.getSubtaskInAll(i);
            if (ganttNode3.getLineId() > n || (ganttNode2 = this.getNodeByLineId(n, ganttNode3)) == null) continue;
            return ganttNode2;
        }
        return null;
    }

    protected GanttNode createNode(Element element) throws XMLException {
        return ChartModelUtil.createGanttNode((NodeSetModel)this, element, this.prjContext);
    }

    protected GanttNode createNode(NodeData nodeData) {
        return ChartModelUtil.createGanttNode((NodeSetModel)this, nodeData, this.prjContext);
    }

    protected void updateNode(GanttNode ganttNode, Element element) throws XMLException {
        ChartModelUtil.updateGanttNode((NodeSetModel)this, ganttNode, element);
    }

    protected void updateNode(GanttNode ganttNode, NodeData nodeData) {
        ChartModelUtil.updateGanttNode((NodeSetModel)this, ganttNode, nodeData);
    }

    public Intervals getOffPeriods(long l, long l2) {
        if (this.cachedRangeStart != l || this.cachedRangeEnd != l2) {
            this.cachedRangeStart = l;
            this.cachedRangeEnd = l2;
            this.cachedIntervals = GanttCalendarUtil.getOffPeriods(this.getProjectCalendar(), l, l2);
        }
        return this.cachedIntervals;
    }
}

