/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.project.NameId;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.financial.FinancialComputation;
import com.triloggroup.project.schedule.SubprojectOptions;
import com.triloggroup.project.schedule.WBSComputation;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttWBS
extends GanttNode
implements WBSComputation.IWBS,
FinancialComputation.IFinancialWBS {
    public static final ObjectType TYPE = new ObjectType("wbs");
    private Resource[] resources = Resource.EMPTY_ARRAY;
    private double plannedProgress;
    private double projectedAdditionalCost;
    private double initiallyPlannedAdditionalCost;
    private double nodeActualAdditionalCost;
    private double computedWorkedHours;
    private double plannedWorkedHours;
    private NameId subProject;
    private SubprojectOptions subprojectOptions;
    private boolean hasSubTask;

    public static GanttWBS createFakeRoot() {
        Date date = new Date();
        GanttWBS ganttWBS = new GanttWBS(null, "1", "FakeRoot", "FakeRoot", date, date);
        ganttWBS.setExpanded(true);
        return ganttWBS;
    }

    public GanttWBS(String string, String string2, String string3, String string4, Date date, Date date2) {
        super(string, string2, string3, string4, date, date2);
    }

    @Override
    public double getWorkInHours() {
        return this.getWorkDisplay();
    }

    public void setWorkInHours(double d) {
        this.setWorkDisplay(d);
    }

    @Override
    public int getWorkFormat() {
        return 5;
    }

    @Override
    public void setWorkFormat(int n) {
        if (n != 0 && n != 5) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getDurationFormat() {
        return 7;
    }

    @Override
    public void setDurationFormat(int n) {
        if (n != 7) {
            throw new IllegalArgumentException();
        }
    }

    public void setDurationInDays(double d) {
        this.setDurationDisplay(d);
    }

    @Override
    public double getPlannedProgress() {
        return this.plannedProgress;
    }

    public void setPlannedProgress(double d) {
        this.plannedProgress = d;
    }

    public void setResources(Resource[] resourceArray) {
        this.resources = resourceArray;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public Resource[] getResourcesCopy() {
        if (this.resources == null || this.resources == Resource.EMPTY_ARRAY) {
            return this.resources;
        }
        Resource[] resourceArray = new Resource[this.resources.length];
        for (int i = 0; i < this.resources.length; ++i) {
            resourceArray[i] = this.resources[i];
        }
        return resourceArray;
    }

    @Override
    public void addSubtask(Task task) {
        if (task instanceof GanttNode) {
            this.addSubtaskAtCorrectPosition((GanttNode)task);
        } else {
            if (this.isSubProject() && task instanceof GanttWBS && !((GanttWBS)task).isProjectRoot()) {
                throw new IllegalStateException("Only root node can be added to subproject");
            }
            super.addSubtask(task);
        }
    }

    public void addSubtaskWithoutReorder(TGNode tGNode) {
        if (this.isSubProject() && tGNode instanceof GanttWBS && !((GanttWBS)tGNode).isProjectRoot()) {
            throw new IllegalStateException("Only root node can be added to subproject");
        }
        super.addSubtask(tGNode);
    }

    private void addSubtaskAtCorrectPosition(GanttNode ganttNode) {
        GanttNode ganttNode2;
        int n = ganttNode.getSubId();
        int n2 = this.getAllSubTaskCount();
        ArrayList<GanttNode> arrayList = null;
        for (int i = n2; i > 0 && ((ganttNode2 = this.getSubtaskInAll(i - 1)) instanceof EmptyNode || ganttNode2.getSubId() >= n); --i) {
            if (arrayList == null) {
                arrayList = new ArrayList<GanttNode>();
            }
            arrayList.add(ganttNode2);
            super.removeSubtask(ganttNode2);
        }
        super.addSubtask(ganttNode);
        ganttNode.setParent(this);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                super.addSubtask((Task)arrayList.get(i));
            }
        }
    }

    public ArrayList<TGNode> getAllChildrenAndSubChildren(boolean bl) {
        return this.getAllChildrenAndSubChildren(new ArrayList<TGNode>(), bl);
    }

    private ArrayList<TGNode> getAllChildrenAndSubChildren(ArrayList<TGNode> arrayList, boolean bl) {
        if (bl || !this.isSubProject()) {
            int n = this.getAllSubTaskCount();
            for (int i = 0; i < n; ++i) {
                GanttNode ganttNode = this.getSubtaskInAll(i);
                arrayList.add(ganttNode);
                if (!(ganttNode instanceof GanttWBS)) continue;
                ((GanttWBS)ganttNode).getAllChildrenAndSubChildren(arrayList, bl);
            }
        }
        return arrayList;
    }

    public GanttWBS copyWithoutChildren() {
        TimePeriod timePeriod = this.getDuration();
        GanttWBS ganttWBS = new GanttWBS(this.docId, this.getHierarchicalId(), this.name, this.getUid(), (Date)timePeriod.getStart().clone(), (Date)timePeriod.getEnd().clone());
        ganttWBS.hiddenByFilter = this.hiddenByFilter;
        ganttWBS.isExpanded = this.isExpanded;
        ganttWBS.lastModificationTime = this.lastModificationTime;
        ganttWBS.nodeContext = this.nodeContext;
        ganttWBS.parentNode = this.parentNode;
        ganttWBS.readable = this.readable;
        ganttWBS.durationDisplay = this.durationDisplay;
        ganttWBS.workDisplay = this.workDisplay;
        ganttWBS.nodeDescription = this.nodeDescription;
        if (this.resources != null) {
            ganttWBS.resources = this.getResourcesCopy();
        }
        if (this.subProject != null) {
            ganttWBS.subProject = this.subProject.clone();
        }
        if (this.subprojectOptions != null) {
            ganttWBS.subprojectOptions = this.subprojectOptions.clone();
        }
        return ganttWBS;
    }

    @Override
    public GanttWBS clone() {
        GanttWBS ganttWBS = (GanttWBS)super.clone();
        if (this.subProject != null) {
            ganttWBS.subProject = this.subProject.clone();
        }
        if (this.subprojectOptions != null) {
            ganttWBS.subprojectOptions = this.subprojectOptions.clone();
        }
        if (this.resources != null) {
            ganttWBS.resources = this.getResourcesCopy();
        }
        return ganttWBS;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean setExpanded(boolean bl) {
        if (bl && this.isSubProject() && !this.hasVisibleSubtask()) {
            return false;
        }
        return super.setExpanded(bl);
    }

    public NameId getSubProject() {
        return this.subProject;
    }

    public void setSubProject(NameId nameId) {
        this.subProject = nameId;
    }

    public boolean isSubProject() {
        return this.subProject != null;
    }

    public boolean isBrokenSubprojectLink() {
        if (this.subProject == null) {
            return false;
        }
        return UString.isEmpty((String)this.subProject.getName());
    }

    public void setSubprojectOptions(SubprojectOptions subprojectOptions) {
        this.subprojectOptions = subprojectOptions;
    }

    public SubprojectOptions getSubprojectOptions() {
        return this.subprojectOptions;
    }

    public String getSubprojectOptionsAsString() {
        return this.subprojectOptions == null ? "" : this.subprojectOptions.toString();
    }

    public void setDates(Date date, Date date2) {
        this.setDuration((Date)date.clone(), (Date)date2.clone());
    }

    public WBSComputation.IWBS getParentWBS() {
        return (WBSComputation.IWBS)this.getParent();
    }

    public void setHasChildren(boolean bl) {
    }

    public boolean hasSubTask() {
        return this.hasSubTask;
    }

    public void setHasSubTask(boolean bl) {
        this.hasSubTask = bl;
    }

    public Iterator allChildrenIterator() {
        return new Iterator<GanttNode>(){
            int nextIdx = 0;

            @Override
            public boolean hasNext() {
                return this.nextIdx < GanttWBS.this.getAllSubTaskCount();
            }

            @Override
            public GanttNode next() {
                if (this.hasNext()) {
                    return GanttWBS.this.getSubtaskInAll(this.nextIdx++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public double getComputedWorkedHours() {
        return this.computedWorkedHours;
    }

    public void setComputedWorkedHours(double d) {
        this.computedWorkedHours = d;
    }

    public double getPlannedWorkedHours() {
        return this.plannedWorkedHours;
    }

    public void setPlannedWorkedHours(double d) {
        this.plannedWorkedHours = d;
    }

    @Override
    public ObjectType getType() {
        return TYPE;
    }

    @Override
    public double getProjectedAdditionalCost() {
        return this.projectedAdditionalCost;
    }

    public void setProjectedAdditionalCost(double d) {
        this.projectedAdditionalCost = d;
    }

    @Override
    public double getInitiallyPlannedAdditionalCost() {
        return this.initiallyPlannedAdditionalCost;
    }

    public void setInitiallyPlannedAdditionalCost(double d) {
        this.initiallyPlannedAdditionalCost = d;
    }

    public double getNodeActualAdditionalCost() {
        return this.nodeActualAdditionalCost;
    }

    public void setNodeActualAdditionalCost(double d) {
        this.nodeActualAdditionalCost = d;
    }
}

