/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.project.ObjectRef;
import com.triloggroup.project.components.IdentifiableObject;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.WBSComputation;
import java.util.Date;

public abstract class GanttNode
extends TGNode
implements WBSComputation.INode,
IdentifiableObject {
    public static final String STATUS_DONE = "Done";
    public static final String STATUS_IN_PROGRESS = "In Progress";
    public static final String STATUS_PENDING = "Pending";
    public static final String STATUS_ABORTED = "Aborted";
    public static final int HEALTH_STATUS_UNKNOWN = -1;
    public static final int HEALTH_STATUS_DONE = 0;
    public static final int HEALTH_STATUS_ONSCHEDULE = 1;
    public static final int HEALTH_STATUS_WARNING = 2;
    public static final int HEALTH_STATUS_CRITICAL = 3;
    protected double durationDisplay;
    protected double workDisplay;
    private String status;
    private int lineId;
    private String fullLineId;
    private double additionalCost;
    private Double specifiedActualAdditionalCost;
    private String additionalCostDescription;
    public static final int MAX_ADDITIONAL_COST_DESCRIPTION_LENGTH = 512;
    private double actualAdditionalCost;
    private double actualResourceCost;
    private double projectedResourceCost;
    private double plannedResourceCost;
    private NodeSocialData socialData;

    public GanttNode(String string, String string2, String string3, String string4, Date date, Date date2) {
        super(string, string2, string3, string4, date, date2);
    }

    public ProjectContext getProjectContext() {
        return (ProjectContext)this.getNodeContext();
    }

    public String getSiteId() {
        return this.getGlobalContext().getSiteId();
    }

    public String getProjectId() {
        return this.getProjectContext().getProjectId();
    }

    public String getUid() {
        return super.getDescription();
    }

    public void setUid(String string) {
        super.setDescription(string);
    }

    public String getDescription() {
        return this.getProjectId() + '_' + this.getUid();
    }

    public void setDescription(String string) {
        throw new IllegalStateException("Can not update node key");
    }

    public int getLineId() {
        return this.lineId;
    }

    public void setLineId(int n) {
        this.lineId = n;
    }

    public String getFullLineId() {
        return this.fullLineId;
    }

    public void setFullLineId(String string) {
        this.fullLineId = string;
    }

    public GanttNode getSubtaskInAll(int n) {
        return (GanttNode)super.getSubtaskInAll(n);
    }

    public double getDurationDisplay() {
        return this.durationDisplay;
    }

    public void setDurationDisplay(double d) {
        this.durationDisplay = d;
    }

    public abstract int getDurationFormat();

    public abstract void setDurationFormat(int var1);

    public double getWorkDisplay() {
        return this.workDisplay;
    }

    public void setWorkDisplay(double d) {
        this.workDisplay = d;
    }

    public abstract int getWorkFormat();

    public abstract void setWorkFormat(int var1);

    public abstract double getWorkInHours();

    public String getLocalizedStatus() {
        return this.getGlobalContext().getNLSBundle().getString(this.status);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public boolean isProjectRoot() {
        return "1".equals(this.getHierarchicalId());
    }

    public boolean isSameProject(GanttNode ganttNode) {
        return this.getProjectContext() == ganttNode.getProjectContext();
    }

    public boolean isDone() {
        return STATUS_DONE.equals(this.status);
    }

    public boolean isInProgress() {
        return STATUS_IN_PROGRESS.equals(this.status);
    }

    public boolean isPending() {
        return STATUS_PENDING.equals(this.status);
    }

    public int getPercentage() {
        return (int)Math.round(this.getProgress() * 100.0);
    }

    public int getHealthStatus() {
        double d = this.getProgress();
        if (d == 1.0) {
            return 0;
        }
        if (this.nodeContext == null) {
            return 1;
        }
        Date date = this.getGlobalContext().getCurrentDate();
        if (this.getFinishDate().getTime() < date.getTime()) {
            return 3;
        }
        double d2 = this.getPlannedProgress();
        double d3 = d2 - d;
        if (d3 >= ((ProjectContext)this.nodeContext).getCriticalThreshold()) {
            return 3;
        }
        if (d3 > ((ProjectContext)this.nodeContext).getWarningThreshold()) {
            return 2;
        }
        return 1;
    }

    public int getFinancialHealthStatus() {
        double d;
        double d2;
        FinancialSettings financialSettings = null;
        ProjectContext projectContext = this.getProjectContext();
        if (projectContext instanceof GanttProjectContext) {
            financialSettings = ((GanttProjectContext)projectContext).getFinancialSettings();
        }
        if (financialSettings == null) {
            return -1;
        }
        double d3 = this.getProjectedResourceCost() + this.getProjectedAdditionalCost();
        if (d3 <= (d2 = this.getInitiallyPlannedResourceCost() + this.getInitiallyPlannedAdditionalCost())) {
            return 1;
        }
        if (d2 == 0.0) {
            return d3 > 0.0 ? 3 : 1;
        }
        if (d2 < 0.0) {
            if (d3 >= 0.0) {
                return 3;
            }
            d = d2 / d3 - 1.0;
        } else {
            d = d3 / d2 - 1.0;
        }
        if (d > financialSettings.getCriticalThreshold()) {
            return 3;
        }
        if (d > financialSettings.getWarningThreshold()) {
            return 2;
        }
        return 1;
    }

    public abstract double getPlannedProgress();

    public double getAdditionalCost() {
        return this.additionalCost;
    }

    public void setAdditionalCost(double d) {
        this.additionalCost = d;
    }

    public Double getSpecifiedActualAdditionalCost() {
        return this.specifiedActualAdditionalCost;
    }

    public void setSpecifiedActualAdditionalCost(Double d) {
        this.specifiedActualAdditionalCost = d;
    }

    public String getAdditionalCostDescription() {
        return this.additionalCostDescription;
    }

    public void setAdditionalCostDescription(String string) {
        if (string != null && string.length() > 512) {
            string = string.substring(0, 509) + "...";
        }
        this.additionalCostDescription = string;
    }

    public double getActualAdditionalCost() {
        return this.actualAdditionalCost;
    }

    public void setActualAdditionalCost(double d) {
        this.actualAdditionalCost = d;
    }

    public double getActualResourceCost() {
        return this.actualResourceCost;
    }

    public void setActualResourceCost(double d) {
        this.actualResourceCost = d;
    }

    public double getProjectedResourceCost() {
        return this.projectedResourceCost;
    }

    public void setProjectedResourceCost(double d) {
        this.projectedResourceCost = d;
    }

    public abstract double getProjectedAdditionalCost();

    public abstract double getInitiallyPlannedAdditionalCost();

    public void setInitiallyPlannedResourceCost(double d) {
        this.plannedResourceCost = d;
    }

    public double getInitiallyPlannedResourceCost() {
        return this.plannedResourceCost;
    }

    public boolean isRollupFinancialDataToMainProject() {
        GanttProjectContext ganttProjectContext = (GanttProjectContext)this.getProjectContext();
        if (ganttProjectContext.getFinancialSettings() == null) {
            return false;
        }
        if (GanttNode.isSubprojectLink(this) && !((GanttWBS)this).getSubprojectOptions().isFinancialRollup()) {
            return false;
        }
        GanttWBS ganttWBS = (GanttWBS)ganttProjectContext.getModel().getRootNode();
        while (ganttWBS != null && ganttWBS.getParent() != null) {
            GanttWBS ganttWBS2 = (GanttWBS)ganttWBS.getParent();
            if (!ganttWBS2.getSubprojectOptions().isFinancialRollup()) {
                return false;
            }
            ganttProjectContext = (GanttProjectContext)ganttWBS2.getProjectContext();
            if (ganttProjectContext.getFinancialSettings() == null) {
                return false;
            }
            ganttWBS = (GanttWBS)ganttProjectContext.getModel().getRootNode();
        }
        return true;
    }

    public NodeSocialData getSocialData() {
        if (this.socialData == null) {
            this.socialData = new NodeSocialData();
        }
        return this.socialData;
    }

    public GanttNode clone() {
        GanttNode ganttNode = (GanttNode)super.clone();
        ganttNode.socialData = null;
        return ganttNode;
    }

    public ObjectRef toObjectRef() {
        return new ObjectRef(this.getSiteId(), this.getProjectId(), this.getUid());
    }

    public static boolean isSubprojectLink(TGNode tGNode) {
        return tGNode instanceof GanttWBS && ((GanttWBS)tGNode).isSubProject();
    }

    public static boolean isLoadedSubprojectLink(TGNode tGNode) {
        return GanttNode.isSubprojectLink(tGNode) && tGNode.getAllSubTaskCount() > 0;
    }

    public static boolean isSubprojectLinkNotLoaded(TGNode tGNode) {
        return GanttNode.isSubprojectLink(tGNode) && tGNode.getAllSubTaskCount() == 0;
    }

    public static boolean isHiddenSubprojectLink(TGNode tGNode) {
        return GanttNode.isLoadedSubprojectLink(tGNode);
    }
}

