/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util.date;

import com.triloggroup.util.UString;
import com.triloggroup.util.date.TGDateFormat;
import com.triloggroup.util.date.TGDateTimeFormat;
import com.triloggroup.util.date.TGTime;
import com.triloggroup.util.date.TGTimeFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class UDateFormat {
    static final int MIN_YEAR = 1900;
    static final int MAX_YEAR = 2199;

    public static DateFormat getDateInstance(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            if (string.indexOf("yyyy") == -1) {
                string = UString.replaceAll(string, "yy", "yyyy");
            }
            dateFormat = new TGDateFormat(string, locale);
        } else {
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    public static DateFormat getDateTimeInstance(Locale locale) {
        return UDateFormat.getDateTimeInstance(locale, new TGTime(0, 0));
    }

    public static DateFormat getDateTimeInstance(Locale locale, TGTime tGTime) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            if (string.indexOf("yyyy") == -1) {
                string = UString.replaceAll(string, "yy", "yyyy");
            }
            DateFormat dateFormat2 = null;
            if (tGTime != null) {
                dateFormat2 = UDateFormat.getDateInstance(locale);
            }
            dateFormat = new TGDateTimeFormat(string, locale, dateFormat2, tGTime);
        } else {
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    public static DateFormat getTimeInstance(Locale locale) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            dateFormat = new TGTimeFormat(string, locale);
        } else {
            dateFormat.setLenient(false);
        }
        return dateFormat;
    }

    public static Date parseFullString(String string, DateFormat dateFormat) throws ParseException {
        if (UString.isEmpty(string)) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = dateFormat.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable date: \"" + string + "\"", parsePosition.getErrorIndex());
        }
        if (parsePosition.getIndex() != string.length()) {
            throw new ParseException("Unparseable date: (contains invalid characters at the end): \"" + string + "\"", parsePosition.getIndex());
        }
        return date;
    }
}

