/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util.date;

import com.triloggroup.util.date.TGTime;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TGDateTimeFormat
extends SimpleDateFormat {
    private TGTime defaultTime;
    private DateFormat dateOnlyformat;

    TGDateTimeFormat(String string, Locale locale, DateFormat dateFormat, TGTime tGTime) {
        super(string, locale);
        this.setLenient(false);
        this.dateOnlyformat = dateFormat;
        this.defaultTime = tGTime;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Date date = super.parse(string, parsePosition);
        if (date != null) {
            int n2 = this.calendar.get(1);
            if (n2 < 200) {
                this.calendar.set(1, n2 += 2000);
                date = this.calendar.getTime();
            }
            if (n2 < 1900 || n2 > 2199) {
                parsePosition.setErrorIndex(n);
                parsePosition.setIndex(n);
                return null;
            }
        } else if (this.dateOnlyformat != null) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n);
            date = this.dateOnlyformat.parse(string, parsePosition);
            if (date != null && this.defaultTime != null) {
                date = this.defaultTime.applyTime(date, this.getTimeZone());
            }
        }
        return date;
    }

    public void setDefaultTime(TGTime tGTime) {
        this.defaultTime = tGTime;
    }

    public TGTime getDefaultTime() {
        return this.defaultTime;
    }
}

