/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util;

import java.io.PrintWriter;

public class Message {
    protected static final int ERROR_LEVEL = 3;
    protected static final int WARNING_LEVEL = 2;
    protected static final int INFO_LEVEL = 1;
    protected static final int DEBUG_LEVEL = 0;
    public String text;
    public Throwable cause;
    public Object data;
    int level;

    protected Message(int n, String string) {
        this.level = n;
        this.text = string;
    }

    protected Message(int n, String string, Throwable throwable, Object object) {
        this.level = n;
        this.text = string;
        this.cause = throwable;
        this.data = object;
    }

    public static Message newError(String string) {
        return new Message(3, string);
    }

    public static Message newError(String string, Throwable throwable) {
        return new Message(3, string, throwable, null);
    }

    public static Message newWarning(String string) {
        return new Message(2, string);
    }

    public static Message newInfo(String string) {
        return new Message(1, string);
    }

    public static Message newDebug(String string) {
        return new Message(0, string);
    }

    public boolean isError() {
        return this.level == 3;
    }

    public boolean isWarning() {
        return this.level == 2;
    }

    public boolean isInfo() {
        return this.level == 1;
    }

    public boolean isDebug() {
        return this.level == 0;
    }

    public String getLevelName() {
        switch (this.level) {
            case 3: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Info";
            }
            case 0: {
                return "Debug";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append(this.getLevelName());
        stringBuffer.append(": ");
        stringBuffer.append(this.text);
        return stringBuffer;
    }

    void toVerboseString(PrintWriter printWriter) {
        printWriter.print(this.getLevelName());
        printWriter.print(": ");
        printWriter.print(this.text);
        if (this.cause != null) {
            printWriter.print("\n\tCause: ");
            this.cause.printStackTrace(printWriter);
        }
        if (this.data != null) {
            printWriter.print("\n\tData: ");
            printWriter.print(this.data);
        }
    }
}

