/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.ui;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;

public abstract class NumberTextField
extends JTextField {
    public static final String VALUE_PROPERTY = "Value";
    protected static Border INVALID_BORDER = BorderFactory.createLineBorder(Color.RED);
    private Border okBorder;
    protected NumberFormat format;
    private Number currentValue;
    private boolean valid;

    protected NumberTextField() {
        this.setHorizontalAlignment(4);
    }

    protected void init(NumberFormat numberFormat) {
        this.format = numberFormat;
        this.valid = true;
        this.setInputVerifier(new InputVerifier(){
            private ParseResult parseResult;

            public boolean verify(JComponent jComponent) {
                this.parseResult = NumberTextField.this.parse(NumberTextField.this.getText());
                return this.parseResult.valid;
            }

            public boolean shouldYieldFocus(JComponent jComponent) {
                if (!NumberTextField.this.isEditable()) {
                    return true;
                }
                this.verify(jComponent);
                return NumberTextField.this.shouldYieldFocus(this.parseResult);
            }
        });
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public boolean isGroupingUsed() {
        return this.format.isGroupingUsed();
    }

    public void setGroupingUsed(boolean bl) {
        this.format.setGroupingUsed(bl);
    }

    public boolean isEditValid() {
        return this.valid;
    }

    protected Number getNumberValue() {
        return this.valid ? (Number)this.currentValue : (Number)null;
    }

    protected void setNumberValue(Number number) {
        this.currentValue = number;
        this.valid = true;
        if (this.getBorder() == INVALID_BORDER) {
            this.setBorder(this.okBorder);
            this.setToolTipText(null);
            this.okBorder = null;
        }
        this.setText(number == null ? "" : this.format(number));
    }

    protected void setValueWithEvent(Number number) {
        Number number2 = this.currentValue;
        this.setNumberValue(number);
        if (number == null && number2 == null) {
            return;
        }
        if (number != null && number.equals(number2)) {
            return;
        }
        this.fireValueChange(number2, number);
    }

    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(VALUE_PROPERTY, propertyChangeListener);
    }

    protected void fireValueChange(Number number, Number number2) {
        this.firePropertyChange(VALUE_PROPERTY, number, number2);
    }

    protected abstract String format(Number var1);

    protected abstract ParseResult parse(String var1);

    protected boolean shouldYieldFocus(ParseResult parseResult) {
        if (parseResult.valid) {
            this.setValueWithEvent(parseResult.value);
            return true;
        }
        this.valid = false;
        if (this.getBorder() != INVALID_BORDER) {
            this.okBorder = this.getBorder();
            this.setBorder(INVALID_BORDER);
        }
        this.setToolTipText(parseResult.errorMessage);
        return false;
    }

    protected class ParseResult {
        public boolean valid;
        public Number value;
        public String errorMessage;

        protected ParseResult() {
        }
    }
}

