/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.ui;

import com.triloggroup.util.date.UDateFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DatePicker
extends JPanel {
    private JTextField dateField;
    private JTextField timeField;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private Date currentValue;

    public DatePicker() {
        this(null, null);
    }

    public DatePicker(Locale locale) {
        this(locale, null);
    }

    public DatePicker(Locale locale, TimeZone timeZone) {
        super(new BorderLayout(5, 5));
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.dateFormat = UDateFormat.getDateInstance(locale);
        this.dateFormat.setTimeZone(timeZone);
        this.timeFormat = UDateFormat.getTimeInstance(locale);
        this.timeFormat.setTimeZone(timeZone);
        this.dateField = new JTextField();
        this.dateField.setInputVerifier(new DateTextFieldVerifier());
        this.add((Component)this.dateField, "Center");
    }

    public boolean isShowTime() {
        return this.timeField != null;
    }

    public void setShowTime(boolean bl) {
        if (bl == this.isShowTime()) {
            return;
        }
        if (bl) {
            this.timeField = new JTextField();
            this.updateTimeFieldSize();
            this.timeField.setEditable(false);
            this.add((Component)this.timeField, "East");
        } else {
            this.remove(this.timeField);
            this.timeField = null;
        }
    }

    public void setDate(Date date) {
        this.currentValue = date;
        if (date == null) {
            this.dateField.setText("");
            if (this.timeField != null) {
                this.timeField.setText("");
            }
        } else {
            this.dateField.setText(this.dateFormat.format(date));
            if (this.timeField != null) {
                this.timeField.setText(this.timeFormat.format(date));
            }
        }
    }

    public Date getDate() {
        return this.currentValue;
    }

    public void setEditable(boolean bl) {
        this.dateField.setEditable(bl);
    }

    public boolean isEditable() {
        return this.dateField.isEditable();
    }

    private void updateTimeFieldSize() {
        Date date = new Date();
        date.setHours(22);
        int n = this.timeFormat.format(date).length();
        this.timeField.setColumns(n);
    }

    class DateTextFieldVerifier
    extends InputVerifier {
        DateTextFieldVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            ParsePosition parsePosition = new ParsePosition(0);
            DatePicker.this.currentValue = DatePicker.this.dateFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                DatePicker.this.currentValue = null;
                return false;
            }
            return true;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            if (this.verify(jComponent)) {
                if (DatePicker.this.currentValue != null) {
                    Calendar calendar = DatePicker.this.dateFormat.getCalendar();
                    int n = calendar.get(1);
                    if (n < 100) {
                        calendar.set(1, n + 2000);
                        DatePicker.this.currentValue = calendar.getTime();
                    }
                    DatePicker.this.dateField.setText(DatePicker.this.dateFormat.format(DatePicker.this.currentValue));
                }
                return true;
            }
            return false;
        }
    }
}

