/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.triloggroup.project.schedule.AbstractScheduleComputation;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.ITaskSummary;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.project.schedule.ScheduleCst;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBackwardScheduler {
    protected AbstractScheduleComputation scheduleComputation;
    protected ScheduleCalendar projectCalendar;
    protected Date projectEnd;

    protected AbstractBackwardScheduler(AbstractScheduleComputation abstractScheduleComputation) {
        this.scheduleComputation = abstractScheduleComputation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ITaskSummary> runBackwardPass() throws Exception {
        try {
            Iterator iterator;
            Object object;
            HashMap<String, ITaskSummary> hashMap = new HashMap<String, ITaskSummary>();
            this.initData(hashMap);
            HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (ITaskSummary object2 : hashMap.values()) {
                linkedHashSet.add(object2.getUid());
                object = object2.getPredecessors();
                if (object == null) continue;
                for (int list = 0; list < ((IPredecessor[])object).length; ++list) {
                    Object object3 = object[list];
                    ArrayList<String> arrayList = (ArrayList<String>)hashMap2.get(object3.getId());
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        hashMap2.put(object3.getId(), arrayList);
                    }
                    arrayList.add(object2.getUid());
                }
            }
            block5: while (!linkedHashSet.isEmpty()) {
                List list;
                iterator = linkedHashSet.iterator();
                String string = (String)iterator.next();
                object = hashMap.get(string);
                iterator.remove();
                if ("Done".equals(object.getStatus())) {
                    list = null;
                } else {
                    list = (List)hashMap2.get(object.getUid());
                    if (list != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            if (!linkedHashSet.contains(list.get(i))) continue;
                            linkedHashSet.add(string);
                            continue block5;
                        }
                    }
                }
                this.runBackwardPassForTask((ITaskSummary)object, list, hashMap);
            }
            iterator = hashMap;
            return iterator;
        }
        finally {
            this.clean();
        }
    }

    private void runBackwardPassForTask(ITaskSummary iTaskSummary, List list, HashMap hashMap) throws Exception {
        double d;
        Object object;
        Date date;
        if ("Done".equals(iTaskSummary.getStatus())) {
            date = iTaskSummary.getStartDate();
            object = iTaskSummary.getFinishDate();
            d = -99.0;
        } else {
            Object object2;
            int n;
            boolean bl = "In Progress".equals(iTaskSummary.getStatus());
            ScheduleCalendar scheduleCalendar = this.getTaskCalendar(iTaskSummary);
            ScheduleCalendar[] scheduleCalendarArray = this.getTaskUserCalendars(iTaskSummary, scheduleCalendar != null ? scheduleCalendar : this.projectCalendar);
            if (scheduleCalendarArray == null || scheduleCalendarArray.length == 0) {
                scheduleCalendarArray = new ScheduleCalendar[]{scheduleCalendar != null ? scheduleCalendar : this.projectCalendar};
            }
            date = null;
            object = this.projectEnd;
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    object2 = (String)list.get(n);
                    ITaskSummary iTaskSummary2 = (ITaskSummary)hashMap.get(object2);
                    IPredecessor iPredecessor = iTaskSummary2.getPredecessor(iTaskSummary.getUid());
                    int n2 = iPredecessor.getType();
                    if (bl && (n2 == 3 || n2 == 2)) continue;
                    Date date2 = n2 == 0 || n2 == 2 ? iTaskSummary2.getLateFinish() : iTaskSummary2.getLateStart();
                    int n3 = iPredecessor.getLag();
                    long l = 0L;
                    boolean bl2 = false;
                    if (n3 == 0) {
                        bl2 = true;
                    } else {
                        int n4 = iPredecessor.getLagFormat();
                        if (n4 != 19) {
                            l = this.getLagDurationMs(n3, n4);
                        } else {
                            double d2 = iTaskSummary.getDurationInHours();
                            l = (long)(d2 * (double)n3 * 3600.0 * 10.0);
                        }
                        if (ScheduleCst.isElapsedDurationFormat(n4)) {
                            date2 = new Date(date2.getTime() - l);
                            bl2 = true;
                        }
                    }
                    if (n2 == 1 || n2 == 0) {
                        if (!bl2) {
                            date2 = this.scheduleComputation.addDurationToGetEndDate(date2, -l, this.projectCalendar);
                        }
                        if (!date2.before((Date)object)) continue;
                        object = date2;
                        continue;
                    }
                    if (!bl2) {
                        date2 = this.scheduleComputation.addDurationToGetStartDate(date2, -l, this.projectCalendar);
                    }
                    if (date != null && !date2.before(date)) continue;
                    date = date2;
                }
            }
            if ((n = iTaskSummary.getSchedulingMode()) == 3 || n == 2) {
                object = CalendarUtil.getLastEndDate((Date)object, scheduleCalendarArray);
                if (iTaskSummary.getFinishDate().after((Date)object)) {
                    System.out.println("late finish is incorrect for task " + iTaskSummary.getUid());
                    d = 0.0;
                } else {
                    d = this.scheduleComputation.getDurationBetweenDates(iTaskSummary.getFinishDate(), (Date)object, this.projectCalendar);
                }
                if (date != null && d > 0.0) {
                    date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray);
                    if (iTaskSummary.getStartDate().after(date)) {
                        System.out.println("late start is incorrect for task " + iTaskSummary.getUid());
                        d = 0.0;
                    } else {
                        double d3 = this.scheduleComputation.getDurationBetweenDates(iTaskSummary.getStartDate(), date, this.projectCalendar);
                        if (d3 < d) {
                            d = d3;
                        }
                    }
                }
                date = iTaskSummary.getStartDate();
                object = iTaskSummary.getFinishDate();
            } else {
                double d4;
                double d5;
                if (date != null) {
                    object2 = (date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray)).equals(iTaskSummary.getStartDate()) ? iTaskSummary.getFinishDate() : this.computeFinishDateKnowingStartDate(iTaskSummary, n, date, this.projectCalendar, scheduleCalendar, scheduleCalendarArray);
                    if (((Date)object2).before((Date)object)) {
                        object = object2;
                    } else {
                        date = null;
                    }
                }
                object = CalendarUtil.getLastEndDate((Date)object, scheduleCalendarArray);
                if (bl || ((Date)object).equals(iTaskSummary.getFinishDate())) {
                    date = iTaskSummary.getStartDate();
                } else if (date == null) {
                    date = this.computeStartDateKnowingFinishDate(iTaskSummary, n, (Date)object, this.projectCalendar, scheduleCalendar, scheduleCalendarArray);
                }
                if (iTaskSummary.getFinishDate().after((Date)object)) {
                    System.out.println("late finish is incorrect for task " + iTaskSummary.getUid());
                    object = iTaskSummary.getFinishDate();
                    d5 = 0.0;
                } else {
                    d5 = this.scheduleComputation.getDurationBetweenDates(iTaskSummary.getFinishDate(), (Date)object, this.projectCalendar);
                }
                if (bl || iTaskSummary.getStartDate().equals(date)) {
                    d4 = 0.0;
                } else if (iTaskSummary.getStartDate().after(date)) {
                    System.out.println("late start is incorrect for task " + iTaskSummary.getUid());
                    date = iTaskSummary.getStartDate();
                    d4 = 0.0;
                } else {
                    d4 = this.scheduleComputation.getDurationBetweenDates(iTaskSummary.getStartDate(), date, this.projectCalendar);
                }
                double d6 = d = bl ? d5 : Math.min(d4, d5);
            }
            if (d == 0.0) {
                d = -1.0;
            }
        }
        iTaskSummary.setLateStart(date);
        iTaskSummary.setLateFinish((Date)object);
        iTaskSummary.setTotalSlack(d);
    }

    protected Date computeFinishDateKnowingStartDate(ITaskSummary iTaskSummary, int n, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        if (n == 0) {
            return this.scheduleComputation.calculateEndDateFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
        if (n == 1) {
            return this.scheduleComputation.calculateEndDateFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
        throw new IllegalStateException("Scheduling mode not supported: " + n);
    }

    protected Date computeStartDateKnowingFinishDate(ITaskSummary iTaskSummary, int n, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        if (n == 0) {
            return this.scheduleComputation.calculateStartDateFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
        if (n == 1) {
            return this.scheduleComputation.calculateStartDateFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
        throw new IllegalStateException("Scheduling mode not supported: " + n);
    }

    protected long getLagDurationMs(int n, int n2) throws Exception {
        return this.scheduleComputation.getDurationInMilliseconds(n, n2);
    }

    protected abstract ScheduleCalendar getTaskCalendar(ITaskSummary var1) throws Exception;

    protected abstract ScheduleCalendar[] getTaskUserCalendars(ITaskSummary var1, ScheduleCalendar var2) throws Exception;

    protected abstract void initData(Map<String, ITaskSummary> var1) throws Exception;

    protected void clean() {
    }
}

