/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.financial;

import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import java.util.Date;

public class CostRates {
    public ICostRate defaultCost;
    public VariableCost[] variableCosts;

    public CostRates(ICostRate iCostRate, VariableCost[] variableCostArray) {
        this.defaultCost = iCostRate;
        this.variableCosts = variableCostArray;
    }

    public boolean hasVariableCostRateDefined() {
        return this.variableCosts != null && this.variableCosts.length > 0;
    }

    public ICostRate getCostRate(Date date) {
        if (this.variableCosts != null) {
            for (int i = this.variableCosts.length - 1; i >= 0; --i) {
                if (date.before(this.variableCosts[i].from)) continue;
                return this.variableCosts[i].costRate;
            }
        }
        return this.defaultCost;
    }
}

