/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.UIConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class TGTableHeaderRenderer
extends DefaultTableCellRenderer {
    protected Border border;
    protected String textForTooltip;

    public TGTableHeaderRenderer(boolean bl) {
        this.setBorder(new TGHeaderBorder(bl));
        this.setForeground(Color.BLACK);
        this.setBackground(UIConstants.BACKGROUND_HEADER_COLOR);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setFont(UIConstants.DEFAULT_FONT);
        this.setValue(object);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
        Dimension dimension = this.ui.getPreferredSize(this);
        this.textForTooltip = dimension.width > tableColumn.getWidth() ? this.getText() : null;
        return this;
    }

    public String getToolTipText() {
        String string = super.getToolTipText();
        if (string != null) {
            return string;
        }
        return this.textForTooltip;
    }

    public static class TGHeaderBorder
    extends AbstractBorder {
        private boolean paintTop;

        public TGHeaderBorder(boolean bl) {
            this.paintTop = bl;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIConstants.GRID_COLOR);
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            graphics.drawLine(n5, n2, n5, n6);
            graphics.drawLine(n, n6, n5, n6);
            if (this.paintTop) {
                graphics.drawLine(n, n2, n5, n2);
            }
            graphics.setColor(Color.WHITE);
            int n7 = this.paintTop ? n2 + 1 : n2;
            graphics.drawLine(n, n7, n5 - 1, n7);
            graphics.drawLine(n, n2 + 1, n, n6 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(this.paintTop ? 2 : 1, 2, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.paintTop ? 2 : 1;
            insets.left = 2;
            insets.bottom = 1;
            insets.right = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

