/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.ListItemEditorDialog;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ListItemsEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JLabel lb;
    protected String title;
    protected Object[] allValues;
    protected Object[] currentValue;
    private int clickCountToStart = 1;
    private boolean allowSelectValueNotInAllValues = false;

    public ListItemsEditor(Object[] objectArray) {
        this.allValues = objectArray;
        this.lb = new JLabel();
        this.lb.setFocusable(true);
        this.lb.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ListItemsEditor.this.showDialog();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.lb.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ListItemsEditor.this.showDialog();
            }
        });
        this.lb.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ListItemsEditor.this.showDialog();
            }
        });
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAllowSelectValueNotInAllValues(boolean bl) {
        this.allowSelectValueNotInAllValues = bl;
    }

    public boolean isAllowSelectValueNotInAllValues() {
        return this.allowSelectValueNotInAllValues;
    }

    protected void showDialog() {
        ListItemEditorDialog listItemEditorDialog = ListItemEditorDialog.create(this);
        listItemEditorDialog.init();
        listItemEditorDialog.ensureMinMaxSize(this.lb.getWidth(), -1, -1, 600);
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.lb);
        listItemEditorDialog.setLocation(point);
        listItemEditorDialog.setVisibleDisableMouseEvents(500L);
        this.currentValue = listItemEditorDialog.getSelectedValue();
        if (this.currentValue == null) {
            this.cancelCellEditing();
        } else {
            this.stopCellEditing();
        }
    }

    public Object getCellEditorValue() {
        return this.currentValue;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == this.clickCountToStart;
        }
        if (eventObject instanceof KeyEvent) {
            return TextCellEditor.isKeyEventTriggerEdit((KeyEvent)eventObject);
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentValue = object != null && !object.getClass().isArray() ? new Object[]{object} : (Object[])object;
        return this.lb;
    }
}

