/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.TextCellEditor;
import com.triloggroup.project.components.util.format.TGDecimalFormat;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.JTable;

public class DoubleCellEditor
extends TextCellEditor {
    protected Double value;
    protected double minValue;
    protected double maxValue;
    protected DecimalFormat format;

    public DoubleCellEditor(Locale locale) {
        this(locale, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleCellEditor(Locale locale, boolean bl) {
        this(locale, bl ? 0.0 : Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleCellEditor(Locale locale, double d, double d2) {
        this(TGDecimalFormat.getTGInstance(locale), d, d2);
    }

    public DoubleCellEditor(DecimalFormat decimalFormat) {
        this(decimalFormat, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleCellEditor(DecimalFormat decimalFormat, double d, double d2) {
        this.getTextComponent().setHorizontalAlignment(4);
        this.format = decimalFormat;
        this.minValue = d;
        this.maxValue = d2;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        return object == null ? "" : this.format.format(object);
    }

    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        try {
            Number number = TGDecimalFormat.parseFullString(string, this.format);
            if (number == null) {
                this.value = null;
            } else {
                double d = number.doubleValue();
                if (d < this.minValue || d > this.maxValue) {
                    this.value = null;
                    this.getTextComponent().setBorder(ERROR_BORDER);
                    return false;
                }
                this.value = number instanceof Double ? (Double)number : new Double(d);
            }
        }
        catch (Exception exception) {
            this.getTextComponent().setBorder(ERROR_BORDER);
            return false;
        }
        return super.stopCellEditing();
    }
}

