/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import com.triloggroup.project.components.ui.IView;
import com.triloggroup.project.components.ui.ToolBarPanel;
import com.triloggroup.project.components.ui.WDSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class WorkbenchPage {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    protected JPanel mainPanel;
    protected ToolBarPanel header;
    private WDSplitPane body;
    protected IView activeView = null;
    private IView[] views = new IView[2];
    private HashMap<JComponent, IView> componentsToViews = new HashMap();

    public WorkbenchPage() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.body = new WDSplitPane(0);
        this.body.setOneTouchExpandable(true);
        this.body.setDefaultDividerProportional(0.7);
        this.body.setResizeWeight(0.7);
        this.mainPanel.add((Component)this.body, "Center");
        this.header = new ToolBarPanel();
        this.mainPanel.add((Component)this.header, "North");
        FocusManager.getCurrentManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkbenchPage.this.setUserActive(true);
                if (propertyChangeEvent.getPropertyName().equals("permanentFocusOwner")) {
                    for (Component component = (Component)propertyChangeEvent.getNewValue(); component != null; component = component.getParent()) {
                        IView iView = (IView)WorkbenchPage.this.componentsToViews.get(component);
                        if (iView == null) continue;
                        WorkbenchPage.this.setActiveView(iView);
                        return;
                    }
                    if (propertyChangeEvent.getNewValue() instanceof Container && ((Container)propertyChangeEvent.getNewValue()).isAncestorOf(WorkbenchPage.this.mainPanel) && WorkbenchPage.this.getActiveView() != null && WorkbenchPage.this.getActiveView().getMainFocusableComponent() != null) {
                        WorkbenchPage.this.getActiveView().getMainFocusableComponent().requestFocus();
                    }
                }
            }
        });
        this.mainPanel.setFocusCycleRoot(true);
        this.mainPanel.setFocusTraversalPolicy(new PageFocusTraversalPolicy());
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void addView(IView iView, int n) {
        iView.setWorkbenchPage(this);
        this.views[n] = iView;
        this.componentsToViews.put(iView.getComponent(), iView);
        if (n == 0) {
            this.body.setTopComponent(iView.getComponent());
        } else if (n == 1) {
            this.body.setBottomComponent(iView.getComponent());
        } else {
            throw new IllegalArgumentException("Invalid location: " + n);
        }
        iView.activeStateChanged(false);
    }

    public void setViewState(IView iView, IView.ViewState viewState) {
        if (viewState == IView.STATE_MAXIMIZED) {
            this.minimizeView(iView == this.views[0] ? this.views[1] : this.views[0]);
        } else if (viewState == IView.STATE_MINIMIZED) {
            this.minimizeView(iView);
        }
    }

    private void minimizeView(IView iView) {
        int n = iView.getComponent().getMinimumSize().height;
        if (iView == this.views[0]) {
            this.body.setDividerLocation(n);
            this.body.setResizeWeight(0.0);
        } else {
            this.body.setDividerLocation(this.body.getHeight() - n - this.body.getDividerSize());
            this.body.setResizeWeight(1.0);
        }
    }

    public void setActiveView(IView iView) {
        if (iView == this.activeView) {
            return;
        }
        if (this.activeView != null) {
            this.activeView.activeStateChanged(false);
        }
        this.activeView = iView;
        if (this.activeView != null) {
            this.activeView.activeStateChanged(true);
        }
        this.header.setLeftItems2(iView == null ? null : iView.getToolBarItems());
    }

    public IView getActiveView() {
        return this.activeView;
    }

    public void setUserActive(boolean bl) {
    }

    public abstract boolean stopEditInProgress(boolean var1);

    private class PageFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PageFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            JComponent jComponent;
            Component component2 = this.getFocusableComponent(0);
            Component component3 = this.getFocusableComponent(1);
            if (component == component2) {
                return component3;
            }
            if (component == component3) {
                return component2;
            }
            JComponent jComponent2 = jComponent = WorkbenchPage.this.activeView == null ? null : WorkbenchPage.this.activeView.getMainFocusableComponent();
            if (component == jComponent) {
                return WorkbenchPage.this.activeView == WorkbenchPage.this.views[0] ? component3 : component2;
            }
            return jComponent;
        }

        public Component getComponentBefore(Container container, Component component) {
            return this.getComponentAfter(container, component);
        }

        public Component getDefaultComponent(Container container) {
            return this.getFocusableComponent(0);
        }

        public Component getFirstComponent(Container container) {
            return this.getFocusableComponent(0);
        }

        public Component getLastComponent(Container container) {
            return this.getFocusableComponent(1);
        }

        private Component getFocusableComponent(int n) {
            if (WorkbenchPage.this.views[n] == null) {
                return null;
            }
            return WorkbenchPage.this.views[n].getMainFocusableComponent();
        }
    }
}

