/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import com.triloggroup.gantt.pe.PETimeUnits;
import com.triloggroup.pe.util.StringValidationUtil;
import com.triloggroup.util.NLSBundle;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class Workbench {
    private static Workbench instance = new Workbench();
    private NLSBundle nlsBundle;
    private PETimeUnits timeUnits;
    private TimeZone timezone;
    private Locale locale;
    private Locale formatLocale;
    private HashMap<String, Object> properties;

    public static Workbench get() {
        return instance;
    }

    private Workbench() {
    }

    public void setNLSBundle(NLSBundle nLSBundle) {
        this.nlsBundle = nLSBundle;
        this.timeUnits = new PETimeUnits(this.nlsBundle);
    }

    public NLSBundle getNLSBundle() {
        return this.nlsBundle;
    }

    public static String getNLSString(String string, Object ... objectArray) {
        if (Workbench.instance.nlsBundle != null) {
            return Workbench.instance.nlsBundle.getString(string, objectArray);
        }
        return string;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.formatLocale == null) {
            this.formatLocale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public void setFormatLocale(Locale locale) {
        this.formatLocale = locale;
    }

    public Locale getFormatLocale() {
        return this.formatLocale == null ? Locale.getDefault() : this.formatLocale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timezone == null ? TimeZone.getDefault() : this.timezone;
    }

    public PETimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public void addProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public String getStringProperty(String string) {
        return (String)this.getProperty(string);
    }

    public boolean getBooleanProperty(String string) {
        return Boolean.parseBoolean((String)this.getProperty(string));
    }

    public static String checkInvalidCharacters(String string) {
        if (StringValidationUtil.isStringValid(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Workbench.getNLSString("invalidCharacters", new Object[0]));
        char[] cArray = StringValidationUtil.getForbiddenChars();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuilder.append(i == 0 ? " " : ", ");
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }
}

