/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.schedulecalendar;

import com.triloggroup.project.components.schedulecalendar.CalendarTable;
import com.triloggroup.project.components.schedulecalendar.CalendarTableModel;
import com.triloggroup.project.schedule.ScheduleCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScheduleCalendarEditor {
    protected CalendarTable table;
    protected CalendarTableModel model;
    protected DateFormatSymbols dfSymbols;
    protected JPanel mainPanel;
    protected JLabel lbCurrentMonth;

    public ScheduleCalendarEditor(Locale locale) {
        this.dfSymbols = new DateFormatSymbols(locale);
        this.model = new CalendarTableModel(locale, this.dfSymbols);
        this.table = new CalendarTable(this.model, locale);
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        this.lbCurrentMonth = new JLabel();
        jPanel.add(new ChangeDateButton(" << ", 1, -1));
        jPanel.add(new ChangeDateButton("  <  ", 2, -1));
        jPanel.add(this.lbCurrentMonth);
        jPanel.add(new ChangeDateButton("  >  ", 2, 1));
        jPanel.add(new ChangeDateButton(" >> ", 1, 1));
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.table, "Center");
        this.updateLabel();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setScheduleCalendar(ScheduleCalendar scheduleCalendar) {
        this.model.setScheduleCalendar(scheduleCalendar);
    }

    protected void updateLabel() {
        String string = this.dfSymbols.getMonths()[this.model.getMonth0Based()];
        this.lbCurrentMonth.setText(string + ' ' + this.model.getYear());
    }

    private class ChangeDateButton
    extends JButton
    implements ActionListener {
        private int field;
        private int amount;

        ChangeDateButton(String string, int n, int n2) {
            super(string);
            this.field = n;
            this.amount = n2;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScheduleCalendarEditor.this.model.changeDate(this.field, this.amount);
            ScheduleCalendarEditor.this.updateLabel();
        }
    }
}

