/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.schedulecalendar;

import com.triloggroup.project.components.schedulecalendar.DayData;
import com.triloggroup.project.schedule.ScheduleCalendar;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;

class CalendarTableModel
extends AbstractTableModel {
    private Calendar calendar;
    private DayData[] currentMonth;
    private String[] weekDayLabels;
    private int offset;
    private ScheduleCalendar scheduleCalendar;
    private boolean editable = false;

    public CalendarTableModel(Locale locale, DateFormatSymbols dateFormatSymbols) {
        this.calendar = Calendar.getInstance(locale);
        this.calendar.set(5, 1);
        this.weekDayLabels = dateFormatSymbols.getWeekdays();
        this.update();
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth1Based() {
        return this.getMonth0Based() + 1;
    }

    public int getMonth0Based() {
        return this.calendar.get(2);
    }

    public void changeDate(int n, int n2) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("Invalid field: " + n);
        }
        this.calendar.add(n, n2);
        this.update();
    }

    public ScheduleCalendar getScheduleCalendar() {
        return this.scheduleCalendar;
    }

    public void setScheduleCalendar(ScheduleCalendar scheduleCalendar) {
        this.scheduleCalendar = scheduleCalendar;
        this.update();
    }

    protected void update() {
        int n = this.calendar.getActualMaximum(5);
        this.currentMonth = new DayData[n];
        ArrayList<ScheduleCalendar.ExceptionWeekday> arrayList = this.scheduleCalendar != null ? this.scheduleCalendar.getExceptionWeekDays() : null;
        for (int i = 0; i < n; ++i) {
            DayData dayData = new DayData(i + 1);
            if (this.scheduleCalendar != null) {
                ScheduleCalendar.Weekday weekday;
                int n2;
                Date date = this.calendar.getTime();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    weekday = arrayList.get(n2);
                    if (date.compareTo(weekday.period.fromDate) < 0 || date.compareTo(weekday.period.toDate) > 0) continue;
                    if (weekday.isDayWorking) {
                        dayData.workingTimes = weekday.workingTimes;
                    }
                    dayData.edited = true;
                    break;
                }
                if (!dayData.edited && (weekday = this.scheduleCalendar.getWeekdayAt(n2 = this.calendar.get(7) - 1)) != null && weekday.isDayWorking) {
                    dayData.workingTimes = weekday.workingTimes;
                }
                this.calendar.add(5, 1);
            }
            this.currentMonth[i] = dayData;
        }
        if (this.scheduleCalendar != null) {
            this.calendar.add(5, -n);
        }
        this.offset = (this.calendar.get(7) - this.calendar.getFirstDayOfWeek() + 7) % 7;
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.editable ? 8 : 7;
    }

    public int getRowCount() {
        return 1 + (int)Math.ceil((double)(this.currentMonth.length + this.offset) / 7.0);
    }

    public Object getValueAt(int n, int n2) {
        int n3;
        if (this.editable) {
            if (n2 == 0) {
                return n == 0 ? null : ">>";
            }
            --n2;
        }
        if (n == 0) {
            int n4 = n2 + this.calendar.getFirstDayOfWeek();
            if (n4 > 7) {
                n4 -= 7;
            }
            return this.weekDayLabels[n4];
        }
        if ((n3 = n2 - this.offset + --n * 7) < 0 || n3 >= this.currentMonth.length) {
            return null;
        }
        return this.currentMonth[n3];
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.fireTableStructureChanged();
    }
}

