/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.table.CategorizationBorder;
import com.triloggroup.project.components.resourceeditor.table.ITableItem;
import com.triloggroup.project.components.resourceeditor.table.ResourceTableModel;
import com.triloggroup.project.components.ui.DoubleIcon;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class NameRenderer
extends TGTableCellRenderer {
    private static boolean SHOW_ENABLED_DISABLED_ICON = true;
    private static final Icon registeredIcon;
    private static final Icon unregisteredIcon;
    private static final Icon unregisteredLiveIcon;
    private static final Icon enabledIcon;
    private static final Icon disabledIcon;
    private CategorizationBorder border = new CategorizationBorder();
    private ProjectResource currentResource;
    private static final String UNREGISTERED_LL_DN_SUFFIX = ",cn=live,cn=users,dc=unregistered,dc=com";

    public NameRenderer() {
        super.setBorder(this.border);
    }

    public void setBorder(Border border) {
        if (this.border != null) {
            Color color = null;
            if (border instanceof LineBorder) {
                color = ((LineBorder)border).getLineColor();
            }
            this.border.setOutlineColor(color);
        }
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        ResourceTableModel resourceTableModel = (ResourceTableModel)jTable.getModel();
        ITableItem iTableItem = resourceTableModel.getItemAtRow(n);
        this.border.setItem(iTableItem);
        if (iTableItem.isLeaf()) {
            this.currentResource = (ProjectResource)iTableItem.getValue();
            if (this.currentResource == null) {
                this.setIcon(null);
            } else {
                Object object2;
                Icon icon;
                Icon icon2 = this.currentResource.isRegistered() ? registeredIcon : (icon = this.isUnregisteredLive(this.currentResource) ? unregisteredLiveIcon : unregisteredIcon);
                if (SHOW_ENABLED_DISABLED_ICON) {
                    object2 = this.currentResource.isEnabled() ? enabledIcon : disabledIcon;
                    this.setIcon(new DoubleIcon(new Icon[]{object2, icon}));
                } else {
                    this.setIcon(icon);
                }
                object2 = resourceTableModel.view.getWorkbenchPage();
                UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode = ((GanttWorkbenchPage)object2).getUserPreferences().getHighlightOverallocationsMode();
                if (highlightOverallocationsMode == UserPreferences.HighlightOverallocationsMode.PROJECT) {
                    boolean bl3 = resourceTableModel.view.getProjectModel().isResourceOverAllocated(this.currentResource);
                    this.setForeground(bl3 ? Color.RED : Color.BLACK);
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
        } else {
            this.currentResource = null;
            this.setIcon(null);
        }
        return this;
    }

    public int getXTextOffset(ITableItem iTableItem) {
        if (iTableItem == null || !iTableItem.isLeaf()) {
            return 1;
        }
        ProjectResource projectResource = (ProjectResource)iTableItem.getValue();
        if (projectResource == null) {
            return 1;
        }
        int n = registeredIcon.getIconWidth();
        if (SHOW_ENABLED_DISABLED_ICON) {
            n += enabledIcon.getIconWidth();
        }
        n += this.getIconTextGap();
        ++n;
        if (iTableItem.getParent() != null) {
            n += 20;
        }
        return n;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.currentResource != null) {
            int n;
            int n2 = mouseEvent.getX();
            if (n2 < (n = this.border.getBorderInsets((Component)this).left)) {
                return null;
            }
            if (SHOW_ENABLED_DISABLED_ICON && n2 < (n += enabledIcon.getIconWidth())) {
                return Workbench.getNLSString(this.currentResource.isEnabled() ? "enabled" : "disabled", new Object[0]);
            }
            if (n2 < (n += registeredIcon.getIconWidth())) {
                return Workbench.getNLSString(this.currentResource.isRegistered() ? "registered" : (this.isUnregisteredLive(this.currentResource) ? "unregisteredLive" : "unregistered"), new Object[0]);
            }
        }
        return null;
    }

    private boolean isUnregisteredLive(ProjectResource projectResource) {
        if (projectResource.isRegistered()) {
            return false;
        }
        return projectResource.getDn().endsWith(UNREGISTERED_LL_DN_SUFFIX);
    }

    static {
        Class<NameRenderer> clazz = NameRenderer.class;
        registeredIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/app/resources/registereduser.gif"));
        unregisteredIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/app/resources/unregistereduser.gif"));
        unregisteredLiveIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/app/resources/unregisteredliveuser.gif"));
        enabledIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/app/resources/enabled.png"));
        disabledIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/app/resources/disabled.gif"));
    }
}

