/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.invitation;

import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdom.Element;

public class InvitationDialog
extends WDDialog
implements ActionListener {
    private WDButton okButton;
    private JTextArea messageTA;
    private JLabel usersLabel;
    private ProjectResource[] resources;
    private ResourceView view;

    public static void show(Component component, ProjectResource[] projectResourceArray, ResourceView resourceView) {
        Window window = (component = WDDialog.adjustParentComponent(component)) == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        InvitationDialog invitationDialog = new InvitationDialog(window, graphicsConfiguration);
        invitationDialog.view = resourceView;
        invitationDialog.setResources(projectResourceArray);
        invitationDialog.setLocationRelativeTo(component);
        invitationDialog.setVisible(true);
    }

    protected InvitationDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.init();
    }

    private void init() {
        this.setDragHeader(true);
        this.setResizable(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        this.okButton.setText(Workbench.getNLSString("send", new Object[0]));
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel2.add(wDButton);
        wDButton.addActionListener(this);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(Workbench.getNLSString("inviteTitle", new Object[0]) + ':'), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.usersLabel = new JLabel();
        jPanel.add((Component)this.usersLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel.add((Component)new JLabel(Workbench.getNLSString("inviteMessage", new Object[0]) + ':'), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        JLabel jLabel = new JLabel(Workbench.getNLSString("inviteMessageHelp", new Object[0]));
        ImageIcon imageIcon = WDUtil.getIcon("UserAssistance.gif");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setVerticalTextPosition(1);
        }
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.messageTA = new JTextArea();
        this.messageTA.setWrapStyleWord(true);
        this.messageTA.setLineWrap(true);
        Border border = this.messageTA.getBorder();
        this.messageTA.setBorder(null);
        JScrollPane jScrollPane = new JScrollPane(this.messageTA);
        jScrollPane.setBorder(border);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add(jPanel);
        this.setMinimumSize(new Dimension(400, 250));
    }

    public void setResources(ProjectResource[] projectResourceArray) {
        this.resources = projectResourceArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (int i = 0; i < projectResourceArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(WDUtil.swingHtmlEscape(projectResourceArray[i].getCn()));
        }
        stringBuilder.append("</html>");
        this.usersLabel.setText(stringBuilder.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.sendInvitations(false);
        } else {
            this.dispose();
        }
    }

    private void sendInvitations(final boolean bl) {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                Element element = InvitationDialog.this.view.getWSHelper().sendInvitations(InvitationDialog.this.resources, InvitationDialog.this.messageTA.getText(), bl);
                String[] stringArray = new String[InvitationDialog.this.resources.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = InvitationDialog.this.resources[i].getDn();
                }
                InvitationDialog.this.view.getProjectModel().refreshResourcesFromServer(stringArray);
                return element;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                Element element;
                if (throwable != null) {
                    throwable.printStackTrace();
                    WDDialog.showErrorMsgDialog(InvitationDialog.this, throwable);
                    return;
                }
                Element element2 = element = object != null ? ((Element)object).getChild("result") : null;
                if (element == null) {
                    System.out.println("sendInvitations did not return data");
                } else {
                    String string = element.getChildText("status");
                    if (!"ok".equals(string)) {
                        if ("warning".equals(string)) {
                            boolean bl2;
                            String string2 = element.getChildText("code");
                            String string3 = Workbench.getNLSString("inviteWarning" + string2, new Object[0]);
                            if ("UsersNotCommunityMembers".equals(string2)) {
                                StringBuilder stringBuilder = new StringBuilder();
                                Element element3 = element.getChild("values");
                                if (element3 != null) {
                                    List list = element3.getChildren("value");
                                    for (int i = 0; i < list.size(); ++i) {
                                        if (i > 0) {
                                            stringBuilder.append(", ");
                                        }
                                        stringBuilder.append(((Element)list.get(i)).getText());
                                    }
                                }
                                string3 = MessageFormat.format(string3, stringBuilder);
                            }
                            if (bl2 = WDDialog.showYesNoDialog(InvitationDialog.this, string3 = string3 + '\n' + Workbench.getNLSString("continueAnyway", new Object[0]) + '?')) {
                                InvitationDialog.this.sendInvitations(true);
                                return;
                            }
                        } else {
                            System.out.println("sendInvitations returned invalid result status: " + string);
                        }
                    }
                }
                InvitationDialog.this.dispose();
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this, Workbench.getNLSString("inviteInProgress", new Object[0]));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }
}

