/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.financial.ICostRate;

public class CostRate
implements ICostRate,
Cloneable {
    private final double cost;
    private final CostRateUnit rateUnit;

    public CostRate(double d, CostRateUnit costRateUnit) {
        this.cost = d;
        this.rateUnit = costRateUnit;
    }

    public double getCost() {
        return this.cost;
    }

    public CostRateUnit getRateUnit() {
        return this.rateUnit;
    }

    public String getRateUnitCode() {
        return this.rateUnit == null ? null : this.rateUnit.code;
    }

    public String toString() {
        if (this.rateUnit == null) {
            return String.valueOf(this.cost);
        }
        return String.valueOf(this.cost) + this.rateUnit.label;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CostRate)) {
            return false;
        }
        CostRate costRate = (CostRate)object;
        return costRate.cost == this.cost && costRate.rateUnit == this.rateUnit;
    }

    public int hashCode() {
        System.out.println("hashcode cost rate");
        return new Double(this.cost).hashCode() + this.rateUnit.hashCode();
    }

    public CostRate clone() {
        try {
            return (CostRate)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

