/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lwpbeans.util.text;

import com.triloggroup.util.UString;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SocialDateTimeFormat
extends DateFormat {
    private String todayLabel;
    private String yesterdayLabel;
    private Locale locale;
    private DateFormat defaultDateTimeFormat;
    private DateFormat timeFormat;

    public SocialDateTimeFormat(Locale locale, TimeZone timeZone) {
        this(locale, timeZone, null, null);
    }

    public SocialDateTimeFormat(Locale locale, TimeZone timeZone, String string, String string2) {
        this.todayLabel = string;
        this.yesterdayLabel = string2;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (date == null) {
            return stringBuffer;
        }
        long l = System.currentTimeMillis();
        this.calendar.setTimeInMillis(l);
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        this.calendar.setTime(date);
        int n4 = this.calendar.get(1);
        int n5 = this.calendar.get(2);
        int n6 = this.calendar.get(5);
        if (n6 == n3 && n5 == n2 && n4 == n && !UString.isEmpty(this.todayLabel)) {
            stringBuffer.append(this.todayLabel).append(' ');
            this.formatTime(date, stringBuffer);
            return stringBuffer;
        }
        long l2 = l - date.getTime();
        if (l2 > 0L && l2 < 172800000L && !UString.isEmpty(this.yesterdayLabel)) {
            this.calendar.add(5, 1);
            if (this.calendar.get(5) == n3) {
                stringBuffer.append(this.yesterdayLabel).append(' ');
                this.formatTime(date, stringBuffer);
                return stringBuffer;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if ("fr".equals(this.locale.getLanguage())) {
            bl = this.locale.getCountry().length() == 0 || this.locale.getCountry().equals("FR");
        } else if ("en".equals(this.locale.getLanguage())) {
            if ("UK".equals(this.locale.getCountry())) {
                bl = true;
            } else if (this.locale.getCountry().length() == 0 || this.locale.getCountry().equals("US")) {
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
            String string = dateFormatSymbols.getShortMonths()[n5];
            if (bl2) {
                stringBuffer.append(string).append(' ').append(n6);
            } else {
                stringBuffer.append(n6).append(' ').append(string);
            }
            stringBuffer.append(' ');
            if (n4 != n) {
                stringBuffer.append(n4).append(' ');
            }
            this.formatTime(date, stringBuffer);
            return stringBuffer;
        }
        stringBuffer.append(this.getDefaultDateTimeFormat().format(date));
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private StringBuffer formatTime(Date date, StringBuffer stringBuffer) {
        if (this.timeFormat == null) {
            this.timeFormat = DateFormat.getTimeInstance(3, this.getLocale());
            this.timeFormat.setTimeZone(this.getTimeZone());
        }
        stringBuffer.append(this.timeFormat.format(date));
        return stringBuffer;
    }

    private DateFormat getDefaultDateTimeFormat() {
        if (this.defaultDateTimeFormat == null) {
            String string;
            this.defaultDateTimeFormat = DateFormat.getDateTimeInstance(3, 3, this.getLocale());
            if (this.defaultDateTimeFormat instanceof SimpleDateFormat && (string = ((SimpleDateFormat)this.defaultDateTimeFormat).toPattern()).indexOf("yyyy") == -1) {
                string = UString.replaceAll(string, "yy", "yyyy");
                ((SimpleDateFormat)this.defaultDateTimeFormat).applyPattern(string);
            }
            this.defaultDateTimeFormat.setTimeZone(this.getTimeZone());
        }
        return this.defaultDateTimeFormat;
    }

    private Locale getLocale() {
        return this.locale;
    }
}

