/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGTreeTableModel
extends AbstractTableModel
implements ITGTableModel {
    public static final String NAME_TABLECOL = "Name";
    public static final String START_TABLECOL = "StartDate";
    public static final String END_TABLECOL = "EndDate";
    public static final String ID_TABLECOL = "Id";
    public static final String RESOURCES_TABLECOL = "Resources";
    protected boolean showName;
    protected String[] columnNames;
    protected String[] columnKeyNames;
    protected TGChartModel chartModel;
    protected NLSBundle nlsBundle;

    public TGTreeTableModel(TGChartModel tGChartModel, NLSBundle nLSBundle, Locale locale) {
        this(tGChartModel, nLSBundle, locale, null);
    }

    public TGTreeTableModel(TGChartModel tGChartModel, NLSBundle nLSBundle, Locale locale, String[] stringArray) {
        this.chartModel = tGChartModel;
        this.nlsBundle = nLSBundle;
        if (stringArray == null || stringArray.length == 0) {
            stringArray = this.getDefaultColumnKeyNames(tGChartModel);
        }
        this.setVisibleColumns(stringArray);
    }

    public String[] getDefaultColumnKeyNames(TGChartModel tGChartModel) {
        return new String[]{NAME_TABLECOL, ID_TABLECOL, START_TABLECOL, END_TABLECOL, RESOURCES_TABLECOL};
    }

    public void setVisibleColumns(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length == 0) {
            stringArray = new String[]{NAME_TABLECOL};
        }
        if (NAME_TABLECOL.equals(stringArray[0])) {
            this.showName = true;
        } else if (ID_TABLECOL.equals(stringArray[0])) {
            this.showName = false;
        } else {
            int n3;
            n2 = -1;
            n = -1;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (NAME_TABLECOL.equals(stringArray[n3])) {
                    n2 = n3;
                    break;
                }
                if (!ID_TABLECOL.equals(stringArray[n3])) continue;
                n = n3;
            }
            if (n2 > 0) {
                this.showName = true;
                for (n3 = n2; n3 > 0; --n3) {
                    stringArray[n3] = stringArray[n3 - 1];
                }
                stringArray[0] = NAME_TABLECOL;
            } else if (n > 0) {
                this.showName = false;
                for (n3 = n; n3 > 0; --n3) {
                    stringArray[n3] = stringArray[n3 - 1];
                }
                stringArray[0] = ID_TABLECOL;
            }
        }
        n2 = stringArray.length;
        this.columnNames = new String[n2];
        this.columnKeyNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string;
            this.columnKeyNames[n] = string = stringArray[n].intern();
            this.columnNames[n] = this.nlsBundle.getString(string);
        }
        this.fireTableStructureChanged();
    }

    public TGChartModel getChartModel() {
        return this.chartModel;
    }

    @Override
    public boolean isEditable() {
        return this.chartModel.isEditable();
    }

    public TGNode getRoot() {
        return this.chartModel.getRootNode();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        String string = this.columnKeyNames[n];
        if (string == START_TABLECOL || string == END_TABLECOL) {
            return Date.class;
        }
        return String.class;
    }

    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    public void setValueAt(Object object, Object object2, int n, int n2) {
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public String getColumnKeyName(int n) {
        return this.columnKeyNames[n];
    }

    public boolean isColumnVisible(String string) {
        return this.getColumnIndex(string) >= 0;
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.columnKeyNames.length; ++i) {
            if (this.columnKeyNames[i] != string) continue;
            return i;
        }
        return -1;
    }

    public static String[] getColumnKeyNames(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl) {
            bl2 = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(NAME_TABLECOL);
        }
        if (bl2) {
            arrayList.add(ID_TABLECOL);
        }
        if (bl3) {
            arrayList.add(START_TABLECOL);
            arrayList.add(END_TABLECOL);
        }
        if (bl4) {
            arrayList.add(RESOURCES_TABLECOL);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Object getValueAt(Object object, int n) {
        TGNode tGNode = (TGNode)object;
        if (n < this.columnKeyNames.length) {
            String string = this.columnKeyNames[n];
            if (string == NAME_TABLECOL) {
                return tGNode.getName();
            }
            if (string == ID_TABLECOL) {
                String string2 = tGNode.getHierarchicalId();
                if (!this.showName && UString.isEmpty(string2)) {
                    return tGNode.getName();
                }
                return string2;
            }
            if (string == START_TABLECOL) {
                TimePeriod timePeriod = tGNode.getDuration();
                if (timePeriod != null) {
                    return timePeriod.getStart();
                }
                return null;
            }
            if (string == END_TABLECOL) {
                TimePeriod timePeriod = tGNode.getDuration();
                if (timePeriod != null) {
                    return timePeriod.getEnd();
                }
                return null;
            }
            if (string == RESOURCES_TABLECOL) {
                if (tGNode instanceof GanttTask) {
                    return ((GanttTask)tGNode).getResources();
                }
                if (tGNode instanceof GanttWBS) {
                    return ((GanttWBS)tGNode).getResources();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.chartModel.getRowCount();
    }

    public TGNode nodeForRow(int n) {
        return this.chartModel.getNodeByRowIndex(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getValueAt(this.nodeForRow(n), n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isCellEditable(this.nodeForRow(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, this.nodeForRow(n), n, n2);
    }

    @Override
    public boolean isLeaf(int n) {
        return this.nodeForRow(n).isLeaf();
    }

    @Override
    public boolean isValidElement(int n) {
        TGNode tGNode = this.nodeForRow(n);
        return !GanttNode.isSubprojectLink(tGNode) || !((GanttWBS)tGNode).isBrokenSubprojectLink();
    }
}

